/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.HighlightingUtils;
import com.intellij.lang.javascript.refactoring.inline.FunctionInliner;
import com.intellij.lang.javascript.refactoring.inline.VarOrFieldInliner;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.GenericInlineHandler;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInlineHandler
extends InlineActionHandler {
    public boolean isEnabledForLanguage(Language l) {
        return l.isKindOf((Language)JavascriptLanguage.INSTANCE);
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof JSElement;
    }

    public void inlineElement(Project project, Editor editor, PsiElement originalElement) {
        List toCheckForReadonly;
        Collection<Object> allReferences;
        PsiReference invocationReference = editor != null ? TargetElementUtil.findReference((Editor)editor) : null;
        JSInlineSettingsBase settings = this.prepareInlineElement(originalElement, editor, invocationReference != null);
        if (settings == null) {
            return;
        }
        PsiElement element = settings.getElementToSearchReferences();
        Inliner inliner = JSInlineHandler.createInliner(settings);
        if (inliner == null) {
            return;
        }
        if (settings.isOnlyOneReferenceToInline()) {
            allReferences = Collections.singleton(invocationReference);
        } else {
            Ref usagesRef = new Ref();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> usagesRef.set((Object)ReferencesSearch.search((PsiElement)element).findAll()), "Find Usages", false, element.getProject());
            allReferences = (Collection)usagesRef.get();
        }
        MultiMap conflicts = new MultiMap();
        for (PsiReference reference : allReferences) {
            MultiMap<PsiElement, String> conflictsForRef = inliner.getConflicts(reference, element);
            if (conflictsForRef == null) continue;
            conflicts.putAllValues(conflictsForRef);
        }
        if (!conflicts.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
            }
            ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts);
            if (!conflictsDialog.showAndGet()) {
                return;
            }
        }
        List list = toCheckForReadonly = settings.isOnlyOneReferenceToInline() ? ContainerUtil.list((Object[])new PsiElement[]{element}) : ContainerUtil.mapNotNull(allReferences, PsiReference::getElement);
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, (Collection)toCheckForReadonly, (boolean)true)) {
            return;
        }
        String elementName = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : "element";
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project, () -> {
            Object[] references = GenericInlineHandler.sortDepthFirstRightLeftOrder((Collection)allReferences);
            for (UsageInfo usage : ContainerUtil.map((Object[])references, UsageInfo::new)) {
                inliner.inlineUsage(usage, element);
            }
            if (!settings.isOnlyOneReferenceToInline()) {
                JSInlineHandler.removeDefinition(element, settings);
            }
        }, RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{elementName}), null));
    }

    @Nullable
    protected JSInlineSettingsBase prepareInlineElement(@NotNull PsiElement element, Editor editor, boolean invokedOnReference) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler", "prepareInlineElement"));
        }
        JSInlineSettingsBase settings = null;
        NotNullLazyValue<Collection<PsiReference>> elementUsages = JSInlineHandler.getDeferredUsagesForElement(element);
        boolean isSelfReference = false;
        if (editor != null) {
            PsiReference ref = TargetElementUtil.findReference((Editor)editor);
            boolean bl = isSelfReference = ref instanceof JSReferenceExpression && JSResolveUtil.isSelfReference((PsiElement)((JSReferenceExpression)ref));
        }
        if (element instanceof JSVariable) {
            settings = VarOrFieldInliner.handleVariable((JSVariable)element, editor, invokedOnReference, elementUsages, isSelfReference);
        } else if (element instanceof JSFunction) {
            settings = FunctionInliner.handleFunction(element, (JSFunction)element, editor, invokedOnReference, elementUsages, isSelfReference);
        } else {
            PsiElement resolved;
            JSExpression value;
            JSFunction function = JSPsiImplUtils.getPossibleFunction(element);
            if (function != null) {
                settings = FunctionInliner.handleFunction(element, function, editor, invokedOnReference, elementUsages, isSelfReference);
                element = function;
            }
            if (element instanceof ES6Property && ((ES6Property)element).isShorthanded() && (value = ((ES6Property)element).getValue()) instanceof JSReferenceExpression && (resolved = ((JSReferenceExpression)value).resolve()) != null && resolved instanceof JSVariable) {
                elementUsages = JSInlineHandler.getDeferredUsagesForElement(resolved);
                settings = VarOrFieldInliner.handleVariable((JSVariable)resolved, editor, invokedOnReference, elementUsages, isSelfReference);
                element = resolved;
            }
        }
        if (element instanceof JSClass) {
            PsiReference invocationReference;
            PsiReference psiReference = invocationReference = editor != null ? TargetElementUtil.findReference((Editor)editor) : null;
            if (invocationReference != null && invocationReference.getElement() instanceof JSReferenceExpression && invocationReference.getElement().getParent() instanceof JSCallExpression) {
                FunctionInliner.inlineFunctionProblem(JSBundle.message((String)"javascript.refactoring.cannot.inline.constructor", (Object[])new Object[0]), editor, element.getProject());
                return null;
            }
        }
        if (settings != null) {
            Collection value = (Collection)elementUsages.getValue();
            String elementKind = JSBundle.message((String)JSNamedElementKind.kind(element).humanReadableKey(), (Object[])new Object[0]);
            String elementName = ((JSNamedElement)element).getName();
            int occurenceCount = value.size();
            if (occurenceCount == 0) {
                CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)JSBundle.message((String)"javascript.inline.element.is.not.used", (Object[])new Object[]{elementKind, elementName}), (String)"Inline", null);
                return null;
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                if (editor != null) {
                    ArrayList<PsiReference> referencesToHighlightFromCurrentEditor = new ArrayList<PsiReference>();
                    VirtualFile file = JSInlineHandler.getPhysicalFileOfEditor(editor);
                    for (PsiReference ref : (Collection)elementUsages.getValue()) {
                        if (!Comparing.equal((Object)file, (Object)JSInlineHandler.getVirtualFile(ref.getElement().getContainingFile()))) continue;
                        referencesToHighlightFromCurrentEditor.add(ref);
                    }
                    settings.highlightUsages(editor, referencesToHighlightFromCurrentEditor);
                }
                String kind = StringUtil.decapitalize((String)elementKind);
                String inlineTitle = JSBundle.message((String)"inline.0.dialog.title", (Object[])new Object[]{StringUtil.capitalizeWords((String)elementKind, (boolean)true)});
                String inlineAllMessage = "Inline " + kind + " '" + elementName + "'" + (!settings.isOnlyOneReferenceToInline() ? "?" : "") + " (" + occurenceCount + " occurrence" + (occurenceCount > 1 ? "s" : "") + ")";
                Object dialog = settings.isOnlyOneReferenceToInline() ? new JSInlineOptionsDialog(element.getProject(), element, settings, inlineTitle, inlineAllMessage + (element.isWritable() ? " and remove the " + kind : ""), "Inline this usage and keep the " + kind, elementKind + " '" + elementName + "'") : new RefactoringMessageDialog(inlineTitle, inlineAllMessage, null, "OptionPane.questionIcon", true, element.getProject());
                if (!dialog.showAndGet()) {
                    return null;
                }
                if (dialog instanceof JSInlineOptionsDialog) {
                    settings.setOneRefToInline(((JSInlineOptionsDialog)((Object)dialog)).isInlineThisOnly());
                }
            }
        }
        return settings;
    }

    @NotNull
    private static NotNullLazyValue<Collection<PsiReference>> getDeferredUsagesForElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler", "getDeferredUsagesForElement"));
        }
        final PsiElement elementFinal = element;
        NotNullLazyValue<Collection<PsiReference>> notNullLazyValue = new NotNullLazyValue<Collection<PsiReference>>(){

            @NotNull
            protected Collection<PsiReference> compute() {
                ArrayList<PsiReference> referenceCollection = new ArrayList<PsiReference>();
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    SearchScope useScope = (SearchScope)ReadAction.compute(() -> elementFinal.getUseScope());
                    ReferencesSearch.search((PsiElement)elementFinal, (SearchScope)useScope).forEach(psiReference -> {
                        if (psiReference.getElement().getParent() != elementFinal) {
                            referenceCollection.add((PsiReference)psiReference);
                        }
                        return true;
                    });
                }, JSBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), false, elementFinal.getProject());
                ArrayList<PsiReference> arrayList = referenceCollection;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler$1", "compute"));
                }
                return arrayList;
            }
        };
        if (notNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler", "getDeferredUsagesForElement"));
        }
        return notNullLazyValue;
    }

    public static boolean isInlinableReference(PsiReference psiReference) {
        return !(psiReference instanceof JSTextReference) || !psiReference.isSoft();
    }

    static VirtualFile getPhysicalFileOfEditor(Editor editor) {
        PsiFile psifile = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument());
        return JSInlineHandler.getVirtualFile(psifile);
    }

    static VirtualFile getVirtualFile(PsiFile psifile) {
        VirtualFile file = psifile.getVirtualFile();
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        return file;
    }

    private static void removeDefinition(PsiElement element, JSInlineSettingsBase settings) {
        if (element instanceof JSVariable && settings instanceof VarOrFieldInliner.MySettings) {
            VarOrFieldInliner.removeDefinition(element, (VarOrFieldInliner.MySettings)settings);
        } else {
            ASTNode prev;
            PsiElement whitespace;
            if (element instanceof JSFunction && element.getParent() instanceof JSClass && (whitespace = (prev = element.getNode().getTreePrev()).getPsi()) instanceof PsiWhiteSpace) {
                whitespace.delete();
            }
            element.delete();
        }
        if (settings.editor != null) {
            HighlightingUtils.highlightOccurrences(settings.editor.getProject(), settings.editor, new HighlightingUtils.RangesOccurrenceInfoSource(settings.myHighlightedMarkers));
        }
    }

    @Nullable
    private static Inliner createInliner(JSInlineSettingsBase settings) {
        PsiElement element = settings.getElementToSearchReferences();
        if (element instanceof JSVariable) {
            return new VarOrFieldInliner((JSVariable)element, (VarOrFieldInliner.MySettings)settings);
        }
        JSFunction function = JSPsiImplUtils.getPossibleFunction(element);
        if (function != null) {
            return new FunctionInliner(element);
        }
        return null;
    }

    static void addThisReference(PsiElement node, PsiElement qualifier, PsiElement psiElement, int funOffset, Set<RangeMarker> thisRefs, Document document) {
        if ((psiElement instanceof JSFunction || psiElement instanceof JSVariable) && JSResolveUtil.findParent(psiElement) instanceof JSClass) {
            if (JSResolveUtil.isConstructorFunction(psiElement)) {
                return;
            }
            JSInlineHandler.doAddThisReference(node, qualifier, funOffset, thisRefs, document);
        }
    }

    static void doAddThisReference(PsiElement node, PsiElement qualifier, int funOffset, Set<RangeMarker> thisRefs, Document document) {
        TextRange range;
        if (qualifier != null) {
            range = qualifier.getTextRange().shiftRight(funOffset);
        } else {
            int offset = node.getTextRange().getStartOffset() + funOffset;
            range = new TextRange(offset, offset);
        }
        thisRefs.add(document.createRangeMarker(range));
    }

    static interface Inliner {
        @Nullable
        public MultiMap<PsiElement, String> getConflicts(PsiReference var1, PsiElement var2);

        public void inlineUsage(@NotNull UsageInfo var1, @NotNull PsiElement var2);
    }

    private static class JSInlineOptionsDialog
    extends InlineOptionsDialog {
        private JSInlineSettingsBase mySettings;
        private String myInlineAllText;
        private String myInlineThisText;
        private String myNameLabelText;

        protected JSInlineOptionsDialog(Project project, PsiElement element, JSInlineSettingsBase settings, String title, String inlineAllText, String inlineThisText, String nameLabelText) {
            super(project, true, element);
            this.mySettings = settings;
            this.myInlineAllText = inlineAllText;
            this.myInlineThisText = inlineThisText;
            this.myNameLabelText = nameLabelText;
            this.myInvokedOnReference = !settings.isSelfReference();
            this.setTitle(title);
            this.init();
        }

        protected String getNameLabelText() {
            return this.myNameLabelText;
        }

        protected String getBorderTitle() {
            return "Inline";
        }

        protected String getInlineAllText() {
            return this.myInlineAllText;
        }

        protected String getInlineThisText() {
            return this.myInlineThisText;
        }

        protected boolean isInlineThis() {
            return this.mySettings.isOnlyOneReferenceToInline();
        }

        protected void doAction() {
            this.close(0);
        }

        protected boolean hasHelpAction() {
            return false;
        }

        protected boolean hasPreviewButton() {
            return false;
        }
    }

    protected static class JSInlineSettingsBase {
        final List<RangeMarker> myHighlightedMarkers = new ArrayList<RangeMarker>();
        @Nullable
        final Editor editor;
        private boolean myOneRefToInline;
        private final PsiFile myFile;
        private final boolean myIsSelfReference;
        private PsiElement elementToSearchForReferences;

        public JSInlineSettingsBase(PsiElement elementToSearchForReferences, boolean oneRefToInline, PsiFile file, @Nullable Editor editor, boolean isSelfReference) {
            this.elementToSearchForReferences = elementToSearchForReferences;
            this.myOneRefToInline = oneRefToInline;
            this.myFile = file;
            this.myIsSelfReference = isSelfReference;
            this.editor = editor != null ? InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)file) : null;
        }

        public void addRangeHighlighterForPsiElement(PsiElement element) {
            if (this.editor != null && element.getContainingFile() == this.myFile) {
                this.myHighlightedMarkers.add(this.editor.getDocument().createRangeMarker(element.getTextRange()));
            }
        }

        public boolean isOnlyOneReferenceToInline() {
            return this.myOneRefToInline;
        }

        public void setOneRefToInline(boolean oneRefToInline) {
            this.myOneRefToInline = oneRefToInline;
        }

        public void highlightUsages(Editor editor, Collection<PsiReference> refs) {
            ArrayList<PsiElement> refsToHighlight = new ArrayList<PsiElement>();
            for (PsiReference ref : refs) {
                refsToHighlight.add(ref.getElement());
            }
            Project project = editor.getProject();
            HighlightingUtils.doHighlightOccurences(project, editor, new HighlightingUtils.PsiElementsOccurrenceInfoSource(PsiUtilCore.toPsiElementArray(refsToHighlight)), false);
            HighlightingUtils.informThatHighlightingCanbeRemoved(project);
        }

        @NotNull
        public PsiElement getElementToSearchReferences() {
            PsiElement psiElement = this.elementToSearchForReferences;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler$JSInlineSettingsBase", "getElementToSearchReferences"));
            }
            return psiElement;
        }

        public boolean isSelfReference() {
            return this.myIsSelfReference;
        }
    }
}

