/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.util;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMemberInfo
extends MemberInfoBase<JSAttributeListOwner> {
    private final boolean myExtendsList;
    private static final Comparator<JSMemberInfo> BY_OFFSET_COMPARATOR = (o1, o2) -> {
        JSAttributeListOwner member1 = (JSAttributeListOwner)o1.getMember();
        JSAttributeListOwner member2 = (JSAttributeListOwner)o2.getMember();
        if (member1 instanceof JSClass && member2 instanceof JSClass) {
            return Comparing.compare((Comparable)((Object)member1.getName()), (Comparable)((Object)member2.getName()));
        }
        if (member1 instanceof JSClass) {
            return -1;
        }
        if (member2 instanceof JSClass) {
            return 1;
        }
        return member1.getTextOffset() - member2.getTextOffset();
    };

    private JSMemberInfo(@NotNull JSField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/lang/javascript/refactoring/util/JSMemberInfo", "<init>"));
        }
        super((PsiElement)field);
        this.myExtendsList = false;
        this.isStatic = field.getAttributeList() != null && field.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC);
        this.displayName = JSMemberInfo.getFieldName(field);
        this.overrides = null;
    }

    @NotNull
    public static String getFieldName(@NotNull JSField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/lang/javascript/refactoring/util/JSMemberInfo", "getFieldName"));
        }
        String string = JSFormatUtil.formatField((JSTypeDeclarationOwner)field, 7);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/util/JSMemberInfo", "getFieldName"));
        }
        return string;
    }

    private JSMemberInfo(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/refactoring/util/JSMemberInfo", "<init>"));
        }
        super((PsiElement)method);
        this.myExtendsList = false;
        this.isStatic = method.getAttributeList() != null && method.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC);
        this.displayName = JSMemberInfo.getFunctionName(method);
        this.overrides = JSMemberInfo.determineOverrides(method);
    }

    @NotNull
    public static String getFunctionName(@NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/refactoring/util/JSMemberInfo", "getFunctionName"));
        }
        String string = JSFormatUtil.formatMethod(method, 263, 7);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/util/JSMemberInfo", "getFunctionName"));
        }
        return string;
    }

    @Nullable
    private static Boolean determineOverrides(JSFunction method) {
        if (!JSInheritanceUtil.findNearestOverriddenMembers((JSPsiElementBase)method, true).isEmpty()) {
            return true;
        }
        if (!JSInheritanceUtil.findImplementedMethods(method).isEmpty()) {
            return false;
        }
        return null;
    }

    private JSMemberInfo(JSClass aClass, boolean extendsNotImplements) {
        super((PsiElement)aClass);
        assert (aClass.isInterface());
        this.myExtendsList = extendsNotImplements;
        this.displayName = RefactoringBundle.message((String)(extendsNotImplements ? "member.info.extends.0" : "member.info.implements.0"), (Object[])new Object[]{aClass.getName()});
        this.overrides = Boolean.FALSE;
    }

    public static void extractStaticMembers(JSClass clazz, List<JSMemberInfo> result, final MemberInfoBase.Filter<JSAttributeListOwner> filter) {
        JSMemberInfo.extractClassMembers(clazz, result, new MemberInfoBase.Filter<JSAttributeListOwner>(){

            public boolean includeMember(JSAttributeListOwner member) {
                return (member instanceof JSVariable || member instanceof JSFunction) && member.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC) && filter.includeMember((PsiElement)member);
            }
        });
    }

    public static void extractClassMembers(JSClass clazz, List<JSMemberInfo> result, MemberInfoBase.Filter<JSAttributeListOwner> filter) {
        JSReferenceList interfacesList;
        JSReferenceList jSReferenceList = interfacesList = clazz.isInterface() ? clazz.getExtendsList() : clazz.getImplementsList();
        if (interfacesList != null) {
            for (JSClass jSClass : interfacesList.getReferencedClasses()) {
                if (!filter.includeMember((PsiElement)jSClass)) continue;
                result.add(new JSMemberInfo(jSClass, clazz.isInterface()));
            }
        }
        for (JSClass jSClass : clazz.getFunctions()) {
            if (jSClass.getKind() == JSFunction.FunctionKind.CONSTRUCTOR || jSClass.isSetProperty() && clazz.findFunctionByNameAndKind(jSClass.getName(), JSFunction.FunctionKind.GETTER) != null || jSClass.getContainingFile().getContext() == null && !jSClass.getContainingFile().equals(clazz.getContainingFile()) || !filter.includeMember((PsiElement)jSClass)) continue;
            result.add(new JSMemberInfo((JSFunction)jSClass));
        }
        for (JSClass jSClass : clazz.getFields()) {
            if (!filter.includeMember((PsiElement)jSClass)) continue;
            result.add(new JSMemberInfo((JSField)jSClass));
        }
    }

    public boolean isExtendsNotImplements() {
        return this.myExtendsList;
    }

    public void setChecked(Collection<JSElement> selected) {
        JSAttributeListOwner member = (JSAttributeListOwner)this.getMember();
        this.setChecked(selected.contains(member) || member instanceof JSFunction && ((JSFunction)member).isGetProperty() && selected.contains(JSUtils.getMemberContainingClass((PsiElement)member).findFunctionByNameAndKind(member.getName(), JSFunction.FunctionKind.SETTER)));
    }

    @NotNull
    public static JSMemberInfo[] getSelected(JSMemberInfo[] memberInfos, JSClass clazz, Condition<JSMemberInfo> filter) {
        JSMemberInfo[] jSMemberInfoArray = JSMemberInfo.getSelected(Arrays.asList(memberInfos), clazz, filter);
        if (jSMemberInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/util/JSMemberInfo", "getSelected"));
        }
        return jSMemberInfoArray;
    }

    @NotNull
    public static JSMemberInfo[] getSelected(Collection<JSMemberInfo> memberInfos, JSClass clazz, Condition<JSMemberInfo> filter) {
        ArrayList<JSMemberInfo> result = new ArrayList<JSMemberInfo>();
        for (JSMemberInfo memberInfo : memberInfos) {
            JSFunction setter;
            if (!filter.value((Object)memberInfo) || !memberInfo.isChecked()) continue;
            result.add(memberInfo);
            JSAttributeListOwner member = (JSAttributeListOwner)memberInfo.getMember();
            if (!(member instanceof JSFunction) || !((JSFunction)member).isGetProperty() || (setter = clazz.findFunctionByNameAndKind(member.getName(), JSFunction.FunctionKind.SETTER)) == null) continue;
            JSMemberInfo setterInfo = new JSMemberInfo(setter);
            setterInfo.setChecked(true);
            result.add(setterInfo);
        }
        JSMemberInfo[] jSMemberInfoArray = result.toArray(new JSMemberInfo[result.size()]);
        if (jSMemberInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/util/JSMemberInfo", "getSelected"));
        }
        return jSMemberInfoArray;
    }

    @NotNull
    public static Collection<JSAttributeListOwner> getStatics(@NotNull JSMemberInfo[] members) {
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "com/intellij/lang/javascript/refactoring/util/JSMemberInfo", "getStatics"));
        }
        ArrayList<JSAttributeListOwner> staticMembers = new ArrayList<JSAttributeListOwner>();
        for (JSMemberInfo memberInfo : members) {
            if (!memberInfo.isStatic()) continue;
            staticMembers.add((JSAttributeListOwner)memberInfo.getMember());
        }
        ArrayList<JSAttributeListOwner> arrayList = staticMembers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/util/JSMemberInfo", "getStatics"));
        }
        return arrayList;
    }

    public static void sortByOffset(JSMemberInfo[] memberInfos) {
        Arrays.sort(memberInfos, BY_OFFSET_COMPARATOR);
    }

    public static void sortByOffset(List<JSMemberInfo> memberInfos) {
        Collections.sort(memberInfos, BY_OFFSET_COMPARATOR);
    }

    public static void extractSameMembers(JSClass from, final JSClass originalClass, JSMemberInfo[] originalClassSelectedMembers, List<JSMemberInfo> result) {
        final HashSet<PsiElement> selectedMembers = new HashSet<PsiElement>();
        for (JSMemberInfo originalMember : originalClassSelectedMembers) {
            selectedMembers.add(originalMember.getMember());
        }
        JSMemberInfo.extractClassMembers(from, result, new MemberInfoBase.Filter<JSAttributeListOwner>(){

            public boolean includeMember(JSAttributeListOwner member) {
                if (member instanceof JSFunction) {
                    return selectedMembers.contains(originalClass.findFunctionByNameAndKind(member.getName(), ((JSFunction)member).getKind()));
                }
                if (member instanceof JSField) {
                    return selectedMembers.contains(originalClass.findFieldByName(member.getName()));
                }
                if (member instanceof JSClass) {
                    return JSPsiImplUtils.containsEquivalent(selectedMembers, (PsiElement)member);
                }
                LOG.error((Object)member);
                return false;
            }
        });
    }
}

