/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.util;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.JSE4XNamespaceReference;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.FindReferenceUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSMemberUsageInfo;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.lang.javascript.validation.fixes.ImplementMethodsFix;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRefactoringUtil {
    public static final String _PROTO = "__proto__";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil");

    public static JSFunction buildAbstractMethod(JSFunction method) {
        method = (JSFunction)method.copy();
        JSSourceElement[] body = method.getBody();
        assert (body.length < 2);
        if (body.length > 0) {
            body[0].delete();
        }
        if (method.getLastChild() instanceof PsiWhiteSpace) {
            method.getLastChild().delete();
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(method.getAttributeList());
        wrapper.removeAccessModifier();
        wrapper.overrideModifier(JSAttributeList.ModifierType.FINAL, false);
        wrapper.overrideModifier(JSAttributeList.ModifierType.OVERRIDE, false);
        wrapper.applyTo((JSAttributeListOwner)method);
        String text = "interface Foo {" + method.getText() + "; }";
        JSClass clazz = (JSClass)JSChangeUtil.createJSTreeFromText(method.getProject(), text, JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
        return clazz.findFunctionByName(method.getName());
    }

    @Nullable
    public static String removeFromReferenceList(@NotNull JSReferenceList refList, @NotNull JSClass aClass, Collection<FormatFixer> formatters) {
        if (refList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refList", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil", "removeFromReferenceList"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil", "removeFromReferenceList"));
        }
        JSReferenceExpression ref = JSRefactoringUtil.findReferenceToClass(refList, aClass);
        if (ref != null) {
            String refText = ref.getText();
            if (XmlBackedJSClassImpl.isImplementsAttribute((JSFile)refList.getContainingFile())) {
                ((XmlBackedJSClassImpl)JSResolveUtil.findParentClass((JSFile)refList.getContainingFile())).removeFromImplementsList(refText);
            } else {
                formatters.add(FormatFixer.create(JSRefactoringUtil.getElementToFormat((PsiElement)ref), FormatFixer.Mode.FirstLinebreak));
                ref.delete();
            }
            return refText;
        }
        return null;
    }

    @Nullable
    private static JSReferenceExpression findReferenceToClass(JSReferenceList refList, JSClass aClass) {
        JSExpression[] expressions = refList.getExpressions();
        if (expressions.length == 0) {
            return null;
        }
        String name = aClass.getQualifiedName();
        if (name == null) {
            return null;
        }
        for (JSExpression expression : expressions) {
            String typeName;
            if (!(expression instanceof JSReferenceExpression) || !name.equals(typeName = JSImportHandlingUtil.resolveTypeName(expression.getText(), (PsiElement)refList))) continue;
            return (JSReferenceExpression)expression;
        }
        return null;
    }

    public static void addToSupersList(@NotNull JSClass clazz, @NotNull String refText, boolean isInterface) {
        JSReferenceList refList;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil", "addToSupersList"));
        }
        if (refText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refText", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil", "addToSupersList"));
        }
        if (clazz instanceof XmlBackedJSClassImpl) {
            ((XmlBackedJSClassImpl)clazz).addToImplementsList(refText);
            return;
        }
        boolean addToExtends = clazz.isInterface() || !isInterface;
        JSReferenceList jSReferenceList = refList = addToExtends ? clazz.getExtendsList() : clazz.getImplementsList();
        if (refList != null) {
            PsiElement expr = JSChangeUtil.createJSTreeFromText(clazz.getProject(), "foo, " + refText, JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
            PsiElement el = expr.getFirstChild().getFirstChild().getNextSibling();
            refList.addRangeAfter(el, el.getNextSibling().getNextSibling(), refList.getLastChild());
        } else {
            String text = "class Foo " + (addToExtends ? "extends " : "implements ") + refText;
            JSClass c = (JSClass)JSChangeUtil.createJSTreeFromText(clazz.getProject(), text, JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
            clazz.addAfter((PsiElement)(addToExtends ? c.getExtendsList() : c.getImplementsList()), (PsiElement)(clazz.getExtendsList() != null ? clazz.getExtendsList() : clazz.getNameIdentifier()));
        }
    }

    public static void makeQualified(JSReferenceExpression refExpr, @Nullable JSQualifiedNamedElement to, boolean force) {
        JSExpression qualifier = refExpr.getQualifier();
        if (to != null) {
            if (qualifier == null) {
                qualifier = (JSExpression)JSChangeUtil.createExpressionFromText(refExpr.getProject(), "IntellijIDEARulezz.IntellijIDEARulezz").getPsi();
                qualifier = (JSExpression)refExpr.addRangeBefore(qualifier.getFirstChild(), qualifier.getFirstChild().getNextSibling(), refExpr.getFirstChild());
            }
            if (force || qualifier instanceof JSReferenceExpression) {
                if (qualifier instanceof JSReferenceExpression) {
                    JSRefactoringUtil.makeQualified((JSReferenceExpression)qualifier, null, false);
                    JSReferenceExpressionImpl.bindToElement((JSReferenceExpression)qualifier, to.getQualifiedName(), (PsiNamedElement)to, true);
                } else {
                    JSRefactoringUtil.makeQualified(refExpr, null, false);
                    JSRefactoringUtil.makeQualified(refExpr, to, false);
                }
            }
        } else if (qualifier != null) {
            refExpr.deleteChildRange((PsiElement)qualifier, qualifier.getNextSibling());
        }
    }

    public static boolean isChildOfAny(PsiElement element, Collection<? extends PsiElement> ancestors) {
        for (PsiElement psiElement : ancestors) {
            if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOrWillBeInTargetClass(PsiElement place, Collection<? extends PsiElement> membersToMove, @Nullable JSClass targetClass, boolean includeSubclasses) {
        if (JSRefactoringUtil.isChildOfAny(place, membersToMove)) {
            return true;
        }
        JSClass clazz = JSResolveUtil.getClassOfContext(place);
        if (clazz == null || targetClass == null) {
            return false;
        }
        return targetClass.equals(clazz) || includeSubclasses && JSInheritanceUtil.isParentClass(clazz, targetClass);
    }

    public static JSVarStatement getVarStatementCopy(JSVariable member) {
        int index = 0;
        for (JSVariable variable : (JSVariable[])PsiTreeUtil.getChildrenOfType((PsiElement)member.getParent(), JSVariable.class)) {
            if (member == variable) break;
            ++index;
        }
        JSVarStatement result = (JSVarStatement)member.getParent().copy();
        JSVariable[] newVars = (JSVariable[])PsiTreeUtil.getChildrenOfType((PsiElement)result, JSVariable.class);
        JSVariable newVar = newVars[index];
        while (newVars.length > 1) {
            if (newVars[0] != newVar) {
                newVars[0].delete();
            } else {
                newVars[1].delete();
            }
            newVars = (JSVariable[])PsiTreeUtil.getChildrenOfType((PsiElement)result, JSVariable.class);
        }
        return result;
    }

    public static Collection<PsiFile> qualifyIncomingReferences(UsageInfo[] usages) {
        HashSet<PsiFile> filesWithUsages = new HashSet<PsiFile>();
        for (UsageInfo usageInfo : usages) {
            JSMemberUsageInfo usage = (JSMemberUsageInfo)usageInfo;
            PsiFile file = usage.getElement().getContainingFile();
            XmlBackedJSClass xmlBackedClass = JSResolveUtil.getXmlBackedClass((JSFile)file);
            filesWithUsages.add(xmlBackedClass != null ? xmlBackedClass.getContainingFile() : file);
            JSRefactoringUtil.makeQualified((JSReferenceExpression)usage.getElement(), (JSQualifiedNamedElement)usage.qualifierClass, false);
        }
        return filesWithUsages;
    }

    @Nullable
    private static JSMemberUsageInfo getUsage(JSAttributeListOwner member, PsiReference psiReference, Collection<JSAttributeListOwner> membersToMove, JSClass targetClass) {
        PsiElement ref = psiReference.getElement();
        if (!(ref instanceof JSReferenceExpression)) {
            return null;
        }
        JSReferenceExpression refExpr = (JSReferenceExpression)ref;
        JSExpression qualifier = refExpr.getQualifier();
        if (JSRefactoringUtil.isOrWillBeInTargetClass((PsiElement)refExpr, membersToMove, targetClass, true)) {
            if (!JSRefactoringUtil.isChildOfAny((PsiElement)refExpr, membersToMove)) {
                return new JSMemberUsageInfo(member, refExpr, null, psiReference);
            }
            if (qualifier instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).isReferenceTo((PsiElement)JSUtils.getMemberContainingClass((PsiElement)member))) {
                return new JSMemberUsageInfo(member, refExpr, null, psiReference);
            }
            return null;
        }
        return new JSMemberUsageInfo(member, refExpr, targetClass, psiReference);
    }

    public static UsageInfo[] getUsages(Collection<JSAttributeListOwner> members, JSClass targetClass) {
        ArrayList<JSMemberUsageInfo> usagesList = new ArrayList<JSMemberUsageInfo>();
        for (JSAttributeListOwner member : members) {
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)member)) {
                JSMemberUsageInfo usage = JSRefactoringUtil.getUsage(member, psiReference, members, targetClass);
                if (usage == null) continue;
                usagesList.add(usage);
            }
        }
        UsageInfo[] usageInfos = usagesList.toArray(new UsageInfo[usagesList.size()]);
        usageInfos = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        return usageInfos;
    }

    @Nullable
    public static JSNamespaceDeclaration getNamespace(PsiElement element) {
        PsiElement namespace;
        JSReferenceExpression namespaceRef;
        JSAttributeList attributeList;
        if (element instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)element).getAttributeList()) != null && (namespaceRef = attributeList.getNamespaceElement()) != null && (namespace = namespaceRef.resolve()) instanceof JSNamespaceDeclaration) {
            return (JSNamespaceDeclaration)namespace;
        }
        return null;
    }

    public static PsiElement fixOutgoingReferences(PsiElement scope, Collection<String> imports, Collection<String> namespaces, Collection<JSAttributeListOwner> membersToMove, @Nullable JSClass targetClass, boolean justCollectImports, boolean visibilityWillChange) {
        JSReferenceExpression refExpr;
        PsiElement resolved;
        if (scope instanceof JSReferenceExpression && (resolved = (refExpr = (JSReferenceExpression)scope).resolve()) instanceof JSQualifiedNamedElement) {
            String qName;
            JSNamespaceDeclaration namespaceDecl;
            boolean isReferenceToMovedMember = JSRefactoringUtil.isChildOfAny(resolved, membersToMove);
            if (!(PsiTreeUtil.isAncestor((PsiElement)resolved, (PsiElement)refExpr, (boolean)false) || isReferenceToMovedMember && visibilityWillChange || (namespaceDecl = JSRefactoringUtil.getNamespace(resolved)) == null)) {
                qName = namespaceDecl.getQualifiedName();
                JSE4XNamespaceReference namespaceRef = (JSE4XNamespaceReference)PsiTreeUtil.getChildOfType((PsiElement)refExpr, JSE4XNamespaceReference.class);
                if (!"AS3".equals(qName)) {
                    if (namespaceRef == null) {
                        namespaces.add(qName);
                    }
                    if (qName.indexOf(46) != -1) {
                        imports.add(qName);
                    }
                }
            }
            if (!isReferenceToMovedMember || resolved instanceof JSClass) {
                PsiElement r;
                JSClass containingClass = JSUtils.getMemberContainingClass(resolved);
                if (containingClass == null) {
                    JSType type = JSNamedType.createType(((JSQualifiedNamedElement)resolved).getQualifiedName(), JSTypeSourceFactory.createTypeSource(resolved), JSContext.INSTANCE);
                    if (JSTypeUtils.isActionScriptVectorType(type)) {
                        JSRefactoringUtil.processChildren((PsiElement)refExpr, imports, namespaces, membersToMove, targetClass, justCollectImports, visibilityWillChange);
                        return refExpr;
                    }
                    String qName2 = type.getTypeText();
                    if (qName2.indexOf(46) != -1) {
                        imports.add(qName2);
                    }
                    if (!justCollectImports && refExpr.getQualifier() == null && !(refExpr.getParent() instanceof JSE4XNamespaceReference)) {
                        refExpr = JSReferenceExpressionImpl.bindToElement(refExpr, qName2, (PsiNamedElement)resolved, true);
                    }
                    return refExpr;
                }
                if (JSResolveUtil.isConstructorFunction(resolved) && JSTypeUtils.isActionScriptVectorType(JSNamedType.createType(containingClass.getQualifiedName(), JSTypeSource.EMPTY, JSContext.INSTANCE))) {
                    JSRefactoringUtil.processChildren((PsiElement)refExpr, imports, namespaces, membersToMove, targetClass, justCollectImports, visibilityWillChange);
                } else if (refExpr.getQualifier() == null) {
                    if (targetClass == null || !JSInheritanceUtil.isParentClass(targetClass, containingClass, false)) {
                        qName = containingClass.getQualifiedName();
                        if (!justCollectImports) {
                            String packageName;
                            Object bindTo = JSResolveUtil.isConstructorFunction(resolved) ? ((packageName = StringUtil.getPackageName((String)qName)).isEmpty() ? null : new JSPackageWrapper(packageName, containingClass.getProject(), null)) : containingClass;
                            JSRefactoringUtil.makeQualified(refExpr, (JSQualifiedNamedElement)bindTo, false);
                        }
                        if (qName.indexOf(46) != -1) {
                            imports.add(qName);
                        }
                        return refExpr;
                    }
                } else if (refExpr.getQualifier() instanceof JSReferenceExpression && (r = ((JSReferenceExpression)refExpr.getQualifier()).resolve()) instanceof JSClass && targetClass != null && JSInheritanceUtil.isParentClass(targetClass, (JSClass)r, false)) {
                    if (!justCollectImports) {
                        JSRefactoringUtil.makeQualified(refExpr, null, false);
                    }
                    return refExpr;
                }
            }
        }
        JSRefactoringUtil.processChildren(scope, imports, namespaces, membersToMove, targetClass, justCollectImports, visibilityWillChange);
        return scope;
    }

    private static void processChildren(PsiElement scope, Collection<String> imports, Collection<String> namespaces, Collection<JSAttributeListOwner> membersToMove, JSClass targetClass, boolean justCollectImports, boolean visibilityWillChange) {
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            child = JSRefactoringUtil.fixOutgoingReferences(child, imports, namespaces, membersToMove, targetClass, justCollectImports, visibilityWillChange);
        }
    }

    public static void postProcess(@Nullable PsiElement sourceClassOrFile, JSQualifiedNamedElement targetClass, Collection<PsiFile> filesWithExternalUsages, Collection<String> importsInTargetFile, Collection<String> namespacesInTargetFile, List<FormatFixer> postponedFormatters, boolean allowFormat, boolean forceOptimizeImports) {
        String targetFqn;
        String targetPackageName;
        if (sourceClassOrFile != null) {
            PsiFile sourceFile = sourceClassOrFile instanceof JSClass ? (sourceClassOrFile instanceof XmlBackedJSClass ? sourceClassOrFile.getParent().getContainingFile() : sourceClassOrFile.getContainingFile()) : (PsiFile)sourceClassOrFile;
            postponedFormatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(sourceFile));
        }
        if ((targetPackageName = StringUtil.getPackageName((String)(targetFqn = targetClass.getQualifiedName()))).length() > 0) {
            for (PsiFile file : filesWithExternalUsages) {
                Object place = file instanceof JSFile ? JSPsiImplUtils.findPackageStatement((JSFile)file) : XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)file);
                if (place == null) continue;
                String placeFqn = place.getQualifiedName();
                if (placeFqn == null || !targetPackageName.equals(StringUtil.getPackageName((String)placeFqn))) {
                    ImportUtils.insertImportStatements((PsiElement)place, Collections.singletonList(targetFqn));
                }
                postponedFormatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(file));
            }
        }
        postponedFormatters.addAll(JSRefactoringUtil.addUseNamespaceDirectives(targetClass, namespacesInTargetFile));
        if (!importsInTargetFile.isEmpty() || forceOptimizeImports) {
            PsiFile file = targetClass.getContainingFile();
            ImportUtils.insertImportStatements((PsiElement)targetClass, importsInTargetFile);
            postponedFormatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(file));
        }
        if (allowFormat) {
            JSRefactoringUtil.format(postponedFormatters);
        }
    }

    public static Collection<FormatFixer> addUseNamespaceDirectives(JSQualifiedNamedElement targetClass, Collection<String> namespaces) {
        JSUseNamespaceDirective[] existing;
        if (namespaces.isEmpty()) {
            return Collections.emptyList();
        }
        JSQualifiedNamedElement container = targetClass;
        if (container.getParent() instanceof JSPackageStatement) {
            container = (JSElement)container.getParent();
        }
        if ((existing = (JSUseNamespaceDirective[])PsiTreeUtil.getChildrenOfType((PsiElement)container, JSUseNamespaceDirective.class)) != null) {
            for (JSUseNamespaceDirective directive : existing) {
                PsiElement resolved;
                JSReferenceExpression ref = directive.getNamespaceReference();
                if (ref == null || !((resolved = ref.resolve()) instanceof JSNamespaceDeclaration)) continue;
                String qName = ((JSNamespaceDeclaration)resolved).getQualifiedName();
                Iterator<String> i = namespaces.iterator();
                while (i.hasNext()) {
                    if (!qName.equals(i.next())) continue;
                    i.remove();
                    if (!namespaces.isEmpty()) continue;
                    return Collections.emptyList();
                }
            }
        }
        ArrayList<String> sortedNamespaces = new ArrayList<String>(namespaces);
        Collections.sort(sortedNamespaces, (o1, o2) -> -StringUtil.getShortName((String)o1).compareTo(StringUtil.getShortName((String)o2)));
        PsiElement anchor = JSRefactoringUtil.getImportDirectiveAnchor((JSElement)container);
        PsiElement firstAdded = null;
        PsiElement lastAdded = null;
        ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
        for (String namespace : sortedNamespaces) {
            String text = "use namespace " + namespace + JSCodeStyleSettings.getSemicolon(targetClass.getContainingFile());
            PsiElement newDirective = JSChangeUtil.createJSTreeFromText(targetClass.getProject(), text, JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
            PsiElement added = container.addBefore(newDirective, anchor);
            if (firstAdded == null) {
                firstAdded = added;
            }
            lastAdded = added;
            anchor = added;
        }
        formatters.add(FormatFixer.create(firstAdded, lastAdded, FormatFixer.Mode.Reformat));
        return formatters;
    }

    private static PsiElement getImportDirectiveAnchor(JSElement targetClass) {
        PsiElement anchor = targetClass instanceof XmlBackedJSClassImpl ? ((XmlBackedJSClassImpl)targetClass).findFirstScriptTag().getFirstChild() : ImportUtils.findLBrace(targetClass);
        while (anchor instanceof PsiWhiteSpace || anchor instanceof JSImportStatement || !(anchor instanceof JSSourceElement)) {
            anchor = anchor.getNextSibling();
        }
        return anchor;
    }

    public static void format(List<FormatFixer> postponedFormatters) {
        postponedFormatters = FormatFixer.merge(postponedFormatters);
        FormatFixer.fixAll(postponedFormatters);
    }

    public static PsiElement getElementToFormat(PsiElement element) {
        JSReferenceListMember member;
        if (element instanceof JSVariable && ((JSVarStatement)element.getParent()).getVariables().length == 1) {
            element = element.getParent();
        } else if (element instanceof JSReferenceExpression && element.getParent() instanceof JSReferenceListMember && ((JSReferenceList)(member = (JSReferenceListMember)element.getParent()).getParent()).getExpressions().length == 1) {
            element = member.getParent();
        }
        return element;
    }

    public static JSFunction buildImplementationMethod(JSFunction method, JSClass targetClass) {
        MultiMap types = MultiMap.createSet();
        for (String type : BaseCreateMethodsFix.getFunctionTypes(method)) {
            String resovled = JSImportHandlingUtil.resolveTypeName(type, (PsiElement)method);
            if (type.indexOf(46) == -1 && resovled.equals(type)) continue;
            types.putValue((Object)JSResolveUtil.getShortTypeName(type, false), (Object)resovled);
        }
        ImplementMethodsFix fix = new ImplementMethodsFix(targetClass);
        String text = fix.buildFunctionText(method, (MultiMap<String, String>)types);
        PsiElement element = JSChangeUtil.createJSTreeFromText(method.getProject(), text, JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
        return (JSFunction)element;
    }

    public static void addRemovalFormatters(JSClass sourceClass, Collection<? extends PsiElement> movedMembers, Condition<JSFunction> withMethodsAsdoc, Condition<JSVariable> withFieldsAsdoc, List<FormatFixer> result) {
        ArrayList<PsiElement> removed = new ArrayList<PsiElement>();
        for (PsiElement psiElement : movedMembers) {
            PsiElement comment;
            if ((psiElement instanceof JSFunction && !withMethodsAsdoc.value((Object)((JSFunction)psiElement)) || psiElement instanceof JSVariable && !withFieldsAsdoc.value((Object)((JSVariable)psiElement))) && (comment = JSRefactoringUtil.findDocComment(psiElement)) != null) {
                removed.add(comment);
            }
            removed.add(JSRefactoringUtil.getElementToFormat(psiElement));
        }
        if (sourceClass instanceof XmlBackedJSClassImpl) {
            ((XmlBackedJSClassImpl)sourceClass).processInjectedFiles((Processor<JSFile>)((Processor)jsFile -> {
                JSRefactoringUtil.processParent((PsiElement)jsFile, movedMembers, result, removed);
                return true;
            }));
        } else {
            JSRefactoringUtil.processParent((PsiElement)sourceClass, movedMembers, result, removed);
        }
    }

    private static void processParent(PsiElement parent, Collection<? extends PsiElement> movedMembers, List<FormatFixer> result, Collection<PsiElement> removed) {
        PsiElement from = null;
        PsiElement to = null;
        for (PsiElement e = parent.getFirstChild(); e != null; e = e.getNextSibling()) {
            boolean elementWillBeRemoved;
            if (e instanceof JSVarStatement) {
                elementWillBeRemoved = true;
                for (JSVariable var : ((JSVarStatement)e).getVariables()) {
                    if (movedMembers.contains(var)) continue;
                    elementWillBeRemoved = false;
                    break;
                }
            } else {
                elementWillBeRemoved = removed.contains(e);
            }
            if (elementWillBeRemoved) {
                if (from == null) {
                    from = e;
                }
                to = e;
                continue;
            }
            if (e instanceof PsiWhiteSpace || from == null) continue;
            result.add(FormatFixer.create(from, to, FormatFixer.Mode.FirstLinebreak));
            to = null;
            from = null;
        }
        if (from != null) {
            result.add(FormatFixer.create(from, to, FormatFixer.Mode.FirstLinebreak));
        }
    }

    public static void deleteWithNoPostponedFormatting(PsiElement toDelete) {
        PostprocessReformattingAspect.getInstance((Project)toDelete.getProject()).disablePostprocessFormattingInside(() -> toDelete.delete());
    }

    public static PsiElement findDocComment(PsiElement element) {
        PsiComment comment = JSDocumentationUtils.findDocComment(JSDocumentationProvider.findElementForWhichPreviousCommentWillBeSearched(element));
        return comment instanceof JSDocComment ? comment : null;
    }

    @Nullable
    private static String checkCanCreateFile(PsiDirectory directory, String className) {
        for (VirtualFile file : directory.getVirtualFile().getChildren()) {
            if (!className.equals(file.getNameWithoutExtension()) || !FileTypeManager.getInstance().isFileOfType(file, (FileType)JavaScriptSupportLoader.JAVASCRIPT) && !JavaScriptSupportLoader.isMxmlOrFxgFile(file)) continue;
            return JSBundle.message((String)"directory.already.contains.file", (Object[])new Object[]{directory.getVirtualFile().getPresentableUrl(), file.getName()});
        }
        return null;
    }

    @Nullable
    private static Pair<PsiElement, Boolean> getMemberInsertionAnchor(JSClass clazz, boolean forField) {
        PsiElement result;
        if (clazz instanceof XmlBackedJSClassImpl) {
            result = ((XmlBackedJSClassImpl)clazz).createOrGetFirstScriptTag().getFirstChild();
        } else {
            ASTNode lBrace = clazz.getNode().findChildByType(JSTokenTypes.LBRACE);
            PsiElement psiElement = result = lBrace != null ? lBrace.getPsi() : null;
        }
        if (result == null) {
            return null;
        }
        PsiElement e = result;
        while (e != null) {
            if (e instanceof JSFunction) {
                if (forField) {
                    return Pair.create((Object)e, (Object)true);
                }
                result = e;
            } else if (e instanceof JSVarStatement) {
                result = e;
            }
            e = JSRefactoringUtil.skipWhitespaces(e, true);
        }
        PsiElement next = JSRefactoringUtil.skipWhitespaces(result, true);
        if (next == null || next.getNode().getElementType() == JSTokenTypes.RBRACE) {
            return null;
        }
        return Pair.create((Object)result, (Object)false);
    }

    @Nullable
    public static PsiElement skipWhitespaces(PsiElement element, boolean forward) {
        PsiElement psiElement = element = forward ? element.getNextSibling() : element.getPrevSibling();
        while (element instanceof PsiWhiteSpace) {
            element = forward ? element.getNextSibling() : element.getPrevSibling();
        }
        return element;
    }

    public static PsiElement addMemberToTargetClass(JSClass clazz, PsiElement element) {
        Pair<PsiElement, Boolean> anchor = JSRefactoringUtil.getMemberInsertionAnchor(clazz, element instanceof JSVarStatement);
        if (anchor == null) {
            return clazz.add(element);
        }
        if (((Boolean)anchor.second).booleanValue()) {
            return clazz.addBefore(element, (PsiElement)anchor.first);
        }
        return clazz.addAfter(element, (PsiElement)anchor.first);
    }

    public static void handleDocCommentAndFormat(PsiElement newImmediateMember, List<FormatFixer> postponedFormatters) {
        PsiElement reformatTo = newImmediateMember.getNextSibling() instanceof PsiWhiteSpace ? newImmediateMember.getNextSibling() : newImmediateMember;
        postponedFormatters.add(FormatFixer.create(newImmediateMember, reformatTo, FormatFixer.Mode.Reformat));
    }

    public static boolean isEllipsisType(String typeText) {
        return "...".equals(typeText);
    }

    public static PsiElement createTypeElement(Project project, String type, JSLanguageDialect dialect) {
        PsiElement element = JSChangeUtil.createStatementFromText(project, "var x:" + type, dialect).getPsi();
        return ((JSVarStatement)element).getVariables()[0].getTypeElement();
    }

    public static void setType(JSNamedElement functionOrVariable, @Nullable String type, boolean optimizeImports) {
        PsiElement existingTypeElement;
        LOG.assertTrue(type == null || !JSRefactoringUtil.isEllipsisType(type));
        PsiFile file = functionOrVariable.getContainingFile();
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(file);
        if (dialect == null || !dialect.isECMA4 && !dialect.isTypeScript) {
            return;
        }
        PsiElement psiElement = existingTypeElement = functionOrVariable instanceof JSFunction ? ((JSFunction)functionOrVariable).getReturnTypeElement() : ((JSVariable)functionOrVariable).getTypeElement();
        if (StringUtil.isEmpty((String)type)) {
            if (existingTypeElement != null) {
                PsiElement deleteFrom = existingTypeElement.getPrevSibling();
                while (deleteFrom instanceof PsiWhiteSpace) {
                    deleteFrom = deleteFrom.getPrevSibling();
                }
                functionOrVariable.deleteChildRange(deleteFrom, existingTypeElement);
            }
        } else {
            PsiElement newTypeElement = JSRefactoringUtil.createTypeElement(functionOrVariable.getProject(), type, (JSLanguageDialect)file.getLanguage());
            if (existingTypeElement != null) {
                existingTypeElement.replace(newTypeElement);
            } else {
                PsiElement anchor = functionOrVariable instanceof JSFunction ? ((JSFunction)functionOrVariable).getParameterList() : functionOrVariable.getNameIdentifier();
                functionOrVariable.addRangeAfter(newTypeElement.getPrevSibling(), newTypeElement, anchor);
            }
            if (type.contains(".") && JSPsiImplUtils.differentPackageName(StringUtil.getPackageName((String)type), JSResolveUtil.getPackageNameFromPlace((PsiElement)functionOrVariable))) {
                ImportUtils.doImport((PsiElement)functionOrVariable, type, true);
                if (optimizeImports) {
                    new ECMAScriptImportOptimizer().processFile(functionOrVariable.getContainingFile()).run();
                }
            }
        }
    }

    public static boolean isResolvableType(String typeText, PsiElement context, boolean allowEmpty, boolean allowEllipsis) {
        if (StringUtil.isEmpty((String)typeText)) {
            return allowEmpty;
        }
        if ("void".equals(typeText) || "*".equals(typeText) || allowEllipsis && "...".equals(typeText)) {
            return true;
        }
        JSResolveUtil.GenericSignature signature = JSResolveUtil.extractGenericSignature(typeText);
        if (signature != null) {
            if (!"Vector".equals(signature.elementType)) {
                return false;
            }
            typeText = signature.genericType;
        }
        return JSResolveUtil.findType(typeText, context, true) != null;
    }

    public static boolean isValidIdentifier(String name, Project project) {
        return !"as".equals(name) && ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavascriptLanguage.INSTANCE)).isIdentifier(name, project);
    }

    @Nullable
    public static PsiDirectory chooseOrCreateDirectoryForClass(@NotNull Project project, @Nullable Module module, GlobalSearchScope scope, @NotNull String packageName, @Nullable String className, @Nullable PsiDirectory baseDir, ThreeState chooseFlag) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil", "chooseOrCreateDirectoryForClass"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil", "chooseOrCreateDirectoryForClass"));
        }
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        if (className != null) {
            String qName = StringUtil.getQualifiedName((String)packageName, (String)className);
            PsiElement clazz = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver().findClassByQName(qName, scope);
            if (clazz != null) {
                String message = JSBundle.message((String)"item.already.exists", (Object[])new Object[]{StringUtil.capitalize((String)JSBundle.message((String)JSNamedElementKind.kind((PsiElement)((JSNamedElement)clazz)).humanReadableKey(), (Object[])new Object[0])), qName});
                Messages.showErrorDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle());
                return null;
            }
        }
        Ref error = new Ref();
        Ref result = new Ref();
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil", "lambda$chooseOrCreateDirectoryForClass$3"));
            }
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil", "lambda$chooseOrCreateDirectoryForClass$3"));
            }
            try {
                result.set((Object)PlatformPackageUtil.findOrCreateDirectoryForPackage((Project)project, (Module)module, (GlobalSearchScope)scope, (String)packageName, (PsiDirectory)baseDir, (boolean)true, (ThreeState)chooseFlag));
                if (result.isNull()) {
                    error.set((Object)"");
                    return;
                }
                if (className != null) {
                    error.set((Object)JSRefactoringUtil.checkCanCreateFile((PsiDirectory)result.get(), className));
                }
            }
            catch (IncorrectOperationException e) {
                error.set((Object)e.getMessage());
            }
        }, CodeInsightBundle.message((String)"create.directory.command", (Object[])new Object[0]), null);
        if (!error.isNull() && ((String)error.get()).length() > 0) {
            Messages.showErrorDialog((Project)project, (String)((String)error.get()), (String)CommonBundle.getErrorTitle());
            return null;
        }
        return (PsiDirectory)result.get();
    }

    public static boolean checkReadOnlyStatus(@NotNull PsiElement element, @Nullable Editor editor, String title) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil", "checkReadOnlyStatus"));
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)element.getProject(), (PsiElement)element)) {
            return false;
        }
        if (JSProjectUtil.isInLibrary(element)) {
            CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)JSBundle.message((String)"cannot.modify.library.code", (Object[])new Object[0])), (String)StringUtil.capitalizeWords((String)title, (boolean)true), null);
            return false;
        }
        return true;
    }

    public static void addConstructorUsages(JSClass clazz, Collection<UsageInfo> result) {
        JSFunction constructor = clazz.getConstructor();
        if (constructor != null) {
            ReferencesSearch.search((PsiElement)constructor, (SearchScope)constructor.getUseScope()).forEach(psiReference -> {
                PsiElement element = psiReference.getElement();
                if (!(element instanceof JSReferenceExpression)) {
                    return true;
                }
                result.add(new ConstructorUsageInfo((JSReferenceExpression)element, clazz));
                return true;
            });
        }
    }

    public static SearchScope getElementSearchScope(PsiElement element) {
        return new LocalSearchScope((PsiElement)element.getContainingFile());
    }

    public static String transformVarNameToAccessorName(String s, Project project) {
        return JSRefactoringUtil.transformVarNameToAccessorName(s, (JSCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(JSCodeStyleSettings.class));
    }

    @NotNull
    public static String transformVarNameToAccessorName(String s, JSCodeStyleSettings codeStyleSettings) {
        if (StringUtil.startsWith((CharSequence)s, (CharSequence)codeStyleSettings.FIELD_PREFIX)) {
            s = s.substring(codeStyleSettings.FIELD_PREFIX.length());
        }
        String string = s = codeStyleSettings.PROPERTY_PREFIX + s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil", "transformVarNameToAccessorName"));
        }
        return string;
    }

    @Contract(value="null,_ -> null")
    @Nullable
    public static String transformAccessorNameToPropertyName(@Nullable String varName, Project project) {
        if (varName == null) {
            return null;
        }
        JSCodeStyleSettings settings = (JSCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings().getCustomSettings(JSCodeStyleSettings.class);
        varName = StringUtil.trimStart((String)varName, (String)settings.PROPERTY_PREFIX);
        varName = settings.FIELD_PREFIX + varName;
        return varName;
    }

    public static List<PsiElement> mergeDeclarationAndAssignment(JSVarStatement varStatement) {
        ArrayList<PsiElement> modified = new ArrayList<PsiElement>();
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)varStatement);
        boolean hasType = holder != null && (holder.isECMA4 || holder.isTypeScript);
        SmartList toRemove = new SmartList();
        JSVariable[] variables = varStatement.getVariables();
        List<JSVariable> mergeable = Arrays.stream(variables).filter(v -> !v.hasInitializer()).collect(Collectors.toList());
        if (mergeable.isEmpty()) {
            return Collections.emptyList();
        }
        NewLineEraser varStatementEraser = new NewLineEraser((PsiElement)varStatement);
        SmartList erasers = new SmartList();
        boolean allVariablesConverted = mergeable.size() == variables.length;
        CommentsMover commentsMover = new CommentsMover((JSSourceElement)varStatement);
        mergeable.forEach(arg_0 -> JSRefactoringUtil.lambda$mergeDeclarationAndAssignment$6(hasType, varStatement, (List)erasers, allVariablesConverted, modified, commentsMover, (List)toRemove, arg_0));
        toRemove.forEach(v -> v.delete());
        if (allVariablesConverted || !commentsMover.hasAfterComments()) {
            varStatementEraser.process();
        }
        erasers.forEach(eraser -> eraser.process());
        if (varStatement.isValid()) {
            modified.add((PsiElement)varStatement);
        }
        modified.forEach(s -> JSElementFactory.reformat(s));
        return modified;
    }

    public static boolean isModuleExportsOrExports(@Nullable JSExpression expression) {
        return expression instanceof JSReferenceExpression && (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)expression, "module", "exports") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)expression, "exports"));
    }

    public static boolean isModuleExports(@Nullable JSExpression expression) {
        return expression instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)expression, "module", "exports");
    }

    public static void reformatElementWithoutBody(@NotNull PsiElement statement, @NotNull PsiElement expression) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil", "reformatElementWithoutBody"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil", "reformatElementWithoutBody"));
        }
        JSRefactoringUtil.createFixerForReformatWithoutBody(statement, expression).fixFormat();
    }

    public static FormatFixer createFixerForReformatWithoutBody(@NotNull PsiElement statement, @NotNull PsiElement expression) {
        PsiComment firstChild;
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil", "createFixerForReformatWithoutBody"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil", "createFixerForReformatWithoutBody"));
        }
        ASTNode leftBrace = JSRefactoringUtil.getLeftBrace(expression);
        PsiComment jsDoc = JSDocumentationUtils.findDocComment(statement);
        Object object = firstChild = jsDoc instanceof JSDocComment ? jsDoc : statement.getFirstChild();
        if (firstChild != null && leftBrace != null) {
            return FormatFixer.create((PsiElement)firstChild, leftBrace.getPsi(), FormatFixer.Mode.ReformatExactRange);
        }
        return FormatFixer.create(statement, FormatFixer.Mode.Reformat);
    }

    @Nullable
    public static ASTNode getLeftBrace(PsiElement element) {
        JSBlockStatement blockStatement;
        ASTNode leftBrace = element.getNode().findChildByType(JSTokenTypes.LBRACE);
        if (leftBrace == null && (blockStatement = (JSBlockStatement)PsiTreeUtil.findChildOfType((PsiElement)element, JSBlockStatement.class)) != null) {
            leftBrace = blockStatement.getNode().findChildByType(JSTokenTypes.LBRACE);
        }
        return leftBrace;
    }

    public static void deleteSiblingWhitespace(PsiElement element, boolean deleteBefore, boolean deleteAfter) {
        PsiElement sibling = element;
        if (deleteBefore) {
            while ((sibling = sibling.getPrevSibling()) instanceof PsiWhiteSpace) {
                sibling.delete();
            }
        }
        if (deleteAfter) {
            sibling = element;
            while ((sibling = sibling.getNextSibling()) instanceof PsiWhiteSpace) {
                sibling.delete();
            }
        }
    }

    private static /* synthetic */ void lambda$mergeDeclarationAndAssignment$6(boolean hasType, JSVarStatement varStatement, List erasers, boolean allVariablesConverted, List modified, CommentsMover commentsMover, List toRemove, JSVariable variable) {
        JSExpressionStatement assignmentStatement;
        Iterator<PsiElement> referenceIterator;
        JSReferenceExpression firstReference;
        String typePrefix = null;
        if (hasType && variable.getType() != null) {
            typePrefix = ":" + variable.getType().getTypeText(JSType.TypeTextFormat.CODE);
        }
        if (!variable.hasInitializer() && (firstReference = (JSReferenceExpression)((referenceIterator = FindReferenceUtil.getReferencesAfter(variable, variable.getTextRange().getEndOffset()).iterator()).hasNext() ? referenceIterator.next() : null)) != null && firstReference.getParent() instanceof JSDefinitionExpression && (assignmentStatement = (JSExpressionStatement)firstReference.getParent().getParent().getParent()) != null && assignmentStatement.getParent().equals(varStatement.getParent())) {
            String assignmentText = ((JSAssignmentExpression)firstReference.getParent().getParent()).getROperand().getText();
            String newText = String.format("%s %s%s=%s%s", varStatement.getVarKeyword().getText(), firstReference.getReferenceName(), StringUtil.notNullize((String)typePrefix), assignmentText, JSCodeStyleSettings.getSemicolon(varStatement.getContainingFile()));
            NewLineEraser eraser = new NewLineEraser((PsiElement)assignmentStatement);
            erasers.add(eraser);
            JSStatement statement = JSElementFactory.replaceStatement((JSStatement)assignmentStatement, newText, true);
            if (statement == null) {
                return;
            }
            if (allVariablesConverted && modified.isEmpty()) {
                Set<JSStatement> elements = Collections.singleton(statement);
                commentsMover.move(elements, elements);
            }
            eraser.registerEquivalent((PsiElement)statement);
            modified.add(statement);
            toRemove.add(variable);
        }
    }

    public static class MergeDeclarationAndInitializationPredicate
    implements JSElementPredicate {
        @Nullable
        private MultiMap<String, PsiReference> myReferenceMap;

        public MergeDeclarationAndInitializationPredicate setReferenceMap(@Nullable MultiMap<String, PsiReference> referenceMap) {
            this.myReferenceMap = referenceMap;
            return this;
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil$MergeDeclarationAndInitializationPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSVarStatement)) {
                return false;
            }
            JSVarStatement varStatement = (JSVarStatement)element;
            if (ErrorUtil.containsError((PsiElement)varStatement)) {
                return false;
            }
            for (JSVariable variable : varStatement.getVariables()) {
                PsiElement parent;
                JSReferenceExpression firstReference;
                if (variable.hasInitializer() || (firstReference = this.getFirstReference(variable)) == null || !((parent = firstReference.getParent()) instanceof JSDefinitionExpression) || !(parent.getParent() instanceof JSAssignmentExpression) || !(parent.getParent().getParent() instanceof JSExpressionStatement)) continue;
                PsiElement expression = parent.getParent().getParent();
                return expression.getParent() != null && expression.getParent().equals(varStatement.getParent());
            }
            return false;
        }

        @Nullable
        private JSReferenceExpression getFirstReference(JSVariable variable) {
            if (this.myReferenceMap != null) {
                Collection references = this.myReferenceMap.get((Object)variable.getName());
                if (!references.isEmpty()) {
                    ArrayList list = new ArrayList(references);
                    Optional<PsiReference> min = list.stream().filter(reference -> {
                        PsiElement refElement = reference.getElement();
                        return refElement instanceof JSReferenceExpression && refElement.isValid() && refElement.getTextRange().getStartOffset() > variable.getTextRange().getEndOffset();
                    }).min(Comparator.comparingInt(o -> o.getElement().getTextRange().getStartOffset()));
                    return min.isPresent() ? (JSReferenceExpression)min.get() : null;
                }
                return null;
            }
            Iterator<PsiElement> referenceIterator = FindReferenceUtil.getReferencesAfter(variable, variable.getTextRange().getEndOffset()).iterator();
            return (JSReferenceExpression)(referenceIterator.hasNext() ? referenceIterator.next() : null);
        }
    }

    public static class ConstructorUsageInfo
    extends UsageInfo {
        private final JSClass mySubject;

        public ConstructorUsageInfo(JSReferenceExpression ref, JSClass subject) {
            super((PsiElement)ref);
            this.mySubject = subject;
        }

        public JSClass getSubject() {
            return this.mySubject;
        }

        public JSReferenceExpression getElement() {
            return (JSReferenceExpression)super.getElement();
        }
    }
}

