/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.integration.JSAnnotationRangeError;
import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ResultWithError;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceUtil {
    public static final long TIMEOUT_MILLS;
    public static final long QUOTA_MILLS = 10L;
    public static long TEST_TIMEOUT_MILLIS;

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future) {
        return JSLanguageServiceUtil.awaitFuture(future, TIMEOUT_MILLS, 10L, null);
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMills, long quotaMills, @Nullable ProgressIndicator indicator) {
        return JSLanguageServiceUtil.awaitFuture(future, timeoutMills, quotaMills, indicator, true, null);
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMills, long quotaMills, @Nullable ProgressIndicator indicator, boolean cancelFutureIfTimeout, @Nullable Computable<Boolean> cancelCheck) {
        if (future == null) {
            return null;
        }
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            JSLanguageServiceQueue.LOGGER.error("Await future on EDT may cause a deadlock");
        }
        try {
            if (future.isDone()) {
                return future.get();
            }
            for (long totalWait = timeoutMills; !(totalWait <= 0L || cancelCheck != null && Boolean.TRUE.equals(cancelCheck.compute())); totalWait -= quotaMills) {
                try {
                    return future.get(quotaMills, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                }
                catch (InterruptedException | CancellationException e) {
                    return null;
                }
                if (indicator == null) {
                    ProgressManager.checkCanceled();
                    continue;
                }
                indicator.checkCanceled();
            }
            if (future.isDone()) {
                return future.get();
            }
            if (cancelFutureIfTimeout) {
                future.cancel(false);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public static <Result> ResultWithError<Result> awaitLanguageService(@Nullable Future<Result> future, @NotNull LinterLanguageServiceClient languageService) {
        if (languageService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageService", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "awaitLanguageService"));
        }
        if (future == null) {
            if (JSLanguageServiceUtil.languageServiceHasError(languageService)) {
                ResultWithError resultWithError = ResultWithError.error(JSLanguageServiceUtil.getLanguageServiceCreationError(languageService));
                if (resultWithError == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "awaitLanguageService"));
                }
                return resultWithError;
            }
            ResultWithError resultWithError = ResultWithError.empty();
            if (resultWithError == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "awaitLanguageService"));
            }
            return resultWithError;
        }
        long timeout = ApplicationManager.getApplication().isUnitTestMode() ? TEST_TIMEOUT_MILLIS : TIMEOUT_MILLS;
        Result result = JSLanguageServiceUtil.awaitFuture(future, timeout, 10L, null, true, (Computable<Boolean>)((Computable)() -> {
            if (languageService == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageService", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "lambda$awaitLanguageService$0"));
            }
            return languageService.getServiceCreationError() != null;
        }));
        if (future.isCancelled()) {
            if (JSLanguageServiceUtil.languageServiceHasError(languageService)) {
                ResultWithError resultWithError = ResultWithError.error(JSLanguageServiceUtil.getLanguageServiceCreationError(languageService));
                if (resultWithError == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "awaitLanguageService"));
                }
                return resultWithError;
            }
            ResultWithError resultWithError = ResultWithError.error("Language service execution timeout");
            if (resultWithError == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "awaitLanguageService"));
            }
            return resultWithError;
        }
        if (result == null) {
            if (JSLanguageServiceUtil.languageServiceHasError(languageService)) {
                ResultWithError resultWithError = ResultWithError.error(JSLanguageServiceUtil.getLanguageServiceCreationError(languageService));
                if (resultWithError == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "awaitLanguageService"));
                }
                return resultWithError;
            }
            ResultWithError resultWithError = ResultWithError.empty();
            if (resultWithError == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "awaitLanguageService"));
            }
            return resultWithError;
        }
        ResultWithError<Result> resultWithError = ResultWithError.result(result);
        if (resultWithError == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "awaitLanguageService"));
        }
        return resultWithError;
    }

    private static boolean languageServiceHasError(@NotNull LinterLanguageServiceClient languageService) {
        if (languageService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageService", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "languageServiceHasError"));
        }
        return !languageService.isServiceCreated() || languageService.getServiceCreationError() != null;
    }

    @NotNull
    public static String getLanguageServiceCreationError(@NotNull LinterLanguageServiceClient languageService) {
        if (languageService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageService", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "getLanguageServiceCreationError"));
        }
        String string = (String)ObjectUtils.coalesce((Object)languageService.getServiceCreationError(), (Object)"Cannot start language service process");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "getLanguageServiceCreationError"));
        }
        return string;
    }

    @Nullable
    public static PsiElementInfo getElementInfo(@Nullable PsiFile file, @NotNull Document document, @NotNull JSAnnotationError result) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "getElementInfo"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "getElementInfo"));
        }
        int endLine = result instanceof JSAnnotationRangeError ? ((JSAnnotationRangeError)result).getEndLine() : -1;
        int endColumn = result instanceof JSAnnotationRangeError ? ((JSAnnotationRangeError)result).getEndColumn() : -1;
        return JSLanguageServiceUtil.getElementInfo(file, document, result.getLine(), result.getColumn(), endLine, endColumn);
    }

    @Nullable
    public static PsiElementInfo getElementInfo(@Nullable PsiFile file, @NotNull Document document, int line, int column, int endLine, int endColumn) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "getElementInfo"));
        }
        try {
            int lineStartOffset;
            if (line < 0 || line >= document.getLineCount()) {
                return null;
            }
            int errorStartOffset = lineStartOffset = document.getLineStartOffset(line);
            int lineEndOffset = document.getLineEndOffset(line);
            if ((errorStartOffset += column) > lineEndOffset) {
                return null;
            }
            PsiElement element = null;
            TextRange range = null;
            if (endLine < 0 && file != null) {
                element = file.findElementAt(errorStartOffset);
                if (element == null && lineStartOffset < errorStartOffset) {
                    element = file.findElementAt(errorStartOffset - 1);
                }
            } else {
                if (endLine < 0 || endLine >= document.getLineCount()) {
                    return null;
                }
                int errorEndOffset = document.getLineStartOffset(endLine);
                int lineToEndOffset = document.getLineEndOffset(endLine);
                if ((errorEndOffset += endColumn) > lineToEndOffset) {
                    return null;
                }
                range = TextRange.create((int)errorStartOffset, (int)errorEndOffset);
            }
            return new PsiElementInfo(element, range);
        }
        catch (Exception e) {
            JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static String getInterpreterPathIfValid(@Nullable NodeJsInterpreter interpreter) {
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter != null && localInterpreter.isValid()) {
            return localInterpreter.getInterpreterSystemDependentPath();
        }
        return null;
    }

    @Nullable
    public static String normalizePathDoNotFollowSymlinks(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "normalizePathDoNotFollowSymlinks"));
        }
        if (!virtualFile.isInLocalFileSystem()) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)virtualFile.getPath());
    }

    @Nullable
    public static String normalizeNameAndPath(@NotNull VirtualFile name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "normalizeNameAndPath"));
        }
        String path = name.getCanonicalPath();
        if (!name.isInLocalFileSystem() || null == path) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    @Contract(value="!null -> !null")
    public static String normalizeNameAndPath(@Nullable String path) {
        if (null == path) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    @NotNull
    public static File getPluginStarterDirectory() {
        File file = JSLanguageServiceUtil.getPluginDirectory(TypeScriptUtil.class, "jsLanguageServicesImpl");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "getPluginStarterDirectory"));
        }
        return file;
    }

    public static File getPluginDirectory(@NotNull Class<?> pluginClass, @NotNull String resourceName) {
        if (pluginClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginClass", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "getPluginDirectory"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "com/intellij/lang/javascript/service/JSLanguageServiceUtil", "getPluginDirectory"));
        }
        try {
            String jarPath = PathUtil.getJarPathForClass(pluginClass);
            if (!jarPath.endsWith(".jar")) {
                URL resource = pluginClass.getClassLoader().getResource(resourceName);
                if (resource == null) {
                    throw new RuntimeException("Cannot find file compiler implementation");
                }
                return new File(URLDecoder.decode(resource.getPath(), "UTF-8"));
            }
            File jarFile = new File(jarPath);
            if (!jarFile.isFile()) {
                throw new RuntimeException("jar file cannot be null");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            return new File(pluginBaseDir, resourceName);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        TEST_TIMEOUT_MILLIS = TIMEOUT_MILLS = TimeUnit.SECONDS.toMillis(20L);
    }

    public static class PsiElementInfo {
        @Nullable
        private final PsiElement myElement;
        @Nullable
        private final TextRange myRange;

        public PsiElementInfo(@Nullable PsiElement element, @Nullable TextRange range) {
            this.myElement = element;
            this.myRange = range;
        }

        @Nullable
        public PsiElement getElement() {
            return this.myElement;
        }

        @Nullable
        public TextRange getRange() {
            return this.myRange;
        }
    }
}

