/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ui.JSConsoleViewPanel;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceConsole;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.StatusText;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceToolWindowManager
implements Disposable {
    public static final String WARNING = "warning";
    public static final String EMPTY_TEXT = " ";
    @NotNull
    protected final Project myProject;
    @Nullable
    private volatile NewErrorTreeViewPanel myCurrentErrorTreeViewPanel;
    private volatile NewErrorTreeViewPanel myProjectErrorTreeViewPanel;
    private volatile boolean myInitialized;
    private volatile boolean myDisposed;
    @Nullable
    private volatile ToolWindow myToolWindow;
    @NotNull
    private final String myHelpId;
    @Nullable
    private final LayeredIcon myIcon;
    @Nullable
    private final Icon myErrorIcon;
    @Nullable
    private final AnAction[] myCommonActions;
    @NotNull
    private final String myToolWindowName;
    @Nullable
    private volatile List<JSAnnotationError> myLastResult;
    protected final Map<String, JSLanguageServiceConsole> myServiceConsoles;

    public JSLanguageServiceToolWindowManager(@NotNull Project project, @NotNull String toolWindowName, @NotNull String helpId, @Nullable Icon icon, AnAction ... commonPanelActions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "<init>"));
        }
        if (toolWindowName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowName", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "<init>"));
        }
        if (helpId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpId", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "<init>"));
        }
        this.myDisposed = false;
        this.myServiceConsoles = ContainerUtil.newConcurrentMap();
        this.myProject = project;
        this.myToolWindowName = toolWindowName;
        this.myHelpId = helpId;
        this.myCommonActions = commonPanelActions;
        this.myIcon = JSLanguageServiceToolWindowManager.createIcon(icon, false);
        this.myErrorIcon = JSLanguageServiceToolWindowManager.createIcon(icon, true);
    }

    private static LayeredIcon createIcon(@Nullable Icon rawIcon, boolean error) {
        if (rawIcon == null) {
            return null;
        }
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(rawIcon, 0);
        Icon errorMark = AllIcons.Nodes.ErrorMark;
        icon.setIcon(error ? errorMark : EmptyIcon.create((Icon)errorMark), 1, 5);
        return icon;
    }

    public boolean needActivateProgressPanel() {
        return false;
    }

    public void setProgressText(@Nullable String text) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel myErrorPanel = this.myCurrentErrorTreeViewPanel;
        if (myErrorPanel != null) {
            if (StringUtil.isEmpty((String)text)) {
                myErrorPanel.clearProgressData();
            } else {
                myErrorPanel.setProgressText(text);
            }
        }
    }

    public synchronized void connectToProcessHandler(@NotNull String serviceId, @NotNull ProcessHandler handler) {
        if (serviceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceId", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "connectToProcessHandler"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "connectToProcessHandler"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed() || !this.myProject.isOpen() || this.myDisposed) {
            return;
        }
        this.init();
        this.cleanErrorsPanel();
        JSLanguageServiceQueue.LOGGER.debug("Creating language service " + this.myToolWindowName);
        assert (this.myToolWindow != null);
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null) {
            ConsoleViewImpl console = this.createConsole();
            console.attachToProcess(handler);
            JSConsoleViewPanel consolePanel = new JSConsoleViewPanel(this.myProject, this.myHelpId, null, (ConsoleView)console, this.myCommonActions);
            JSLanguageServiceConsole oldConsole = this.myServiceConsoles.get(serviceId);
            if (oldConsole != null) {
                JSLanguageServiceQueue.LOGGER.debug("Old console wasn't disposed. Tool window: " + this.myToolWindowName + " id: " + serviceId);
                try {
                    this.disconnectFromProcessHandler(serviceId);
                }
                catch (Exception e) {
                    JSLanguageServiceQueue.LOGGER.debug("Error while dispose: " + serviceId);
                }
            }
            this.myServiceConsoles.put(serviceId, new JSLanguageServiceConsole(serviceId, toolWindow, console, consolePanel));
            this.updateCurrentErrorsEmptyText(this.createOrGetCurrentTreeViewPanel());
        }
    }

    @NotNull
    protected ConsoleViewImpl createConsole() {
        ConsoleViewImpl consoleViewImpl = new ConsoleViewImpl(this.myProject, GlobalSearchScope.allScope((Project)this.myProject), true, false);
        if (consoleViewImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "createConsole"));
        }
        return consoleViewImpl;
    }

    public synchronized void printToConsole(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "printToConsole"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        JSLanguageServiceConsole console = (JSLanguageServiceConsole)ContainerUtil.getFirstItem(this.myServiceConsoles.values());
        if (console != null) {
            console.print(message);
        }
    }

    public synchronized boolean isConnectedToProcessHandler(@NotNull String consoleId) {
        if (consoleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleId", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "isConnectedToProcessHandler"));
        }
        return this.myServiceConsoles.containsKey(consoleId);
    }

    public void show() {
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null) {
            toolWindow.show(null);
        }
    }

    public void lazyInit(@NotNull Condition<JSLanguageServiceToolWindowManager> checkInit) {
        if (checkInit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkInit", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "lazyInit"));
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            if (checkInit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkInit", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "lambda$lazyInit$1"));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (checkInit == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkInit", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "lambda$null$0"));
                }
                if (checkInit.value((Object)this)) {
                    this.init();
                }
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            }, this.myProject.getDisposed());
        });
    }

    public synchronized void init() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myInitialized || this.myToolWindow == null) {
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
            ToolWindow toolWindow = manager.registerToolWindow(this.myToolWindowName, true, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject, true);
            toolWindow.setIcon((Icon)this.myIcon);
            this.myToolWindow = toolWindow;
            this.myInitialized = true;
            JSLanguageServiceQueue.LOGGER.debug("Initialized tool window " + this.myToolWindowName);
            this.createOrGetCurrentTreeViewPanel();
        }
    }

    private ContentImpl createCurrentErrorContent(ToolWindow toolWindow) {
        Ref content = new Ref();
        JSLanguageServiceErrorTreeViewPanel errorTreeViewPanel = this.createCurrentErrorsPanel(toolWindow, (Ref<ContentImpl>)content);
        Disposer.register((Disposable)this.myProject, (Disposable)errorTreeViewPanel);
        ContentImpl contentImpl = new ContentImpl((JComponent)((Object)errorTreeViewPanel), this.getCurrentErrorsTitle(), false);
        contentImpl.setCloseable(false);
        content.set((Object)contentImpl);
        toolWindow.getContentManager().addContent((Content)content.get(), 0);
        this.myCurrentErrorTreeViewPanel = errorTreeViewPanel;
        return (ContentImpl)content.get();
    }

    @NotNull
    protected String getCurrentErrorsTitle() {
        if ("Errors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "getCurrentErrorsTitle"));
        }
        return "Errors";
    }

    @Nullable
    protected final NewErrorTreeViewPanel getCurrentErrorTreeViewPanel() {
        return this.myCurrentErrorTreeViewPanel;
    }

    @NotNull
    protected String getProjectErrorsTitle() {
        if ("Project Errors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "getProjectErrorsTitle"));
        }
        return "Project Errors";
    }

    @NotNull
    protected JSLanguageServiceErrorTreeViewPanel createCurrentErrorsPanel(final ToolWindow toolWindow, final Ref<ContentImpl> content) {
        JSLanguageServiceErrorTreeViewPanel panel = new JSLanguageServiceErrorTreeViewPanel(this.myProject, this.myHelpId, () -> {
            this.myLastResult = null;
        }, this.getErrorPanelLeftActions(false), this.getErrorPanelRightActions(false)){

            public void close() {
                JSLanguageServiceToolWindowManager.this.closeCurrentErrorsPanel(toolWindow, (Ref<ContentImpl>)content);
            }
        };
        if (this.needActivateProgressPanel()) {
            panel.setProgressText(EMPTY_TEXT);
        }
        this.updateCurrentErrorsEmptyText(panel);
        JSLanguageServiceErrorTreeViewPanel jSLanguageServiceErrorTreeViewPanel = panel;
        if (jSLanguageServiceErrorTreeViewPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "createCurrentErrorsPanel"));
        }
        return jSLanguageServiceErrorTreeViewPanel;
    }

    protected void closeCurrentErrorsPanel(ToolWindow toolWindow, Ref<ContentImpl> content) {
        toolWindow.hide(() -> {
            this.myLastResult = null;
            toolWindow.setIcon((Icon)this.myIcon);
            ContentImpl contentImpl = (ContentImpl)content.get();
            if (contentImpl != null) {
                toolWindow.getContentManager().removeContent((Content)contentImpl, true);
            }
            ContentImpl newContentImpl = this.createCurrentErrorContent(toolWindow);
            toolWindow.getContentManager().setSelectedContent((Content)newContentImpl);
        });
    }

    protected AnAction[] getErrorPanelRightActions(boolean all) {
        return AnAction.EMPTY_ARRAY;
    }

    protected AnAction[] getErrorPanelLeftActions(boolean all) {
        return this.myCommonActions;
    }

    public void setName(@Nullable String newName) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.init();
        ToolWindow window = this.myToolWindow;
        if (window != null && !StringUtil.isEmptyOrSpaces((String)newName)) {
            window.setStripeTitle(this.myToolWindowName + EMPTY_TEXT + newName);
        }
        this.updateCurrentErrorsEmptyText(this.createOrGetCurrentTreeViewPanel());
    }

    @Nullable
    private NewErrorTreeViewPanel createProjectErrorsPanel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel panel = this.myProjectErrorTreeViewPanel;
        if (panel != null) {
            return panel;
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            this.init();
            toolWindow = this.myToolWindow;
        }
        if (toolWindow == null) {
            return null;
        }
        Ref content = new Ref();
        JSLanguageServiceErrorTreeViewPanel errorTreeViewPanel = this.createProjectErrorsPanel(toolWindow, (Ref<ContentImpl>)content);
        Disposer.register((Disposable)this.myProject, (Disposable)errorTreeViewPanel);
        ContentImpl contentImpl = new ContentImpl((JComponent)((Object)errorTreeViewPanel), this.getProjectErrorsTitle(), false);
        contentImpl.setCloseable(false);
        content.set((Object)contentImpl);
        toolWindow.getContentManager().addContent((Content)content.get());
        this.myProjectErrorTreeViewPanel = errorTreeViewPanel;
        return errorTreeViewPanel;
    }

    @NotNull
    protected JSLanguageServiceErrorTreeViewPanel createProjectErrorsPanel(final ToolWindow toolWindow, final Ref<ContentImpl> content) {
        JSLanguageServiceErrorTreeViewPanel jSLanguageServiceErrorTreeViewPanel = new JSLanguageServiceErrorTreeViewPanel(this.myProject, this.myHelpId, null, this.getErrorPanelLeftActions(true), this.getErrorPanelRightActions(true)){

            public void close() {
                NewErrorTreeViewPanel oldPanel = JSLanguageServiceToolWindowManager.this.myProjectErrorTreeViewPanel;
                JSLanguageServiceToolWindowManager.this.myProjectErrorTreeViewPanel = null;
                toolWindow.hide(() -> {
                    ContentImpl contentImpl = (ContentImpl)content.get();
                    if (contentImpl != null) {
                        toolWindow.getContentManager().removeContent((Content)contentImpl, true);
                    }
                    if (oldPanel != null) {
                        Disposer.dispose((Disposable)oldPanel);
                    }
                });
            }
        };
        if (jSLanguageServiceErrorTreeViewPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "createProjectErrorsPanel"));
        }
        return jSLanguageServiceErrorTreeViewPanel;
    }

    public void disconnectFromProcessHandler(@NotNull String serviceId) {
        if (serviceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceId", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "disconnectFromProcessHandler"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        JSLanguageServiceConsole console = this.myServiceConsoles.remove(serviceId);
        if (console != null) {
            Disposer.dispose((Disposable)console);
            this.setProgressText(null);
        }
    }

    public void logProjectErrors(@NotNull ImmutableList<JSAnnotationError> results, boolean setActive) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "logProjectErrors"));
        }
        NewErrorTreeViewPanel panel = this.createProjectErrorsPanel();
        if (panel == null) {
            return;
        }
        JSLanguageServiceToolWindowManager.logErrorsImpl(panel, results);
        ToolWindow window = this.myToolWindow;
        if (window == null) {
            return;
        }
        if (setActive) {
            this.setActivePanel(panel, window);
        }
    }

    private void setActivePanel(NewErrorTreeViewPanel panel, ToolWindow window) {
        for (Content content : window.getContentManager().getContents()) {
            if (content.getComponent() != panel) continue;
            window.getContentManager().setSelectedContent(content);
            break;
        }
        this.show();
    }

    protected NewErrorTreeViewPanel createOrGetCurrentTreeViewPanel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel errorTreeViewPanel = this.myCurrentErrorTreeViewPanel;
        if (errorTreeViewPanel != null) {
            return errorTreeViewPanel;
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (this.myInitialized && toolWindow != null) {
            ContentImpl content = this.createCurrentErrorContent(toolWindow);
            toolWindow.getContentManager().setSelectedContent((Content)content);
        }
        return this.myCurrentErrorTreeViewPanel;
    }

    public void logCurrentErrors(@NotNull List<JSAnnotationError> results, boolean setActive) {
        ArrayList list;
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "logCurrentErrors"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel errorTreeViewPanel = this.createOrGetCurrentTreeViewPanel();
        if (errorTreeViewPanel == null) {
            return;
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (this.myInitialized && !(list = ContainerUtil.newArrayList(results)).equals(this.myLastResult)) {
            JSLanguageServiceToolWindowManager.logErrorsImpl(errorTreeViewPanel, list);
            this.myLastResult = list;
            if (toolWindow != null && this.myIcon != null) {
                Object newIcon;
                Icon oldIcon = toolWindow.getIcon();
                Object object = newIcon = list.isEmpty() ? this.myIcon : this.myErrorIcon;
                if (oldIcon != newIcon) {
                    toolWindow.setIcon((Icon)newIcon);
                }
            }
        }
        if (toolWindow != null && setActive) {
            this.setActivePanel(errorTreeViewPanel, toolWindow);
        }
    }

    private static void logErrorsImpl(NewErrorTreeViewPanel errorTreeViewPanel, List<JSAnnotationError> list) {
        errorTreeViewPanel.getErrorViewStructure().clear();
        for (JSAnnotationError compilerResult : list) {
            String path = compilerResult.getAbsoluteFilePath();
            VirtualFile file = null;
            if (path != null) {
                file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
            }
            int category = WARNING.equalsIgnoreCase(compilerResult.getCategory()) ? 5 : 4;
            errorTreeViewPanel.addMessage(category, new String[]{compilerResult.getDescription()}, file, compilerResult.getLine(), compilerResult.getColumn(), null);
        }
        errorTreeViewPanel.updateTree();
    }

    public synchronized void dispose() {
        this.disposeConsoles();
        this.resetToolWindow();
        this.myDisposed = true;
    }

    private synchronized void disposeConsoles() {
        for (JSLanguageServiceConsole console : this.myServiceConsoles.values()) {
            if (console == null) continue;
            try {
                Disposer.dispose((Disposable)console);
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        this.myServiceConsoles.clear();
    }

    public void cleanErrorsPanel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel panel = this.myCurrentErrorTreeViewPanel;
        if (panel != null) {
            panel.getErrorViewStructure().clear();
            panel.updateTree();
            this.myLastResult = null;
            this.updateCurrentErrorsEmptyText(panel);
        }
    }

    protected void updateCurrentErrorsEmptyText(@NotNull NewErrorTreeViewPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "updateCurrentErrorsEmptyText"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        StatusText text = panel.getEmptyText();
        if (this.myServiceConsoles.isEmpty()) {
            text.clear();
            text.setText(JSBundle.message((String)"javascript.language.service.tracking.is.not.started", (Object[])new Object[0]));
            return;
        }
        text.setText(JSLanguageServiceErrorTreeViewPanel.getDefaultNoErrorsText());
    }

    public synchronized void resetToolWindow() {
        NewErrorTreeViewPanel allErrorTreeViewPanel;
        NewErrorTreeViewPanel panel;
        if (this.myProject.isDefault()) {
            return;
        }
        if (!this.myServiceConsoles.isEmpty()) {
            return;
        }
        if (!this.myProject.isDisposed()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ToolWindowManager.getInstance((Project)this.myProject).unregisterToolWindow(this.myToolWindowName);
        }
        if ((panel = this.myCurrentErrorTreeViewPanel) != null) {
            Disposer.dispose((Disposable)panel);
        }
        if ((allErrorTreeViewPanel = this.myProjectErrorTreeViewPanel) != null) {
            Disposer.dispose((Disposable)allErrorTreeViewPanel);
        }
        this.myProjectErrorTreeViewPanel = null;
        this.myToolWindow = null;
        this.myCurrentErrorTreeViewPanel = null;
        this.myLastResult = null;
    }
}

