/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.surroundWith.JSNotWithParenthesesSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithCastSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithIfElseSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithIfSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithObjectLiteralSurrounder;
import com.intellij.lang.javascript.surroundWith.JSWithParenthesesSurrounder;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSExpressionSurroundDescriptor
implements SurroundDescriptor {
    private static final Surrounder[] SURROUNDERS = new Surrounder[]{new JSWithParenthesesSurrounder(), new JSNotWithParenthesesSurrounder(), new JSWithObjectLiteralSurrounder()};
    private List<Surrounder> myAdditionalSurrounders;

    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        JSExpression expr = JSExpressionSurroundDescriptor.findExpressionInRange(file, startOffset, endOffset);
        if (expr == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/surroundWith/JSExpressionSurroundDescriptor", "getElementsToSurround"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        this.myAdditionalSurrounders = new ArrayList<Surrounder>();
        if (file.getLanguage().is((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            this.myAdditionalSurrounders.add(new JSWithCastSurrounder());
        }
        if (expr.getParent() instanceof JSExpressionStatement) {
            this.myAdditionalSurrounders.addAll(Arrays.asList(new JSWithIfSurrounder(), new JSWithIfElseSurrounder()));
        }
        PsiElement[] psiElementArray = new PsiElement[]{expr};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/surroundWith/JSExpressionSurroundDescriptor", "getElementsToSurround"));
        }
        return psiElementArray;
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        if (this.myAdditionalSurrounders == null || this.myAdditionalSurrounders.size() == 0) {
            if (SURROUNDERS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/surroundWith/JSExpressionSurroundDescriptor", "getSurrounders"));
            }
            return SURROUNDERS;
        }
        Surrounder[] surrounderArray = (Surrounder[])ArrayUtil.mergeArrayAndCollection((Object[])SURROUNDERS, this.myAdditionalSurrounders, (ArrayFactory)Surrounder.myArrayFactory);
        if (surrounderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/surroundWith/JSExpressionSurroundDescriptor", "getSurrounders"));
        }
        return surrounderArray;
    }

    public boolean isExclusive() {
        return false;
    }

    private static JSExpression findExpressionInRange(PsiFile file, int startOffset, int endOffset) {
        JSExpression expression;
        PsiElement element1;
        PsiElement element2 = file.findElementAt(endOffset - 1);
        for (element1 = file.findElementAt(startOffset); element1 != null && (element1 instanceof PsiWhiteSpace || element1.getNode().getElementType() == JSTokenTypes.COMMA); element1 = element1.getNextSibling()) {
        }
        while (element2 != null && (element2 instanceof PsiWhiteSpace || element2.getNode().getElementType() == JSTokenTypes.COMMA)) {
            element2 = element2.getPrevSibling();
        }
        if (element1 != null) {
            startOffset = element1.getTextRange().getStartOffset();
        }
        if (element2 != null) {
            endOffset = element2.getTextRange().getEndOffset();
        }
        if ((expression = (JSExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)endOffset, JSExpression.class)) == null || expression.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        if (expression instanceof JSReferenceExpression && expression.getParent() instanceof JSCallExpression) {
            return null;
        }
        return expression;
    }
}

