/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSWithParenthesesSurrounder
implements Surrounder {
    public String getTemplateDescription() {
        return JSBundle.message((String)this.getMessageKey(), (Object[])new Object[0]);
    }

    protected String getMessageKey() {
        return "javascript.surround.with.parenthesis";
    }

    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/surroundWith/JSWithParenthesesSurrounder", "isApplicable"));
        }
        return true;
    }

    protected ASTNode getSurroundedNode(@NotNull JSExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/surroundWith/JSWithParenthesesSurrounder", "getSurroundedNode"));
        }
        return JSChangeUtil.createExpressionFromText(element.getProject(), this.getTemplateText(element), JSUtils.getDialect(element.getContainingFile()));
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/surroundWith/JSWithParenthesesSurrounder", "surroundElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/surroundWith/JSWithParenthesesSurrounder", "surroundElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/surroundWith/JSWithParenthesesSurrounder", "surroundElements"));
        }
        PsiElement source = elements[0];
        if (source instanceof JSExpressionStatement) {
            source = ((JSExpressionStatement)source).getExpression();
        }
        JSExpression expr = (JSExpression)source;
        ASTNode parenthExprNode = this.getSurroundedNode(expr);
        expr.getNode().getTreeParent().replaceChild(expr.getNode(), parenthExprNode);
        int offset = parenthExprNode.getTextRange().getEndOffset();
        return new TextRange(offset, offset);
    }

    protected String getTemplateText(JSExpression expr) {
        return "(" + expr.getText() + ")";
    }
}

