/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ui;

import com.intellij.ide.IconProvider;
import com.intellij.lang.ecmascript6.JSXHarmonyFileType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import icons.JavaScriptLanguageIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileIconProvider
extends IconProvider {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        JSFile jsFile;
        VirtualFile file;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ui/JSFileIconProvider", "getIcon"));
        }
        PsiFile psiFile = (PsiFile)ObjectUtils.tryCast((Object)element, PsiFile.class);
        if (psiFile == null) {
            return null;
        }
        FileType type = psiFile.getFileType();
        if (type == JavaScriptFileType.INSTANCE && (file = psiFile.getVirtualFile()) != null) {
            Project project = element.getProject();
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
            if (libraryManager.isLibraryFile(file)) {
                return JavaScriptLanguageIcons.Library.JsLibrary;
            }
            if (JSMinifiedFileUtil.isFileContentMinified(file)) {
                return JavaScriptLanguageIcons.Library.JsCompact;
            }
        }
        if ((jsFile = (JSFile)ObjectUtils.tryCast((Object)psiFile, JSFile.class)) != null && jsFile.isTestFile()) {
            if (type == TypeScriptFileType.INSTANCE) {
                return JavaScriptLanguageIcons.FileTypes.TypeScriptTest;
            }
            if (type == JSXHarmonyFileType.INSTANCE) {
                return JavaScriptLanguageIcons.FileTypes.Jsx_test_file;
            }
            if (DialectDetector.JAVASCRIPT_FILE_TYPES.contains(type)) {
                return JavaScriptLanguageIcons.FileTypes.JsTestFile;
            }
        }
        return null;
    }
}

