/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ui;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class NodeModuleNamesUtil {
    public static final String MODULES = "node_modules";
    private static final int MODULES_LENGTH = "node_modules".length();
    public static final String PACKAGE_JSON = "package.json";

    @NotNull
    public static String getModule(String file) {
        String string = NodeModuleNamesUtil.getModuleDirOrName(file, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/NodeModuleNamesUtil", "getModule"));
        }
        return string;
    }

    @NotNull
    public static String getModulePackageFile(String file) {
        String moduleDir = NodeModuleNamesUtil.getModuleDirOrName(file, false);
        if (StringUtil.isEmpty((String)moduleDir)) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/NodeModuleNamesUtil", "getModulePackageFile"));
            }
            return "";
        }
        String string = String.format("%s%s%s", moduleDir, File.separator, PACKAGE_JSON);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/NodeModuleNamesUtil", "getModulePackageFile"));
        }
        return string;
    }

    @NotNull
    private static String getModuleDirOrName(String file, boolean getName) {
        if (StringUtil.isEmpty((String)file)) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/NodeModuleNamesUtil", "getModuleDirOrName"));
            }
            return "";
        }
        int nodeModulesIndex = file.lastIndexOf(MODULES);
        if (nodeModulesIndex < 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/NodeModuleNamesUtil", "getModuleDirOrName"));
            }
            return "";
        }
        int nodeModulesEndIndex = nodeModulesIndex + MODULES_LENGTH + 1;
        int nextFileSeparatorIndex = file.indexOf(File.separator, nodeModulesEndIndex);
        if (nextFileSeparatorIndex < 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/NodeModuleNamesUtil", "getModuleDirOrName"));
            }
            return "";
        }
        String string = file.substring(getName ? nodeModulesEndIndex : 0, nextFileSeparatorIndex);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/NodeModuleNamesUtil", "getModuleDirOrName"));
        }
        return string;
    }
}

