/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.PredefinedImportSet;
import com.intellij.lang.javascript.flex.ScopedImportSet;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.UnusedImportsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptUnusedImportsHelper {
    private static final Key<CachedValue<Results>> ourUnusedImportsKey = Key.create((String)"js.unused.imports");
    private final THashSet<JSImportStatement> myUnused = new THashSet();
    private final Collection<JSReferenceExpression> fqnsToReplaceWithImport = new ArrayList<JSReferenceExpression>();
    private final PsiFile myContainingFile;
    private final Collection<PsiElement> myElements;
    private final MultiMap<JSImportStatement, JSReferenceExpression> myUsed = MultiMap.createSet();

    private ActionScriptUnusedImportsHelper(PsiFile containingFile, Collection<PsiElement> elements) {
        this.myContainingFile = containingFile;
        this.myElements = elements;
    }

    private void registerUnused(JSImportStatement importStatement) {
        if (!this.myUsed.containsKey((Object)importStatement) && importStatement.getImportText() != null) {
            this.myUnused.add((Object)importStatement);
        }
    }

    private void process(JSReferenceExpression node) {
        if (node.getQualifier() == null) {
            String thisPackage = JSResolveUtil.findPackageStatementQualifier((PsiElement)node);
            this.registerUsedImportsFromResolveResults(node, thisPackage);
        } else {
            if (PsiTreeUtil.getParentOfType((PsiElement)node, JSImportStatement.class) != null) {
                return;
            }
            if (node.getParent() instanceof JSClass && node.getPrevSibling() instanceof PsiWhiteSpace && node.getPrevSibling().getPrevSibling() != null && node.getPrevSibling().getPrevSibling().getNode().getElementType() == JSTokenTypes.CLASS_KEYWORD) {
                return;
            }
            JSReferenceExpression topReference = (JSReferenceExpression)JSResolveUtil.getTopReferenceExpression((PsiElement)node);
            if (topReference.getParent() instanceof JSPackageStatement && topReference.getPrevSibling() instanceof PsiWhiteSpace && topReference.getPrevSibling().getPrevSibling() != null && topReference.getPrevSibling().getPrevSibling().getNode().getElementType() == JSTokenTypes.PACKAGE_KEYWORD) {
                return;
            }
            this.registerUsedImportsFromResolveResults(node, null);
            Couple<Boolean> replaceStatus = UnusedImportsUtil.getReplaceStatus(node);
            if (((Boolean)replaceStatus.second).booleanValue() && ActionScriptUnusedImportsHelper.sameContainingFile(node.getContainingFile(), this.myContainingFile)) {
                this.fqnsToReplaceWithImport.add(node);
            }
        }
    }

    @Nullable
    private static JSImportStatement getUsedImportStatement(JSReferenceExpression node, String thisPackage) {
        for (ResolveResult r : node.multiResolve(false)) {
            JSImportStatement importStatement;
            if (!(r instanceof JSResolveResult) || (importStatement = ((JSResolveResult)r).getActionScriptImport()) == null || !UnusedImportsUtil.isInstance(r.getElement(), UnusedImportsUtil.REFERENCED_ELEMENTS_CLASSES)) continue;
            String importString = importStatement.getImportText();
            String importedPackage = StringUtil.getPackageName((String)importString);
            if (thisPackage != null && thisPackage.equals(importedPackage)) continue;
            return importStatement;
        }
        return null;
    }

    private void registerUsedImportsFromResolveResults(JSReferenceExpression node, String thisPackage) {
        JSImportStatement s = ActionScriptUnusedImportsHelper.getUsedImportStatement(node, thisPackage);
        if (s != null) {
            this.registerUsed(s, node);
        }
    }

    private static boolean sameContainingFile(PsiFile file1, PsiFile file2) {
        PsiFile containing2;
        PsiFile containing1 = ActionScriptUnusedImportsHelper.getContainingFile(file1);
        return containing1 == (containing2 = ActionScriptUnusedImportsHelper.getContainingFile(file2));
    }

    private void registerUsed(JSImportStatement importStatement, JSReferenceExpression node) {
        assert (importStatement.getImportText() != null);
        this.myUnused.remove((Object)importStatement);
        this.myUsed.putValue((Object)importStatement, (Object)node);
    }

    private Collection<JSImportStatement> filter(Collection<JSImportStatement> original) {
        ArrayList<JSImportStatement> result = new ArrayList<JSImportStatement>();
        for (JSImportStatement importStatement : original) {
            if (!this.isAcceptable(importStatement)) continue;
            result.add(importStatement);
        }
        return result;
    }

    private MultiMap<JSImportStatement, JSReferenceExpression> filter(MultiMap<JSImportStatement, JSReferenceExpression> original) {
        MultiMap result = MultiMap.createSet();
        for (JSImportStatement importStatement : original.keySet()) {
            if (!this.isAcceptable(importStatement)) continue;
            result.put((Object)importStatement, original.get((Object)importStatement));
        }
        return result;
    }

    private boolean isAcceptable(JSImportStatement importStatement) {
        return importStatement.isValid() && ActionScriptUnusedImportsHelper.sameContainingFile(importStatement.getContainingFile(), this.myContainingFile);
    }

    public static Results getUnusedImports(PsiFile file) {
        PsiFile containingFile = ActionScriptUnusedImportsHelper.getContainingFile(file);
        CachedValue data = (CachedValue)containingFile.getUserData(ourUnusedImportsKey);
        if (data == null) {
            data = CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> {
                HashMap<XmlTag, Collection<PsiElement>> allElements = new HashMap<XmlTag, Collection<PsiElement>>();
                THashSet processedFiles = new THashSet();
                ActionScriptUnusedImportsHelper.collectElements(containingFile, allElements, (Collection<JSFile>)processedFiles, null);
                Results allResults = new Results();
                for (Collection elements : allElements.values()) {
                    allResults.merge(new ActionScriptUnusedImportsHelper(containingFile, elements).getUnusedImports());
                }
                return new CachedValueProvider.Result((Object)allResults, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
            containingFile.putUserData(ourUnusedImportsKey, (Object)data);
        }
        return (Results)data.getValue();
    }

    private static PsiFile getContainingFile(PsiFile file) {
        return file.getContext() != null ? file.getContext().getContainingFile() : file;
    }

    private Results getUnusedImports() {
        for (PsiElement psiElement : this.myElements) {
            if (psiElement instanceof JSImportStatement) {
                JSImportStatement importStatement = (JSImportStatement)psiElement;
                this.registerUnused(importStatement);
                continue;
            }
            if (!(psiElement instanceof JSReferenceExpression)) continue;
            this.process((JSReferenceExpression)psiElement);
        }
        MultiMap importsByHolder = MultiMap.createSet();
        for (JSImportStatement anImport : this.myUsed.keySet()) {
            if (!this.isAcceptable(anImport)) continue;
            Computable<JSElement> importHolder = ImportUtils.getImportHolder((PsiElement)anImport, true, JSFunction.class, JSPackageStatement.class, JSFile.class);
            assert (importHolder != null) : "Import holder not found for " + anImport.getText();
            ActionScriptUnusedImportsHelper.addImport((MultiMap<Computable<JSElement>, String>)importsByHolder, importHolder, anImport.getImportText());
        }
        ArrayList<JSReferenceExpression> arrayList = new ArrayList<JSReferenceExpression>();
        for (JSReferenceExpression qualifiedReference : this.fqnsToReplaceWithImport) {
            Collection imports;
            Computable<JSElement> importHolder;
            Computable<JSElement> enclosingFunction = ImportUtils.getImportHolder((PsiElement)qualifiedReference, false, JSFunction.class);
            Computable<JSElement> enclosingPackage = ImportUtils.getImportHolder((PsiElement)qualifiedReference, false, JSPackageStatement.class);
            if (enclosingFunction != null && !importsByHolder.get(enclosingFunction).isEmpty()) {
                importHolder = enclosingFunction;
                imports = new THashSet(importsByHolder.get(enclosingFunction));
                imports.addAll(importsByHolder.get(enclosingPackage));
            } else if (enclosingPackage != null) {
                importHolder = enclosingPackage;
                imports = importsByHolder.get(enclosingPackage);
            } else {
                importHolder = ImportUtils.getImportHolder((PsiElement)qualifiedReference, false, JSFile.class);
                imports = importsByHolder.get(importHolder);
            }
            THashSet qnames = new THashSet();
            String referencedName = qualifiedReference.getReferencedName();
            if (referencedName != null) {
                for (ResolveResult result : JSReferenceExpressionImpl.resolveUnqualified(referencedName, (PsiElement)qualifiedReference, null)) {
                    PsiElement parent;
                    if (!(result instanceof JSResolveResult) || this.myUnused.contains((Object)((JSResolveResult)result).getActionScriptImport())) continue;
                    PsiElement element = result.getElement();
                    if (qualifiedReference.getParent() instanceof JSNewExpression && element instanceof JSFunction && ((JSFunction)element).isConstructor() && (parent = element.getParent()) instanceof JSQualifiedNamedElement) {
                        element = parent;
                    }
                    qnames.add(((JSQualifiedNamedElement)element).getQualifiedName());
                }
            }
            PredefinedImportSet predefinedImportSet = new PredefinedImportSet(imports);
            predefinedImportSet.process(qualifiedReference.getReferencedName(), null, (PsiNamedElement)this.myContainingFile, new ScopedImportSet.ImportProcessor<Object>((Collection)qnames){
                final /* synthetic */ Collection val$qnames;
                {
                    this.val$qnames = collection;
                }

                @Override
                public Object process(@NotNull String referenceName, @NotNull ScopedImportSet.ImportProcessor.ImportInfo info, @NotNull PsiNamedElement scope) {
                    if (referenceName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/lang/javascript/validation/ActionScriptUnusedImportsHelper$1", "process"));
                    }
                    if (info == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/validation/ActionScriptUnusedImportsHelper$1", "process"));
                    }
                    if (scope == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/validation/ActionScriptUnusedImportsHelper$1", "process"));
                    }
                    JSImportedElementResolveResult elementResolveResult = ScopedImportSet.resolveImportedClass(referenceName, scope, info);
                    if (elementResolveResult != null) {
                        this.val$qnames.add(elementResolveResult.qualifiedName);
                    }
                    return null;
                }
            });
            String fqn = qualifiedReference.getText();
            if (qnames.isEmpty()) {
                arrayList.add(qualifiedReference);
                importsByHolder.putValue(importHolder, (Object)fqn);
                continue;
            }
            if (qnames.size() != 1 || !fqn.equals(ContainerUtil.getFirstItem((Collection)qnames, null))) continue;
            arrayList.add(qualifiedReference);
        }
        return new Results(arrayList, this.filter((Collection<JSImportStatement>)this.myUnused), importsByHolder, this.filter(this.myUsed));
    }

    private static void addImport(MultiMap<Computable<JSElement>, String> importsByHolder, Computable<JSElement> importHolder, String newImport) {
        String newPackageName = StringUtil.getPackageName((String)newImport);
        String newShortName = StringUtil.getShortName((String)newImport);
        Iterator i = importsByHolder.get(importHolder).iterator();
        while (i.hasNext()) {
            String existing = (String)i.next();
            String existingPackageName = StringUtil.getPackageName((String)existing);
            String existingShortName = StringUtil.getShortName((String)existing);
            if (!existingPackageName.equals(newPackageName)) continue;
            if ("*".equals(existingShortName) && !"*".equals(newShortName)) {
                return;
            }
            if (!"*".equals(newShortName)) continue;
            i.remove();
        }
        importsByHolder.putValue(importHolder, (Object)newImport);
    }

    private static void collectElements(PsiFile file, final Map<XmlTag, Collection<PsiElement>> result, final Collection<JSFile> processedFiles, final @Nullable XmlTag rootTag) {
        if (processedFiles.contains(file)) {
            return;
        }
        if (file instanceof JSFile) {
            processedFiles.add((JSFile)file);
            PsiTreeUtil.processElements((PsiElement)file, (PsiElementProcessor)new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/validation/ActionScriptUnusedImportsHelper$2", "execute"));
                    }
                    if (element instanceof JSIncludeDirective) {
                        PsiFile includedFile = ((JSIncludeDirective)element).resolveFile();
                        if (includedFile instanceof JSFile && !processedFiles.contains((JSFile)includedFile)) {
                            includedFile.putUserData(JSResolveUtil.contextKey, (Object)element);
                            ActionScriptUnusedImportsHelper.collectElements(includedFile, result, processedFiles, rootTag);
                        }
                    } else if (element instanceof JSElement && !(element instanceof JSFile)) {
                        ArrayList<PsiElement> elements = (ArrayList<PsiElement>)result.get(rootTag);
                        if (elements == null) {
                            elements = new ArrayList<PsiElement>();
                            result.put(rootTag, elements);
                        }
                        elements.add(element);
                    }
                    return true;
                }
            });
        } else {
            XmlBackedJSClass jsClass = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)file);
            if (jsClass != null) {
                jsClass.visitInjectedFiles(new XmlBackedJSClass.InjectedFileVisitor(){

                    public void visit(XmlTag rootTag, JSFile jsFile) {
                        ActionScriptUnusedImportsHelper.collectElements((PsiFile)jsFile, result, processedFiles, rootTag);
                    }
                });
            }
        }
    }

    public static class Results {
        public final Collection<JSImportStatement> unusedImports;
        public final MultiMap<Computable<JSElement>, String> importsByHolder;
        public final Collection<JSReferenceExpression> fqnsToReplaceWithShortName;
        public final MultiMap<JSImportStatement, JSReferenceExpression> usedImports;

        private Results(Collection<JSReferenceExpression> fqnsToReplaceWithShortName, Collection<JSImportStatement> unusedImports, MultiMap<Computable<JSElement>, String> importsByHolder, MultiMap<JSImportStatement, JSReferenceExpression> usedImports) {
            this.fqnsToReplaceWithShortName = fqnsToReplaceWithShortName;
            this.unusedImports = unusedImports;
            this.importsByHolder = importsByHolder;
            this.usedImports = usedImports;
        }

        private Results() {
            this(new ArrayList<JSReferenceExpression>(), (Collection<JSImportStatement>)new THashSet(), (MultiMap<Computable<JSElement>, String>)MultiMap.createSet(), (MultiMap<JSImportStatement, JSReferenceExpression>)MultiMap.createSet());
        }

        private void merge(Results results) {
            this.fqnsToReplaceWithShortName.addAll(results.fqnsToReplaceWithShortName);
            results.unusedImports.removeAll(this.usedImports.keySet());
            this.unusedImports.addAll(results.unusedImports);
            for (Computable holder : results.importsByHolder.keySet()) {
                for (String s : results.importsByHolder.get((Object)holder)) {
                    this.importsByHolder.putValue((Object)holder, (Object)s);
                }
            }
            for (JSImportStatement anImport : results.usedImports.keySet()) {
                this.usedImports.put((Object)anImport, results.usedImports.get((Object)anImport));
                this.unusedImports.remove(anImport);
            }
        }

        public Collection<JSImportStatement> getAllImports() {
            ArrayList<JSImportStatement> result = new ArrayList<JSImportStatement>(this.unusedImports);
            result.addAll(this.usedImports.keySet());
            return result;
        }
    }
}

