/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeJSDocTypeFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final String myType;
    private final String myNameKey;
    @NotNull
    private SmartPsiElementPointer<PsiElement> myCommentPointer;

    public ChangeJSDocTypeFix(@NotNull JSNamedElement psiElement, @NotNull PsiElement comment, @NotNull JSType newType) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/validation/fixes/ChangeJSDocTypeFix", "<init>"));
        }
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/validation/fixes/ChangeJSDocTypeFix", "<init>"));
        }
        if (newType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newType", "com/intellij/lang/javascript/validation/fixes/ChangeJSDocTypeFix", "<init>"));
        }
        super((PsiElement)psiElement);
        this.myCommentPointer = SmartPointerManager.getInstance((Project)comment.getProject()).createSmartPsiElementPointer(comment);
        this.myType = newType.getTypeText(JSType.TypeTextFormat.CODE);
        this.myNameKey = psiElement instanceof JSParameter ? "javascript.fix.change.parameter.type" : (psiElement instanceof JSFunction ? "javascript.fix.set.method.return.type" : "javascript.fix.change.type");
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        String paramName;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/ChangeJSDocTypeFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/fixes/ChangeJSDocTypeFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/validation/fixes/ChangeJSDocTypeFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/validation/fixes/ChangeJSDocTypeFix", "invoke"));
        }
        PsiElement comment = this.myCommentPointer.getElement();
        if (!(comment instanceof JSDocComment)) {
            return;
        }
        JSDocTag[] tags = ((JSDocComment)comment).getTags();
        JSDocumentationProcessor.MetaDocType requiredTagName = startElement instanceof JSParameter ? JSDocumentationProcessor.MetaDocType.PARAMETER : (startElement instanceof JSFunction ? JSDocumentationProcessor.MetaDocType.RETURN : JSDocumentationProcessor.MetaDocType.TYPE);
        String string = paramName = startElement instanceof JSParameter ? ((JSParameter)startElement).getName() : null;
        if (requiredTagName == JSDocumentationProcessor.MetaDocType.PARAMETER && paramName == null) {
            return;
        }
        Optional<JSDocTagValue> typeValue = Arrays.stream(tags).map(tag -> {
            JSDocumentationUtils.DocTag docTag = JSDocumentationUtils.getDocTag(tag.getText());
            JSDocTagValue value = tag.getValue();
            return docTag != null && docTag.type == requiredTagName && value != null && (requiredTagName != JSDocumentationProcessor.MetaDocType.PARAMETER || paramName.equals(docTag.matchName)) ? value : null;
        }).filter(value -> value != null).findFirst();
        if (!typeValue.isPresent()) {
            return;
        }
        JSDocTagValue typeElement = typeValue.get();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(typeElement.getContainingFile());
        if (document != null) {
            boolean wrapInBrackets = typeElement.getText().startsWith("{");
            document.replaceString(typeElement.getTextRange().getStartOffset(), typeElement.getTextRange().getEndOffset(), (CharSequence)(wrapInBrackets ? "{" + this.myType + "}" : this.myType));
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)this.myNameKey, (Object[])new Object[]{((JSNamedElement)this.getStartElement()).getName(), this.myType});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ChangeJSDocTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"javascript.change.jsdoc.type.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ChangeJSDocTypeFix", "getFamilyName"));
        }
        return string;
    }
}

