/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ImplementJSDocMethodsFix
implements LocalQuickFix {
    final String myClassName;
    final Map<String, String> myNonimplemented;

    public ImplementJSDocMethodsFix(@NotNull String className, Map<String, String> nonimplemented) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/lang/javascript/validation/fixes/ImplementJSDocMethodsFix", "<init>"));
        }
        this.myClassName = className;
        this.myNonimplemented = nonimplemented;
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"javascript.fix.implement.methods", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ImplementJSDocMethodsFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/ImplementJSDocMethodsFix", "applyFix"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/validation/fixes/ImplementJSDocMethodsFix", "applyFix"));
        }
        JSSourceElement anchor = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), JSSourceElement.class, (boolean)false);
        if (anchor == null) {
            String text = descriptor2.getPsiElement().getContainingFile().getText();
            Logger.getInstance(ImplementJSDocMethodsFix.class).error("anchor is null", new Attachment[]{new Attachment("file.js", text)});
            return;
        }
        for (Map.Entry<String, String> method : this.myNonimplemented.entrySet()) {
            String builder = this.myClassName + ".prototype." + method.getKey() + " = function" + method.getValue() + "{};";
            PsiElement methodImplementation = JSChangeUtil.createJSTreeFromText(project, builder).getPsi();
            anchor.getParent().addAfter(methodImplementation, (PsiElement)anchor);
        }
    }
}

