/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ReplacePsiElementFix
implements IntentionAction {
    private PsiElement mySource;
    private PsiElement myTarget;
    private Function<Void, PsiElement> myTargetGenerator;
    private String myNameKey;

    public ReplacePsiElementFix(PsiElement source, PsiElement target, String nameKey) {
        this(source, (Function<Void, PsiElement>)((Function)aVoid -> target), nameKey);
    }

    public ReplacePsiElementFix(PsiElement source, Function<Void, PsiElement> targetGenerator, String nameKey) {
        this.mySource = source;
        this.myTargetGenerator = targetGenerator;
        this.myNameKey = nameKey;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)this.myNameKey, (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ReplacePsiElementFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/ReplacePsiElementFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/ReplacePsiElementFix", "isAvailable"));
        }
        this.initTarget();
        return this.mySource.isValid() && this.myTarget.isValid();
    }

    private void initTarget() {
        if (this.myTarget == null) {
            this.myTarget = (PsiElement)this.myTargetGenerator.fun(null);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/ReplacePsiElementFix", "invoke"));
        }
        this.initTarget();
        this.mySource.replace(this.myTarget);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

