/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.TypeScriptFunctionSignatureGenerator;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.lang.typescript.psi.TypeScriptChangeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImplementMethodsFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final TypeScriptFunctionSignatureGenerator TS_SIGNATURE_GENERATOR = new TypeScriptFunctionSignatureGenerator();

    public TypeScriptImplementMethodsFix(JSClass clazz) {
        super((PsiElement)clazz);
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"javascript.implement.all.interfaces", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSClass jsClass;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "invoke"));
        }
        JSClass jSClass = jsClass = startElement instanceof JSClass ? (JSClass)startElement : null;
        if (jsClass == null) {
            return;
        }
        TypeScriptImplementMethodsFix.invokeOnClass(jsClass);
    }

    public static void invokeOnClass(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "invokeOnClass"));
        }
        Project project = jsClass.getProject();
        ASTNode anchorNode = jsClass.getNode().findChildByType(JSTokenTypes.LBRACE);
        if (anchorNode == null) {
            return;
        }
        ArrayList<JSNamedElement> properties = new ArrayList<JSNamedElement>();
        MultiMap functions = MultiMap.createLinked();
        Map<JSNamedElement, JSClass> members = TypeScriptUtil.getUnimplementedMembers(jsClass, false);
        TypeScriptImplementMethodsFix.collectPropertiesAndFunctionsForImplementation(members, properties, (MultiMap<String, JSFunction>)functions);
        PsiElement anchor = anchorNode.getPsi();
        for (JSNamedElement property : properties) {
            anchor = TypeScriptImplementMethodsFix.addPropertyToClass(project, jsClass, anchor, property, members.get(property));
        }
        for (Map.Entry functionsWithName : functions.entrySet()) {
            Collection toProcess = (Collection)functionsWithName.getValue();
            anchor = TypeScriptImplementMethodsFix.addFunctionToClass(jsClass, (String)functionsWithName.getKey(), toProcess, members, anchor);
        }
    }

    private static void collectPropertiesAndFunctionsForImplementation(Map<JSNamedElement, JSClass> membersToImplement, List<JSNamedElement> properties, MultiMap<String, JSFunction> functions) {
        for (JSNamedElement member : membersToImplement.keySet()) {
            if (TypeScriptUtil.isTypeScriptMethod((PsiElement)member)) {
                functions.putValue((Object)JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)member, false), (Object)((JSFunction)member));
                continue;
            }
            if (!TypeScriptUtil.isTypeScriptProperty((PsiElement)member)) continue;
            properties.add(member);
        }
    }

    private static PsiElement addPropertyToClass(Project project, JSClass jsClass, PsiElement anchor, JSNamedElement property, JSClass interfaceForImplement) {
        String text;
        String name = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)property, false);
        if (name == null) {
            return anchor;
        }
        StringBuilder builder = new StringBuilder(name);
        JSType type = null;
        if (property instanceof TypeScriptPropertySignature) {
            type = ((TypeScriptPropertySignature)property).getType();
        } else if (property instanceof JSVariable) {
            type = ((JSVariable)property).getType();
        }
        if (type != null && !StringUtil.isEmpty((String)(text = BaseCreateMethodsFix.getProcessedType(type, jsClass, (PsiElement)interfaceForImplement)))) {
            builder.append(": ").append(text);
        }
        builder.append(JSCodeStyleSettings.getSemicolon(anchor.getContainingFile()));
        PsiElement element = TypeScriptChangeUtil.createClassMemberFromText(project, builder.toString());
        anchor = jsClass.addAfter(element, anchor);
        return anchor;
    }

    @Nullable
    private static PsiElement addFunctionToClass(@NotNull JSClass jsClass, @Nullable String name, @NotNull Collection<JSFunction> functions, @NotNull Map<JSNamedElement, JSClass> allMembers, @Nullable PsiElement anchor) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "addFunctionToClass"));
        }
        if (functions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "addFunctionToClass"));
        }
        if (allMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allMembers", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "addFunctionToClass"));
        }
        if (name == null) {
            return anchor;
        }
        assert (!functions.isEmpty());
        if (functions.size() == 1) {
            JSFunction function = (JSFunction)ContainerUtil.getFirstItem(functions);
            assert (function != null);
            return TypeScriptImplementMethodsFix.addDistinctFunctionToClass(function, name, jsClass, anchor, allMembers);
        }
        return TypeScriptImplementMethodsFix.addFunctionsToClass(functions, name, jsClass, anchor, allMembers);
    }

    private static PsiElement addFunctionsToClass(@NotNull Collection<JSFunction> functions, String name, JSClass jsClass, PsiElement anchor, Map<JSNamedElement, JSClass> allMembers) {
        if (functions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "addFunctionsToClass"));
        }
        for (JSFunction function : functions) {
            StringBuilder result = TypeScriptImplementMethodsFix.buildSignatureText(function, jsClass, name, allMembers);
            if (result == null) continue;
            TypeScriptImplementMethodsFix.fixSemicolon((PsiElement)jsClass, result);
            PsiElement element = TypeScriptChangeUtil.createClassMemberFromText(jsClass.getProject(), result.toString());
            anchor = jsClass.addAfter(element, anchor);
        }
        if (TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)jsClass)) {
            return anchor;
        }
        Signature signatureInfo = TypeScriptImplementMethodsFix.getParametersAndReturnType(functions, jsClass, allMembers);
        JSFunctionSignatureInfo info = new JSFunctionSignatureInfo(name);
        info.setScope(JSFunctionSignatureInfo.Scope.CLASS);
        JSAttributeList.AccessType type = signatureInfo.accessType;
        if (type != null) {
            info.setAccessType(type);
        }
        info.setReturnType(signatureInfo.returnTypeString);
        int count = 1;
        for (ParameterInfo param : signatureInfo.params) {
            String parameterName = param.name;
            if (parameterName == null) {
                parameterName = "p" + count++;
            }
            if (param.isRest) {
                parameterName = "... " + parameterName;
            } else if (param.isOptional) {
                parameterName = parameterName + "?";
            }
            info.addParameterAndType(parameterName, param.type);
        }
        StringBuilder signature = TS_SIGNATURE_GENERATOR.getSignature(info, (PsiElement)jsClass);
        TypeScriptImplementMethodsFix.appendFunctionBody(jsClass, signatureInfo.returnType, signature);
        PsiElement element = TypeScriptChangeUtil.createClassMemberFromText(jsClass.getProject(), signature.toString());
        return jsClass.addAfter(element, anchor);
    }

    private static Signature getParametersAndReturnType(@NotNull Collection<JSFunction> functions, JSClass jsResultClass, Map<JSNamedElement, JSClass> allMembers) {
        if (functions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "getParametersAndReturnType"));
        }
        Signature result = new Signature();
        List<ParameterInfo> infos = result.params;
        boolean isFirst = true;
        boolean hasParametersList = false;
        int minParameterCount = Integer.MAX_VALUE;
        for (JSFunction function : functions) {
            JSParameterListElement[] parameters;
            String newReturnType;
            JSType returnType;
            JSClass surroundClass = allMembers.get(function);
            if (isFirst) {
                returnType = function.getReturnType();
                result.returnTypeString = BaseCreateMethodsFix.getProcessedType(returnType, jsResultClass, (PsiElement)surroundClass);
                result.returnType = returnType;
                isFirst = false;
            } else if (result.returnTypeString != null && !"any".equals(result.returnTypeString) && !StringUtil.equals((CharSequence)(newReturnType = BaseCreateMethodsFix.getProcessedType(returnType = function.getReturnType(), jsResultClass, (PsiElement)surroundClass)), (CharSequence)result.returnTypeString)) {
                result.returnTypeString = "any";
                result.returnType = null;
            }
            JSAttributeList.AccessType accessType = function.getAccessType();
            if (result.accessType != accessType) {
                if (result.accessType == null) {
                    result.accessType = accessType;
                } else if (result.accessType == JSAttributeList.AccessType.PROTECTED) {
                    result.accessType = JSAttributeList.AccessType.PUBLIC;
                }
            }
            if (!hasParametersList && function instanceof TypeScriptFunction) {
                boolean bl = hasParametersList = ((TypeScriptFunction)function).getTypeParameterList() != null;
            }
            if (minParameterCount > (parameters = function.getParameters()).length) {
                minParameterCount = parameters.length;
            }
            for (int i = 0; i < parameters.length; ++i) {
                String type;
                ParameterInfo info;
                JSParameterListElement parameter = parameters[i];
                ParameterInfo parameterInfo = info = infos.size() > i ? infos.get(i) : null;
                if (info == null) {
                    info = new ParameterInfo();
                    type = BaseCreateMethodsFix.getProcessedType(TypeScriptImplementMethodsFix.getParameterType((JSParameterItem)parameter), jsResultClass, (PsiElement)surroundClass);
                    info.name = parameter.getName();
                    info.type = type;
                    info.isOptional = parameter.isOptional();
                    info.isRest = parameter.isRest();
                    infos.add(info);
                    continue;
                }
                type = BaseCreateMethodsFix.getProcessedType(TypeScriptImplementMethodsFix.getParameterType((JSParameterItem)parameter), jsResultClass, (PsiElement)surroundClass);
                if (!StringUtil.equals((CharSequence)type, (CharSequence)info.type)) {
                    info.type = null;
                }
                if (info.isOptional != parameter.isOptional()) {
                    info.isOptional = true;
                }
                if (info.isRest == parameter.isRest()) continue;
                info.isRest = true;
            }
        }
        boolean matchedRest = false;
        for (int i = 0; i < infos.size(); ++i) {
            int parameterNumber = i + 1;
            ParameterInfo info = infos.get(i);
            if (hasParametersList) {
                String string = info.type = ArrayUtil.contains((String)info.type, (String[])JSCommonTypeNames.ALL) ? info.type : null;
            }
            if (parameterNumber > minParameterCount || matchedRest) {
                info.isOptional = true;
            }
            if (info.isRest && parameterNumber != infos.size()) {
                info.type = null;
                matchedRest = true;
                continue;
            }
            if (!matchedRest) continue;
            info.type = null;
            info.isRest = parameterNumber == infos.size();
        }
        return result;
    }

    @Nullable
    private static PsiElement addDistinctFunctionToClass(JSFunction function, String name, JSClass jsClass, PsiElement anchor, Map<JSNamedElement, JSClass> allMembers) {
        StringBuilder result = TypeScriptImplementMethodsFix.buildSignatureText(function, jsClass, name, allMembers);
        if (result == null) {
            return anchor;
        }
        TypeScriptImplementMethodsFix.appendFunctionBody(jsClass, function.getReturnType(), result);
        PsiElement element = TypeScriptChangeUtil.createClassMemberFromText(jsClass.getProject(), result.toString());
        anchor = jsClass.addAfter(element, anchor);
        return anchor;
    }

    private static StringBuilder buildSignatureText(JSFunction function, JSClass jsResultClass, String name, Map<JSNamedElement, JSClass> allMembers) {
        String generics;
        TypeScriptFunction typeScriptFunction;
        TypeScriptTypeParameterList list;
        JSParameterListElement[] parameters;
        JSClass interfaceForImplement = allMembers.get(function);
        JSFunctionSignatureInfo info = new JSFunctionSignatureInfo(name);
        info.setScope(JSFunctionSignatureInfo.Scope.CLASS);
        info.setAccessType(function.getAccessType());
        for (JSParameterListElement parameter : parameters = function.getParameters()) {
            String parameterName = parameter.getName();
            if (parameterName == null) continue;
            if (parameter.isRest()) {
                parameterName = "... " + parameterName;
            } else if (parameter.isOptional()) {
                parameterName = parameterName + "?";
            }
            info.addParameterAndType(parameterName, BaseCreateMethodsFix.getProcessedType(TypeScriptImplementMethodsFix.getParameterType((JSParameterItem)parameter), jsResultClass, (PsiElement)interfaceForImplement));
        }
        if (function instanceof TypeScriptFunction && (list = (typeScriptFunction = (TypeScriptFunction)function).getTypeParameterList()) != null && !StringUtil.isEmpty((String)(generics = TypeScriptUtil.buildParameterTypeListStringWithApplyingGenerics(typeScriptFunction, jsResultClass)))) {
            info.setTypeParameterList(generics);
        }
        JSType returnType = function.getReturnType();
        info.setReturnType(BaseCreateMethodsFix.getProcessedType(returnType, jsResultClass, (PsiElement)interfaceForImplement));
        return TS_SIGNATURE_GENERATOR.getSignature(info, (PsiElement)jsResultClass);
    }

    @Nullable
    private static JSType getParameterType(JSParameterItem parameter) {
        if (parameter.isRest() && parameter instanceof StubBasedPsiElementBase) {
            return TypeScriptPsiUtil.getTypeFromDeclaration((StubBasedPsiElementBase)parameter);
        }
        return parameter.getType();
    }

    private static void appendFunctionBody(JSClass jsClass, JSType returnType, StringBuilder builder) {
        if (TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)jsClass)) {
            TypeScriptImplementMethodsFix.fixSemicolon((PsiElement)jsClass, builder);
            return;
        }
        builder.append("{");
        if (returnType != null && !(returnType instanceof JSVoidType)) {
            builder.append("\n");
            TypeScriptImplementMethodsFix.appendEmptyBodyWithReturn((PsiElement)jsClass, builder);
        }
        builder.append("\n}");
    }

    public static void appendEmptyBodyWithReturn(@NotNull PsiElement context, @NotNull StringBuilder builder) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "appendEmptyBodyWithReturn"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMethodsFix", "appendEmptyBodyWithReturn"));
        }
        TypeScriptImplementMethodsFix.fixSemicolon(context, builder.append("return undefined"));
    }

    private static void fixSemicolon(PsiElement context, StringBuilder builder) {
        builder.append(JSCodeStyleSettings.getSemicolon(context.getContainingFile()));
    }

    private static class ParameterInfo {
        String name;
        String type;
        boolean isOptional;
        boolean isRest;

        private ParameterInfo() {
        }
    }

    private static class Signature {
        List<ParameterInfo> params = ContainerUtil.newArrayList();
        String returnTypeString;
        JSType returnType;
        JSAttributeList.AccessType accessType = null;

        private Signature() {
        }
    }
}

