/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.scopeChooser.ScopeChooserUtils;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSFileHighlightingInfo;
import com.intellij.lang.javascript.service.JSHighlightingInfoBuilder;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceToolWindowInfoReporter;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceAnnotatorCheckerProvider;
import com.intellij.lang.typescript.compiler.TypeScriptToolWindowProvider;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptLanguageServiceFix;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptLanguageServiceFixSet;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptLanguageServiceCacheImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptServiceStandardOutputProtocol;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompileCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompileFileArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompletionsCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompletionsRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompositeCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompositeRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileObject;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetErrCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetMainFileErrCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetProjectErrCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadProjectsCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptUpdateFilesContent;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCompletionResponse;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptDiagnosticsResponse;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServerServiceImpl
extends TypeScriptCompilerService {
    private static final int TIME_TO_MERGE_COMPILE_EVENTS_MILLS = 2500;
    private static final int TIME_TO_MERGE_PROJECT_EVENTS_MILLS = 2500;
    public static final String BODY_FIELD = "body";
    public static final String GENERATED_FILES_FIELD = "generatedFiles";
    public static final String PROCESSED_FILES_FIELD = "processedFiles";
    public static final int NO_FIX_CODE = -1;
    private static final String TYPE_SCRIPT_COMPILER_INFO = "TypeScript Compiler Info";
    @NotNull
    private final MergingUpdateQueue myCompileQueue;
    @NotNull
    private final MergingUpdateQueue myProjectErrorsQueue;
    protected volatile int[] myErrorCodeFixes;
    @NotNull
    protected final TypeScriptCompilerSettings mySettings;
    @NotNull
    private final JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> myCompletionDefaultProcessor;
    @NotNull
    private final JSLanguageServiceCommandProcessor<Boolean> myUpdateDefaultProcessor;

    public TypeScriptServerServiceImpl(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "<init>"));
        }
        this(project, settings, "Console");
    }

    protected TypeScriptServerServiceImpl(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings, @NotNull String consoleId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "<init>"));
        }
        if (consoleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleId", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "<init>"));
        }
        super(project, consoleId);
        this.myErrorCodeFixes = new int[0];
        this.myCompletionDefaultProcessor = new JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>>(){

            @Override
            @NotNull
            public List<TypeScriptCompletionResponse.CompletionEntryDetail> process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                TypeScriptCompletionResponse response;
                block8: {
                    List list;
                    if (serviceObject == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "process"));
                    }
                    if (answer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "process"));
                    }
                    JsonObject element = answer.getElement();
                    try {
                        response = (TypeScriptCompletionResponse)JSLanguageServiceQueueImpl.GSON.fromJson((JsonElement)element, TypeScriptCompletionResponse.class);
                        if (response != null && response.body != null) break block8;
                        list = ContainerUtil.emptyList();
                    }
                    catch (Exception e) {
                        JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
                        List list2 = ContainerUtil.emptyList();
                        if (list2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "process"));
                        }
                        return list2;
                    }
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "process"));
                    }
                    return list;
                }
                ArrayList arrayList = ContainerUtil.newArrayList((Object[])response.body);
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$1", "process"));
                }
                return arrayList;
            }
        };
        this.myUpdateDefaultProcessor = new JSLanguageServiceCommandProcessor<Boolean>(){

            @Override
            @NotNull
            public Boolean process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                if (serviceObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$2", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$2", "process"));
                }
                if (serviceObject instanceof TypeScriptUpdateFilesContent && TypeScriptServerServiceImpl.this.isCompileEnabled()) {
                    TypeScriptServerServiceImpl.this.addFileToCompileQueue(((TypeScriptUpdateFilesContent)serviceObject).files.keySet());
                }
                Boolean bl = true;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$2", "process"));
                }
                return bl;
            }
        };
        this.mySettings = settings;
        this.myCompileQueue = new MergingUpdateQueue("TypeScript Compile queue", 2500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myProjectErrorsQueue = new MergingUpdateQueue("TypeScript Project Errors queue", 2500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    @Override
    public void sendCleanCommandToCompiler(@NotNull TypeScriptServiceCommandClean command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "sendCleanCommandToCompiler"));
        }
        if (!this.isServiceCreated()) {
            return;
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process != null) {
            String path = command.getCompilerId();
            if (StringUtil.isEmpty((String)path)) {
                this.sendCommand(new TypeScriptReloadProjectsCommand());
            } else {
                TypeScriptFileWithConfigArgs args = new TypeScriptFileWithConfigArgs();
                args.projectFileName = path;
                this.sendCommand(new TypeScriptReloadProjectsCommand(args));
            }
            process.resetCaches();
        }
    }

    @Override
    protected void addFileToCompileQueue(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "addFileToCompileQueue"));
        }
        if (!this.isCompileEnabled()) {
            return;
        }
        GlobalSearchScope scope = this.getScope();
        List fileNames = ContainerUtil.mapNotNull(files, el -> {
            if (el.isInLocalFileSystem() && el.isValid() && scope.accept(el) && null == el.getUserData(JSLanguageServiceQueue.GENERATED_FILE_MARKER)) {
                return TypeScriptCompilerConfigUtil.normalizeNameAndPath(el);
            }
            return null;
        });
        if (!files.isEmpty()) {
            this.myCompileQueue.queue(new Update(new TypeScriptCompileUpdater(), 10){

                public void run() {
                    if (TypeScriptServerServiceImpl.this.isServiceCreated()) {
                        JSLanguageServiceUpdateContext context = (JSLanguageServiceUpdateContext)ReadAction.compute(() -> JSHighlightingInfoBuilder.createUpdateContext(TypeScriptServerServiceImpl.this.myProject, TypeScriptServerServiceImpl.this.getAcceptableFilesFilter()));
                        TypeScriptServerServiceImpl.this.update(context);
                    }
                }
            });
        }
        this.addFileToCompileQueue(fileNames);
    }

    @Override
    public Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> updateAndGetCompletionItems(@NotNull VirtualFile virtualFile, @NotNull PsiFile file, @NotNull Document document, int positionInFileOffset) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateAndGetCompletionItems"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateAndGetCompletionItems"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateAndGetCompletionItems"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return null;
        }
        JSLanguageServiceUpdateContext context = JSHighlightingInfoBuilder.createUpdateContext(file.getProject(), this.getAcceptableFilesFilter());
        TypeScriptLanguageServiceUpdateCommand updateCommand = this.getUpdateFilesCommand(context);
        JSLanguageServiceCommandProcessor<Boolean> updateProcessor = this.createUpdateProcessor();
        TypeScriptCompletionsRequestArgs args = new TypeScriptCompletionsRequestArgs();
        TypeScriptLanguageServiceUtil.fillFilePosition(args, virtualFile, document, positionInFileOffset);
        JSLanguageServiceSimpleCommand completionCommand = this.createCompletionCommand(args, virtualFile, file);
        JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> completionProcessor = this.createCompletionProcessor();
        JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> processor = TypeScriptServerServiceImpl.createCompletionCompositeProcessor(updateCommand, completionCommand, updateProcessor, completionProcessor);
        return process.execute(new TypeScriptCompositeCommand(updateCommand, completionCommand), processor);
    }

    @Override
    @Nullable
    public TypeScriptServerServiceSettings getServiceSettings() {
        return null;
    }

    @NotNull
    private static JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> createCompletionCompositeProcessor(final @NotNull TypeScriptLanguageServiceUpdateCommand updateCommand, final @NotNull JSLanguageServiceSimpleCommand completionCommand, final @NotNull JSLanguageServiceCommandProcessor<Boolean> updateProcessor, final @NotNull JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> completionProcessor) {
        if (updateCommand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateCommand", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createCompletionCompositeProcessor"));
        }
        if (completionCommand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionCommand", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createCompletionCompositeProcessor"));
        }
        if (updateProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateProcessor", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createCompletionCompositeProcessor"));
        }
        if (completionProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionProcessor", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createCompletionCompositeProcessor"));
        }
        JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> jSLanguageServiceCommandProcessor = new JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>>(){

            @Override
            @Nullable
            public List<TypeScriptCompletionResponse.CompletionEntryDetail> process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                if (serviceObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$4", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$4", "process"));
                }
                if (!(serviceObject instanceof TypeScriptCompositeRequest)) {
                    return ContainerUtil.emptyList();
                }
                String updateCommandName = updateCommand.getCommand();
                String completionCommandName = completionCommand.getCommand();
                JSLanguageServiceObject updateObject = ((TypeScriptCompositeRequest)serviceObject).getServiceObject(updateCommandName);
                JSLanguageServiceObject completionObject = ((TypeScriptCompositeRequest)serviceObject).getServiceObject(completionCommandName);
                JsonObject element = answer.getElement();
                JsonObject bodyObject = element.getAsJsonObject(TypeScriptServerServiceImpl.BODY_FIELD);
                JsonElement completionAnswerElement = bodyObject.get(completionCommandName);
                JsonElement updateAnswerElement = bodyObject.get(updateCommandName);
                if (updateAnswerElement != null && updateObject != null) {
                    updateProcessor.process(updateObject, new JSLanguageServiceAnswer(updateAnswerElement));
                }
                if (completionObject == null || completionAnswerElement == null) {
                    return ContainerUtil.emptyList();
                }
                return (List)completionProcessor.process(completionObject, new JSLanguageServiceAnswer(completionAnswerElement));
            }
        };
        if (jSLanguageServiceCommandProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createCompletionCompositeProcessor"));
        }
        return jSLanguageServiceCommandProcessor;
    }

    @NotNull
    protected JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> createCompletionProcessor() {
        JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> jSLanguageServiceCommandProcessor = this.myCompletionDefaultProcessor;
        if (jSLanguageServiceCommandProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createCompletionProcessor"));
        }
        return jSLanguageServiceCommandProcessor;
    }

    @NotNull
    protected JSLanguageServiceSimpleCommand createCompletionCommand(@NotNull TypeScriptCompletionsRequestArgs args, @NotNull VirtualFile virtualFile, @NotNull PsiFile file) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createCompletionCommand"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createCompletionCommand"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createCompletionCommand"));
        }
        TypeScriptCompletionsCommand typeScriptCompletionsCommand = new TypeScriptCompletionsCommand(args);
        if (typeScriptCompletionsCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createCompletionCommand"));
        }
        return typeScriptCompletionsCommand;
    }

    @Override
    @Nullable
    public Future<Boolean> update(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "update"));
        }
        return this.updateImpl(context);
    }

    @Override
    @Nullable
    public Future<JSLanguageServiceResultContainer> compileFileAndGetErrors(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "compileFileAndGetErrors"));
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return null;
        }
        String path = file.getCanonicalPath();
        if (path == null || TypeScriptUtil.isDefinitionFile(path) || !TypeScriptLanguageServiceUtil.FILES_TO_PROCESS.value((Object)file)) {
            return null;
        }
        TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
        args.includeErrors = true;
        args.force = true;
        args.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        this.setMacroParamsIfNeed(args, file);
        TypeScriptCompileCommand command = new TypeScriptCompileCommand(args);
        return process.execute(command, this.createCompileResultProcessor());
    }

    @Override
    @Nullable
    public Future<JSLanguageServiceResultContainer> compileConfigProjectAndGetErrors(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "compileConfigProjectAndGetErrors"));
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return null;
        }
        TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
        args.includeErrors = true;
        args.force = true;
        args.projectFileName = TypeScriptCompilerConfigUtil.normalizeNameAndPath(config2.getConfigFile());
        return process.execute(new TypeScriptCompileCommand(args), this.createCompileResultProcessor());
    }

    @Override
    public void closeLastEditor(@NotNull VirtualFile file) {
        VirtualFile mainFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "closeLastEditor"));
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(this.myProject)) {
            return;
        }
        if (!TypeScriptLanguageServiceUtil.isServiceEnabled(this.myProject) || !this.isServiceCreated()) {
            return;
        }
        if (this.mySettings.isUseMainFile() && file.equals(mainFile = TypeScriptLanguageServiceUtil.getMainFile(this.mySettings))) {
            return;
        }
        String normalizeNameAndPath = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        TypeScriptFileObject arguments = new TypeScriptFileObject();
        TypeScriptCloseEditorCommand command = new TypeScriptCloseEditorCommand(arguments, file);
        arguments.file = normalizeNameAndPath;
        this.sendCommand(command, JSLanguageServiceCommandProcessor.SUCCESS);
    }

    @Override
    @NotNull
    public Collection<? extends IntentionAction> getFixes(@NotNull PsiFile file, @NotNull JSAnnotationError result) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "getFixes"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "getFixes"));
        }
        if (!(result instanceof TypeScriptLanguageServiceAnnotationResult)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "getFixes"));
            }
            return list;
        }
        int code = ((TypeScriptLanguageServiceAnnotationResult)result).getErrorCode();
        if (code == -1) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "getFixes"));
            }
            return list;
        }
        int[] codes = this.myErrorCodeFixes;
        if (codes.length > 0 && Arrays.stream(codes).anyMatch(el -> el == code)) {
            TypeScriptLanguageServiceFixSet set = new TypeScriptLanguageServiceFixSet(this, file.getVirtualFile(), (TypeScriptLanguageServiceAnnotationResult)result);
            List<TypeScriptLanguageServiceFix> list = set.getFixes();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "getFixes"));
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "getFixes"));
        }
        return list;
    }

    @Override
    public void openEditor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "openEditor"));
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(this.myProject)) {
            return;
        }
        if (!TypeScriptLanguageServiceUtil.isServiceEnabled(this.myProject) || !this.isServiceCreated()) {
            return;
        }
        TypeScriptOpenEditorCommand command = TypeScriptServerServiceImpl.createOpenEditorCommand(file);
        this.sendCommand(command, JSLanguageServiceCommandProcessor.SUCCESS);
    }

    @Override
    public boolean checkCanUseService() {
        return this.getCanStartProcessState() != ThreeState.NO && (this.mySettings.isCompilerEnabled() || this.myFailCount.get() < (long)this.getAliveCheckCount());
    }

    @Override
    public JSLanguageServiceQueue getLSProcess() {
        return super.getLSProcess();
    }

    @Override
    @Nullable
    public Future<List<JSAnnotationError>> highlight(@NotNull PsiFile file, @NotNull JSFileHighlightingInfo info) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "highlight"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "highlight"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<VirtualFile> configs = TypeScriptServerServiceImpl.getChangedConfigs();
        if (configs != null && !configs.isEmpty()) {
            this.saveChangedConfigsAndRestartHighlighting(file, configs);
            return null;
        }
        return this.updateFilesAndGetErrors(info);
    }

    @Override
    public boolean canHighlight(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "canHighlight"));
        }
        TypeScriptAnnotatorCheckerProvider provider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)file);
        return provider instanceof TypeScriptLanguageServiceAnnotatorCheckerProvider;
    }

    @Override
    @NotNull
    public Condition<VirtualFile> getAcceptableFilesFilter() {
        Condition<VirtualFile> condition = TypeScriptLanguageServiceUtil.FILES_TO_PROCESS;
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "getAcceptableFilesFilter"));
        }
        return condition;
    }

    @Override
    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String interpreter = TypeScriptLanguageServiceUtil.getNodeInterpreterPath(this.myProject);
        boolean hasInterpreter = !StringUtil.isEmptyOrSpaces((String)interpreter);
        ThreeState prevValue = this.getCanStartProcessState();
        this.setCanStartProcessState(ThreeState.fromBoolean((boolean)hasInterpreter));
        if (!hasInterpreter) {
            this.showInterpreterError(prevValue);
            return null;
        }
        Ref serviceRef = Ref.create();
        Condition expiredConditionForReadyConsumer = el -> {
            JSLanguageServiceQueue service = (JSLanguageServiceQueue)serviceRef.get();
            if (service == null) {
                return false;
            }
            return !service.isValid();
        };
        Consumer<JsonObject> readyConsumer = this.createReadyConsumer((Condition<Object>)expiredConditionForReadyConsumer);
        JSLanguageServiceProtocol protocol = this.createProtocol(readyConsumer);
        if (protocol == null) {
            return null;
        }
        boolean setActive = this.myFailCount.get() == 0L;
        JSLanguageServiceQueue.ServiceInfoReporter errorReporter = this.myToolWindowManager != null ? new JSLanguageServiceToolWindowInfoReporter(this.myProject, this.getProcessName(), this.myToolWindowManager, setActive) : this.myDefaultReporter;
        JSLanguageServiceQueueImpl service = new JSLanguageServiceQueueImpl(this.myProject, protocol, this.myProcessConnector, errorReporter, new TypeScriptLanguageServiceCacheImpl());
        serviceRef.set((Object)service);
        Consumer<JSLanguageServiceQueue> initializer = this.getInitializedCallback();
        initializer.consume((Object)service);
        return service;
    }

    @NotNull
    private Consumer<JsonObject> createReadyConsumer(Condition<Object> expiredCondition) {
        Consumer consumer = el -> {
            try {
                JsonElement codes;
                JsonObject message = el.getAsJsonObject("message");
                if (message == null) {
                    JSLanguageServiceQueue.LOGGER.error("No ready message");
                    return;
                }
                JsonPrimitive version = message.getAsJsonPrimitive("version");
                String versionAsString = TypeScriptLanguageServiceUtil.getNormalizedVersionString(version.getAsString());
                if (this.myToolWindowManager != null) {
                    ApplicationManager.getApplication().invokeLater(() -> this.myToolWindowManager.setName(versionAsString), expiredCondition);
                }
                if ((codes = message.get("supportedErrorCodes")) != null && codes.isJsonArray()) {
                    JsonArray array = codes.getAsJsonArray();
                    int[] result = new int[array.size()];
                    int i = 0;
                    for (JsonElement element : array) {
                        if (element.isJsonPrimitive()) {
                            JsonPrimitive primitive = element.getAsJsonPrimitive();
                            try {
                                if (primitive.isNumber()) {
                                    result[i++] = primitive.getAsInt();
                                    continue;
                                }
                                if (!primitive.isString()) continue;
                                result[i++] = Integer.valueOf(primitive.getAsString());
                            }
                            catch (Exception e) {
                                result[i++] = -1;
                            }
                            continue;
                        }
                        result[i++] = -1;
                    }
                    this.myErrorCodeFixes = result;
                }
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        };
        if (consumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createReadyConsumer"));
        }
        return consumer;
    }

    @Nullable
    protected JSLanguageServiceProtocol createProtocol(Consumer<?> readyConsumer) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return new TypeScriptServiceStandardOutputProtocol(this.myProject, this.mySettings, readyConsumer);
    }

    @Override
    @Nullable
    protected JSLanguageServiceToolWindowManager createToolWindow(Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        return TypeScriptToolWindowProvider.getToolWindow(project);
    }

    @Override
    protected boolean needInitToolWindow() {
        return this.isEnabled();
    }

    @NotNull
    protected Consumer<JSLanguageServiceQueue> getInitializedCallback() {
        Consumer consumer = service -> ReadAction.run(() -> this.sendInitialState((JSLanguageServiceQueue)service));
        if (consumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "getInitializedCallback"));
        }
        return consumer;
    }

    protected void sendInitialState(final @NotNull JSLanguageServiceQueue service) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "sendInitialState"));
        }
        ArrayList toProcess = ContainerUtil.newArrayList();
        VirtualFile mainFile = TypeScriptLanguageServiceUtil.getMainFile(this.mySettings);
        if (mainFile != null) {
            toProcess.add(mainFile);
        }
        toProcess.addAll(JSHighlightingInfoBuilder.getFilteredOpenedFiles(this.myProject, this.getAcceptableFilesFilter()).keySet());
        for (final VirtualFile vFile : toProcess) {
            service.execute(TypeScriptServerServiceImpl.createOpenEditorCommand(vFile), new JSLanguageServiceCommandProcessor<Object>(){

                @Override
                public Object process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                    if (serviceObject == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$5", "process"));
                    }
                    if (answer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$5", "process"));
                    }
                    service.resetCaches();
                    ReadAction.run(() -> {
                        PsiFile file;
                        if (service == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$5", "lambda$process$0"));
                        }
                        if (!service.isValid()) {
                            return;
                        }
                        if (vFile.isValid() && !TypeScriptServerServiceImpl.this.myProject.isDisposed() && (file = PsiManager.getInstance((Project)TypeScriptServerServiceImpl.this.myProject).findFile(vFile)) != null) {
                            DaemonCodeAnalyzer.getInstance((Project)TypeScriptServerServiceImpl.this.myProject).restart(file);
                        }
                    });
                    return null;
                }
            });
        }
    }

    @Nullable
    private static Collection<VirtualFile> getChangedConfigs() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileDocumentManager manager = FileDocumentManager.getInstance();
        List changedConfigs = null;
        for (Document document : manager.getUnsavedDocuments()) {
            VirtualFile docFile = manager.getFile(document);
            if (docFile == null || !TypeScriptCompilerConfigUtil.isConfig(docFile, docFile.getFileType())) continue;
            if (changedConfigs == null) {
                changedConfigs = ContainerUtil.newSmartList();
            }
            changedConfigs.add(docFile);
        }
        return changedConfigs;
    }

    private void saveChangedConfigsAndRestartHighlighting(@NotNull PsiFile file, @NotNull Collection<VirtualFile> configs) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "saveChangedConfigsAndRestartHighlighting"));
        }
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "saveChangedConfigsAndRestartHighlighting"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (configs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "lambda$saveChangedConfigsAndRestartHighlighting$7"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "lambda$saveChangedConfigsAndRestartHighlighting$7"));
            }
            for (VirtualFile config2 : configs) {
                Document document = FileDocumentManager.getInstance().getDocument(config2);
                if (document == null) continue;
                FileDocumentManager.getInstance().saveDocument(document);
            }
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(file);
        }, this.myProject.getDisposed());
    }

    private boolean isEnabled() {
        return !this.myProject.isDefault() && !this.myProject.isDisposed() && (this.mySettings.isCompilerEnabled() || this.mySettings.isUseService());
    }

    @Override
    public void flushCompileQueue() {
        this.myCompileQueue.flush();
    }

    public void flushQueues() {
        this.flushCompileQueue();
        this.myProjectErrorsQueue.flush();
    }

    @NotNull
    private static TypeScriptOpenEditorCommand createOpenEditorCommand(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createOpenEditorCommand"));
        }
        TypeScriptFileWithConfigArgs arguments = new TypeScriptFileWithConfigArgs();
        arguments.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        TypeScriptOpenEditorCommand typeScriptOpenEditorCommand = new TypeScriptOpenEditorCommand(arguments, file);
        if (typeScriptOpenEditorCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createOpenEditorCommand"));
        }
        return typeScriptOpenEditorCommand;
    }

    @NotNull
    private JSLanguageServiceCommandProcessor<JSLanguageServiceResultContainer> createCompileResultProcessor() {
        JSLanguageServiceCommandProcessor<JSLanguageServiceResultContainer> jSLanguageServiceCommandProcessor = new JSLanguageServiceCommandProcessor<JSLanguageServiceResultContainer>(){

            @Override
            public JSLanguageServiceResultContainer process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                List<String> emittedFiles;
                if (serviceObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$6", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$6", "process"));
                }
                JsonObject element = answer.getElement();
                JsonElement body = element.get(TypeScriptServerServiceImpl.BODY_FIELD);
                if (body == null || !body.isJsonObject()) {
                    return null;
                }
                JsonObject bodyObject = body.getAsJsonObject();
                List<String> list = emittedFiles = bodyObject.has(TypeScriptServerServiceImpl.GENERATED_FILES_FIELD) ? TypeScriptCompilerConfigUtil.jsonArrayToStringArray((JsonElement)bodyObject.getAsJsonArray(TypeScriptServerServiceImpl.GENERATED_FILES_FIELD)) : ContainerUtil.emptyList();
                if (!emittedFiles.isEmpty()) {
                    TypeScriptCompilerConfigUtil.refreshFiles(TypeScriptServerServiceImpl.this.myProject, emittedFiles);
                }
                List<String> processedFiles = bodyObject.has(TypeScriptServerServiceImpl.PROCESSED_FILES_FIELD) ? TypeScriptCompilerConfigUtil.jsonArrayToStringArray((JsonElement)bodyObject.getAsJsonArray(TypeScriptServerServiceImpl.PROCESSED_FILES_FIELD)) : ContainerUtil.emptyList();
                List annotationResults = TypeScriptServerServiceImpl.parseAnnotationResult((JsonElement)bodyObject);
                List results = annotationResults == null ? ContainerUtil.emptyList() : annotationResults;
                return new JSLanguageServiceResultContainer(results, processedFiles, emittedFiles);
            }
        };
        if (jSLanguageServiceCommandProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createCompileResultProcessor"));
        }
        return jSLanguageServiceCommandProcessor;
    }

    @Nullable
    private Future<List<JSAnnotationError>> updateFilesAndGetErrors(@NotNull JSFileHighlightingInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateFilesAndGetErrors"));
        }
        final JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return null;
        }
        this.updateImpl(info.updateContext);
        final VirtualFile file = info.file;
        String path = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        if (path == null) {
            return null;
        }
        TypeScriptGetErrCommand getError = this.createGetErrCommand(file, path);
        Future<List<JSAnnotationError>> result = process.executeWithCache(getError, new JSLanguageServiceCacheableCommandProcessor<List<JSAnnotationError>>(){

            @Override
            public List<JSAnnotationError> process(@NotNull JSLanguageServiceCacheableCommand command, @NotNull JSLanguageServiceObject object, @NotNull JSLanguageServiceAnswer answer) {
                List results;
                if (command == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$7", "process"));
                }
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$7", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$7", "process"));
                }
                JsonObject element = answer.getElement();
                JsonElement bodyProperty = element.get(TypeScriptServerServiceImpl.BODY_FIELD);
                List list = results = bodyProperty == null ? ContainerUtil.emptyList() : TypeScriptServerServiceImpl.parseAnnotationResult(bodyProperty);
                if (!TypeScriptServerServiceImpl.this.mySettings.isShowAllProjectErrors() && TypeScriptServerServiceImpl.checkState(process)) {
                    TypeScriptServerServiceImpl.this.updateErrorsForCurrentSelectedEditor(file, results);
                }
                return results;
            }

            @Override
            @NotNull
            public List<JSAnnotationError> processFromCache(@NotNull JSLanguageServiceCacheableCommand command, @NotNull List<JSAnnotationError> result) {
                if (command == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$7", "processFromCache"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$7", "processFromCache"));
                }
                List<JSAnnotationError> list = result;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$7", "processFromCache"));
                }
                return list;
            }
        });
        if (this.mySettings.isShowAllProjectErrors() && !TypeScriptLanguageServiceUtil.shouldUseMainFile(this.mySettings)) {
            this.queueProjectErrorsTask(this.createProjectCommand(file, path), file);
        }
        return result;
    }

    @NotNull
    protected JSLanguageServiceCommand createProjectCommand(@NotNull VirtualFile file, @NotNull String path) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createProjectCommand"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createProjectCommand"));
        }
        TypeScriptGetProjectErrCommand typeScriptGetProjectErrCommand = new TypeScriptGetProjectErrCommand(path);
        if (typeScriptGetProjectErrCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createProjectCommand"));
        }
        return typeScriptGetProjectErrCommand;
    }

    @Nullable
    private Future<Boolean> updateImpl(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateImpl"));
        }
        TypeScriptLanguageServiceUpdateCommand command = this.getUpdateFilesCommand(context);
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return null;
        }
        JSLanguageServiceCommandProcessor<Boolean> processor = this.createUpdateProcessor();
        return process.execute(command, processor);
    }

    @NotNull
    protected JSLanguageServiceCommandProcessor<Boolean> createUpdateProcessor() {
        JSLanguageServiceCommandProcessor<Boolean> jSLanguageServiceCommandProcessor = this.myUpdateDefaultProcessor;
        if (jSLanguageServiceCommandProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createUpdateProcessor"));
        }
        return jSLanguageServiceCommandProcessor;
    }

    @NotNull
    protected TypeScriptLanguageServiceUpdateCommand getUpdateFilesCommand(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "getUpdateFilesCommand"));
        }
        HashMap timestamps = ContainerUtil.newHashMap();
        context.getTimestamps().forEach((el, value) -> timestamps.put(JSLanguageServiceUtil.normalizeNameAndPath(el), value));
        HashMap contents = ContainerUtil.newHashMap();
        context.getOpenContents().forEach((el, value) -> contents.put(JSLanguageServiceUtil.normalizeNameAndPath(el), value));
        context.getUnsavedContents().forEach((el, value) -> contents.put(JSLanguageServiceUtil.normalizeNameAndPath(el), value));
        TypeScriptLanguageServiceUpdateCommand typeScriptLanguageServiceUpdateCommand = new TypeScriptLanguageServiceUpdateCommand(timestamps, contents);
        if (typeScriptLanguageServiceUpdateCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "getUpdateFilesCommand"));
        }
        return typeScriptLanguageServiceUpdateCommand;
    }

    @NotNull
    private GlobalSearchScope getScope() {
        GlobalSearchScope globalSearchScope = ScopeChooserUtils.findScopeByName((Project)this.myProject, (String)this.mySettings.getScopeName());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "getScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    protected TypeScriptGetErrCommand createGetErrCommand(@NotNull VirtualFile file, @NotNull String path) {
        String mainPath;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createGetErrCommand"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createGetErrCommand"));
        }
        if (TypeScriptLanguageServiceUtil.shouldUseMainFile(this.mySettings) && !StringUtil.isEmpty((String)(mainPath = this.mySettings.getMainFilePath()))) {
            TypeScriptGetMainFileErrCommand typeScriptGetMainFileErrCommand = new TypeScriptGetMainFileErrCommand(path);
            if (typeScriptGetMainFileErrCommand == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createGetErrCommand"));
            }
            return typeScriptGetMainFileErrCommand;
        }
        TypeScriptGetErrCommand typeScriptGetErrCommand = new TypeScriptGetErrCommand(path);
        if (typeScriptGetErrCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "createGetErrCommand"));
        }
        return typeScriptGetErrCommand;
    }

    @Nullable
    private static List<JSAnnotationError> parseAnnotationResult(@NotNull JsonElement bodyProperty) {
        if (bodyProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyProperty", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "parseAnnotationResult"));
        }
        TypeScriptDiagnosticsResponse result = (TypeScriptDiagnosticsResponse)JSLanguageServiceQueueImpl.GSON.fromJson(bodyProperty, TypeScriptDiagnosticsResponse.class);
        LinkedHashSet results = ContainerUtil.newLinkedHashSet();
        if (result == null || result.infos == null || result.infos.length == 0) {
            return ContainerUtil.emptyList();
        }
        for (TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo body : result.infos) {
            String file = body.file;
            for (TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics diagnostic : body.diagnostics) {
                String category = diagnostic.category;
                if (StringUtil.isEmpty((String)category)) {
                    category = "error";
                }
                TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo start = diagnostic.start;
                TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo end = diagnostic.end;
                results.add(new TypeScriptLanguageServiceAnnotationResult(StringUtil.notNullize((String)diagnostic.text, (String)"error"), file, category, start == null ? 0 : start.line, start == null ? 0 : start.offset, end == null ? 0 : end.line, end == null ? 0 : end.offset));
            }
        }
        return ContainerUtil.immutableList((List)ContainerUtil.newArrayList((Iterable)results));
    }

    private void addFileToCompileQueue(@NotNull Collection<String> fileNames) {
        if (fileNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNames", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "addFileToCompileQueue"));
        }
        if (!fileNames.isEmpty()) {
            if (!TypeScriptLanguageServiceUtil.shouldUseMainFile(this.mySettings)) {
                fileNames.stream().filter(el -> !TypeScriptUtil.isDefinitionFile(el)).map(el -> {
                    TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
                    args.file = el;
                    return args;
                }).forEach(this::queueCompileTask);
            } else {
                String path = this.mySettings.getMainFilePath();
                if (!StringUtil.isEmpty((String)path)) {
                    TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
                    args.file = FileUtil.toSystemDependentName((String)path);
                    args.force = true;
                    this.queueCompileTask(args);
                }
            }
        }
    }

    private boolean isCompileEnabled() {
        return this.mySettings.isCompilerEnabledAndNeedTrackChanges();
    }

    private void queueProjectErrorsTask(final @NotNull JSLanguageServiceCommand args, final @NotNull VirtualFile file) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "queueProjectErrorsTask"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "queueProjectErrorsTask"));
        }
        this.myProjectErrorsQueue.queue(new Update(args){

            public void run() {
                TypeScriptServerServiceImpl.this.updateProjectErrors(args, file);
            }
        });
    }

    private void queueCompileTask(final @NotNull TypeScriptCompileFileArgs args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "queueCompileTask"));
        }
        final VirtualFile path = LocalFileSystem.getInstance().findFileByPath(args.file);
        if (!(path != null && this.getScope().contains(path) && TypeScriptLanguageServiceUtil.FILES_TO_PROCESS.value((Object)path) && path.isValid())) {
            return;
        }
        this.setMacroParamsIfNeed(args, path);
        this.myCompileQueue.queue(new Update(args){

            public void run() {
                if (!path.isValid()) {
                    return;
                }
                TypeScriptServerServiceImpl.this.sendCompileCommand(args);
            }
        });
    }

    private void setMacroParamsIfNeed(@NotNull TypeScriptCompileFileArgs args, @NotNull VirtualFile path) {
        String outDir;
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "setMacroParamsIfNeed"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "setMacroParamsIfNeed"));
        }
        if (!this.mySettings.isUseConfigForCompiler() && this.mySettings.isHasOutDirectory() && !StringUtil.isEmpty((String)(outDir = this.mySettings.getOutDirectory())) && outDir.contains("$")) {
            Pair<String, String> info = JSHighlightingInfoBuilder.getModuleInfo(this.myProject, path);
            args.contentRootForMacro = (String)info.first;
            args.sourceRootForMacro = (String)info.second;
        }
    }

    private void updateProjectErrors(@NotNull JSLanguageServiceCommand command, @NotNull VirtualFile file) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateProjectErrors"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateProjectErrors"));
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (!TypeScriptServerServiceImpl.checkState(process)) {
            return;
        }
        process.executeNoBlocking(command, (Consumer<JSLanguageServiceAnswer>)((Consumer)answer -> {
            List<JSAnnotationError> results;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "lambda$updateProjectErrors$13"));
            }
            JsonObject element = answer.getElement();
            JsonElement bodyProperty = element.get(BODY_FIELD);
            List<JSAnnotationError> list = results = bodyProperty == null ? null : TypeScriptServerServiceImpl.parseAnnotationResult(bodyProperty);
            if (TypeScriptServerServiceImpl.checkState(process)) {
                this.updateErrorsForCurrentSelectedEditor(file, results);
            }
        }));
    }

    private void updateErrorsForCurrentSelectedEditor(@NotNull VirtualFile file, @Nullable List<JSAnnotationError> results) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "updateErrorsForCurrentSelectedEditor"));
        }
        Runnable runnable = () -> {
            VirtualFile editorFile;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "lambda$updateErrorsForCurrentSelectedEditor$14"));
            }
            if (!this.myProject.isOpen() || this.myProject.isDisposed() || !this.isServiceCreated()) {
                return;
            }
            Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
            if (editor instanceof EditorEx && file.equals(editorFile = ((EditorEx)editor).getVirtualFile())) {
                this.getDefaultReporter().logCurrentErrors(results == null ? ContainerUtil.emptyList() : results);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ReadAction.run(() -> runnable.run());
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, this.myProject.getDisposed());
        }
    }

    protected static boolean checkState(@Nullable JSLanguageServiceQueue process) {
        if (process == null) {
            return false;
        }
        return process.isValid();
    }

    private void showInterpreterError(@NotNull ThreeState prevValue) {
        if (prevValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevValue", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "showInterpreterError"));
        }
        if (prevValue != this.getCanStartProcessState()) {
            Runnable runnable = () -> ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myToolWindowManager != null) {
                    this.myToolWindowManager.logCurrentErrors((List<JSAnnotationError>)JSLanguageServiceAnnotationResult.buildError(JSBundle.message((String)"javascript.service.node.error", (Object[])new Object[0])), this.mySettings.isCompilerEnabled());
                }
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            }, this.myProject.getDisposed());
            if (this.myProject.isOpen()) {
                StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(runnable);
            }
        }
    }

    @Override
    @NotNull
    protected String getProcessName() {
        if ("TypeScript" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "getProcessName"));
        }
        return "TypeScript";
    }

    @Override
    protected void resetState() {
        this.myProjectErrorsQueue.cancelAllUpdates();
        this.myCompileQueue.cancelAllUpdates();
        super.resetState();
    }

    private void sendCompileCommand(@NotNull TypeScriptCompileFileArgs args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl", "sendCompileCommand"));
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (!TypeScriptServerServiceImpl.checkState(process)) {
            return;
        }
        TypeScriptCompileCommand command = new TypeScriptCompileCommand(args);
        Consumer consumer = answer -> {
            JsonObject element = answer.getElement();
            JsonElement jsonElement = element.get(BODY_FIELD);
            if (jsonElement == null || !jsonElement.isJsonObject()) {
                return;
            }
            TypeScriptCompilerConfigUtil.processEmitFilesAfterCompiling(this.myProject, jsonElement.getAsJsonObject(), GENERATED_FILES_FIELD);
        };
        process.executeNoBlocking(command, (Consumer<JSLanguageServiceAnswer>)consumer);
    }

    private static class TypeScriptCompileUpdater {
        private TypeScriptCompileUpdater() {
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }
    }
}

