/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.typescript.compiler.ui.TypeScriptLanguageServicePanel;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceDialog
extends DialogWrapper {
    private final JBCheckBox myCodeCompletion;
    private final JBCheckBox myAnnotation;
    private final JPanel myPanel;
    private final Map<TypeScriptServerServiceSettings, JBCheckBox> myServiceCheckboxes;

    protected TypeScriptLanguageServiceDialog(@Nullable Project project, TypeScriptLanguageServicePanel settings, @NotNull List<TypeScriptServerServiceSettings> additionalSettings) {
        if (additionalSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalSettings", "com/intellij/lang/typescript/compiler/ui/TypeScriptLanguageServiceDialog", "<init>"));
        }
        super(project);
        this.myCodeCompletion = new JBCheckBox(JSBundle.message((String)"typescript.compiler.configurable.service.use.completion", (Object[])new Object[0]));
        this.myAnnotation = new JBCheckBox(JSBundle.message((String)"typescript.compiler.configurable.service.use.annotation", (Object[])new Object[0]));
        this.setTitle(JSBundle.message((String)"typescript.compiler.configurable.service.title", (Object[])new Object[0]));
        FormBuilder builder = FormBuilder.createFormBuilder();
        builder.addComponent((JComponent)this.myCodeCompletion);
        this.myCodeCompletion.setSelected(settings.isUseServiceCompletion());
        this.myAnnotation.setSelected(settings.isUseServiceAnnotation());
        Map<TypeScriptServerServiceSettings, Boolean> additionalValues = settings.getAdditionalSettingsValues();
        this.myServiceCheckboxes = ContainerUtil.newLinkedHashMap();
        for (TypeScriptServerServiceSettings additionalSetting : additionalSettings) {
            JBCheckBox checkBox = new JBCheckBox(additionalSetting.getTitle());
            checkBox.setSelected(additionalSetting.isUseService());
            this.myServiceCheckboxes.put(additionalSetting, checkBox);
            if (additionalValues.containsKey(additionalSetting)) {
                checkBox.setSelected(additionalValues.get(additionalSetting).booleanValue());
            }
            builder.addComponent((JComponent)checkBox);
        }
        this.myPanel = builder.getPanel();
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public boolean isUseAnnotation() {
        return this.myAnnotation.isSelected();
    }

    public boolean isUseCodeCompletion() {
        return this.myCodeCompletion.isSelected();
    }

    @Nullable
    protected String getHelpId() {
        return "settings.typescript.service.options";
    }

    public Map<TypeScriptServerServiceSettings, Boolean> getAdditionalSettingsValues() {
        LinkedHashMap result = ContainerUtil.newLinkedHashMap();
        for (Map.Entry<TypeScriptServerServiceSettings, JBCheckBox> entry : this.myServiceCheckboxes.entrySet()) {
            result.put(entry.getKey(), entry.getValue().isSelected());
        }
        return result;
    }
}

