/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.psi.impl.TypeScriptModuleTextReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptPathMappingCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        boolean isTypeScriptModule;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/typescript/completion/TypeScriptPathMappingCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/completion/TypeScriptPathMappingCompletionContributor", "fillCompletionVariants"));
        }
        PsiReference refStart = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset());
        boolean bl = isTypeScriptModule = refStart instanceof PsiMultiReference ? TypeScriptPathMappingCompletionContributor.isTypeScriptModuleReferences(((PsiMultiReference)refStart).getReferences()) : TypeScriptPathMappingCompletionContributor.isTypeScriptModuleReference(refStart);
        if (isTypeScriptModule) {
            TypeScriptPathMappingCompletionContributor.addAdditionalPathMappings(parameters, result);
        }
    }

    private static boolean isTypeScriptModuleReferences(@NotNull PsiReference[] refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/lang/typescript/completion/TypeScriptPathMappingCompletionContributor", "isTypeScriptModuleReferences"));
        }
        for (PsiReference ref : refs) {
            if (!TypeScriptPathMappingCompletionContributor.isTypeScriptModuleReference(ref)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTypeScriptModuleReference(@Nullable PsiReference ref) {
        if (ref == null) {
            return false;
        }
        PsiElement element = ref.getElement();
        return (element instanceof ES6FromClause || element.getParent() instanceof TypeScriptImportStatement) && (ref instanceof JSFileReference || ref instanceof TypeScriptNodeReference && !ref.getCanonicalText().contains("/") || ref instanceof TypeScriptModuleTextReference);
    }

    private static void addAdditionalPathMappings(CompletionParameters parameters, @NotNull CompletionResultSet result) {
        TypeScriptConfig config2;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/completion/TypeScriptPathMappingCompletionContributor", "addAdditionalPathMappings"));
        }
        PsiElement position = parameters.getPosition();
        if (position.getNode().getElementType() != JSTokenTypes.STRING_LITERAL) {
            return;
        }
        String text = position.getText();
        String literalValue = StringUtil.unquoteString((String)text);
        if (literalValue.contains("\\") || literalValue.contains("/")) {
            return;
        }
        VirtualFile file = position.getContainingFile().getOriginalFile().getVirtualFile();
        if (file != null && (config2 = TypeScriptConfigUtil.getConfigForFile(position.getProject(), file)) != null) {
            for (JSModulePathSubstitution substitution : config2.getPaths()) {
                String pattern = substitution.getPattern();
                boolean hasStar = pattern.contains("*");
                if (hasStar && !JSPathMappingsUtil.isPatternOrMappingEndsWithStar(pattern)) continue;
                String variant = hasStar ? pattern.substring(0, pattern.length() - 1) : pattern;
                LookupElementBuilder newBuilder = LookupElementBuilder.create((String)variant);
                result.addElement((LookupElement)newBuilder.withIcon(AllIcons.Nodes.Folder));
            }
        }
    }
}

