/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.hint;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.javascript.JSParameterInfoHandler;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceEvents;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceResponseParser;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptSignatureHelpResponse;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptParameterInfoHandler
extends JSParameterInfoHandler {
    @Override
    @Nullable
    protected Stream<JSFunctionWithSubstitutor> fillSignaturesForArgumentList(CreateParameterInfoContext context, @NotNull JSArgumentList argList) {
        VirtualFile virtualFile;
        if (argList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argList", "com/intellij/lang/typescript/hint/TypeScriptParameterInfoHandler", "fillSignaturesForArgumentList"));
        }
        Stream<JSFunctionWithSubstitutor> result = super.fillSignaturesForArgumentList(context, argList);
        if (result != null) {
            return result;
        }
        PsiFile file = context.getFile();
        Project project = context.getProject();
        if (!TypeScriptLanguageServiceUtil.useServiceParameterInfo(project, virtualFile = file.getVirtualFile())) {
            return null;
        }
        Future<TypeScriptSignatureHelpResponse> future = TypeScriptLanguageServiceEvents.getService(project).getSignatureHelp(virtualFile, context.getEditor(), context.getOffset());
        TypeScriptSignatureHelpResponse response = JSLanguageServiceUtil.awaitFuture(future, JSLanguageServiceUtil.TIMEOUT_MILLS, 10L, null);
        if (response == null) {
            return null;
        }
        List<JSFunctionItem> items = TypeScriptLanguageServiceResponseParser.parseFunctions(response);
        return items.stream().map(el -> new JSFunctionWithSubstitutor((JSFunctionItem)el, null));
    }

    @Override
    protected boolean skipTypeScript() {
        return false;
    }
}

