/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.ES6QualifiedNamedElementRenderer;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.intentions.TypeScriptImportAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAddImportStatementFix
extends LocalQuickFixOnPsiElement
implements HintAction,
HighPriorityAction {
    @Nullable
    private final String myName;
    private final ES6ImportAction.ImportElementFilter myFilter;
    protected volatile boolean myNeedHint;

    public TypeScriptAddImportStatementFix(@Nullable String name, @NotNull PsiElement context, boolean needHint, @NotNull ES6ImportAction.ImportElementFilter filter) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "<init>"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "<init>"));
        }
        super(context);
        this.myName = name;
        this.myNeedHint = needHint;
        this.myFilter = filter;
    }

    public TypeScriptAddImportStatementFix(@Nullable String name, @NotNull PsiElement context, boolean needHint) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "<init>"));
        }
        this(name, context, needHint, new ES6ImportAction.DefaultElementFilter());
    }

    public TypeScriptAddImportStatementFix(@Nullable String name, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "<init>"));
        }
        this(name, context, true);
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = TypeScriptAddImportStatementFix.getActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getFamilyName"));
        }
        return string;
    }

    private void disableHint() {
        this.myNeedHint = false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "isAvailable"));
        }
        List<JSElement> candidates = this.getCandidates(editor);
        return !candidates.isEmpty();
    }

    @NotNull
    protected ES6ImportAction.ImportElementFilter getFilter() {
        ES6ImportAction.ImportElementFilter importElementFilter = this.myFilter;
        if (importElementFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getFilter"));
        }
        return importElementFilter;
    }

    @Nullable
    private String getImportedName() {
        return this.myName;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        this.createAction(editor).execute();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        ES6ImportAction action = this.createAction(null);
        List<JSElement> candidates = action.getCandidates();
        if (candidates.size() == 1) {
            action.execute();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "showHint"));
        }
        if (!JSApplicationSettings.getInstance().isShowTypeScriptAutoImport() || !this.myNeedHint) {
            return false;
        }
        PsiElement element = this.getStartElement();
        if (element == null || Boolean.TRUE.equals(element.getUserData(ES6ImportAction.NO_HINT_KEY))) {
            return false;
        }
        List<JSElement> candidates = this.getCandidates(editor);
        if (candidates.isEmpty()) {
            return true;
        }
        JSElement first = (JSElement)ContainerUtil.getFirstItem(candidates);
        assert (first != null);
        String message = TypeScriptAddImportStatementFix.getMessage(candidates, first);
        TextRange range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange());
        ES6ImportAction action = this.createAction(editor);
        HintManager.getInstance().showQuestionHint(editor, message, range.getStartOffset(), range.getEndOffset(), (QuestionAction)action);
        return true;
    }

    private static String getMessage(Collection<JSElement> candidates, JSElement first) {
        String nameToShow = new ES6QualifiedNamedElementRenderer<JSElement>().getElementText(first) + " " + JSQualifiedNamedElementRenderer.getContainerText(first);
        return ShowAutoImportPass.getMessage((candidates.size() > 1 ? 1 : 0) != 0, (String)nameToShow);
    }

    private List<JSElement> getCandidates(@Nullable Editor editor) {
        return this.createAction(editor).getCandidates();
    }

    @NotNull
    public ES6ImportAction createAction(@Nullable Editor editor) {
        TypeScriptImportAction typeScriptImportAction = new TypeScriptImportAction(editor, this.getStartElement(), this.getImportedName(), this.getFilter()){

            @Override
            public void executeFor(@NotNull JSElement candidate, @Nullable Consumer<JSElement> postProcess) {
                if (candidate == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$1", "executeFor"));
                }
                super.executeFor(candidate, postProcess);
                TypeScriptAddImportStatementFix.this.disableHint();
            }
        };
        if (typeScriptImportAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "createAction"));
        }
        return typeScriptImportAction;
    }

    public static String getActionName() {
        return JSBundle.message((String)"ts.add.import.statement.family.name", (Object[])new Object[0]);
    }
}

