/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeScriptLibraries {
    private static final String EXTERNAL_DIR = "external";
    @NotNull
    private final Set<VirtualFile> myAllLibsIncludeInvalid;
    @NotNull
    private final Set<VirtualFile> myAllLibs;
    @NotNull
    private final Set<VirtualFile> myES6Libs;
    @NotNull
    private final Set<VirtualFile> myDefaultLibs;
    private final long myModificationId;

    public TypeScriptLibraries() {
        VirtualFile defaultLib = TypeScriptLibraries.getTypeScriptPredefinedLibFile("lib.d.ts");
        VirtualFile es6Lib = TypeScriptLibraries.getTypeScriptPredefinedLibFile("lib.es6.d.ts");
        HashSet libsIncludeInvalid = ContainerUtil.newHashSet();
        if (defaultLib != null) {
            libsIncludeInvalid.add(defaultLib);
        }
        if (es6Lib != null) {
            libsIncludeInvalid.add(es6Lib);
        }
        libsIncludeInvalid.addAll(TypeScriptLibraries.createExtendedLibs());
        this.myDefaultLibs = TypeScriptLibraries.createLibSetIfValid(defaultLib);
        this.myES6Libs = TypeScriptLibraries.createLibSetIfValid(es6Lib);
        this.myAllLibsIncludeInvalid = Collections.unmodifiableSet(libsIncludeInvalid);
        this.myAllLibs = Collections.unmodifiableSet(libsIncludeInvalid.stream().filter(TypeScriptLibraries::isValid).collect(Collectors.toSet()));
        this.myModificationId = this.myAllLibs.stream().mapToLong(el -> el.getModificationStamp()).reduce((el, res) -> el + 23L * res).orElse(0L);
    }

    @NotNull
    public Set<VirtualFile> getES6Libs() {
        Set<VirtualFile> set = this.myES6Libs;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraries", "getES6Libs"));
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getDefaultLibs() {
        Set<VirtualFile> set = this.myDefaultLibs;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraries", "getDefaultLibs"));
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getAllLibs() {
        Set<VirtualFile> set = this.myAllLibs;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraries", "getAllLibs"));
        }
        return set;
    }

    private static boolean isValid(@Nullable VirtualFile file) {
        return file != null && file.isValid();
    }

    @NotNull
    private static Set<VirtualFile> createLibSetIfValid(@Nullable VirtualFile file) {
        Set set = TypeScriptLibraries.isValid(file) ? ContainerUtil.immutableSet((Object[])new VirtualFile[]{file}) : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraries", "createLibSetIfValid"));
        }
        return set;
    }

    @NotNull
    private static Set<VirtualFile> createExtendedLibs() {
        ArrayList toProcess = ContainerUtil.newArrayList();
        toProcess.addAll(TypeScriptLibraryProvider.LIBS_EXTENDED);
        Set<VirtualFile> set = toProcess.stream().map(name -> TypeScriptLibraries.getTypeScriptPredefinedLibFile(name)).filter(el -> el != null).collect(Collectors.toSet());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraries", "createExtendedLibs"));
        }
        return set;
    }

    @Nullable
    private static VirtualFile getTypeScriptPredefinedLibFile(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/library/TypeScriptLibraries", "getTypeScriptPredefinedLibFile"));
        }
        LocalFileSystem localFileSystem = TypeScriptLibraries.getFileSystem();
        if (localFileSystem == null) {
            return null;
        }
        File ioFile = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), EXTERNAL_DIR + File.separator + name);
        VirtualFile file = JSLibraryUtil.findFileByIoFile(localFileSystem, ioFile);
        return JSLibraryUtil.convertFile(file);
    }

    @Nullable
    private static LocalFileSystem getFileSystem() {
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        if (!(fileSystem instanceof LocalFileSystem)) {
            return null;
        }
        return (LocalFileSystem)fileSystem;
    }

    @NotNull
    public Collection<VirtualFile> getFilesToRefresh() {
        VirtualFile defaultLib = (VirtualFile)ContainerUtil.getFirstItem(this.myDefaultLibs);
        if (defaultLib != null) {
            List<VirtualFile> list = Collections.singletonList(defaultLib.getParent());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraries", "getFilesToRefresh"));
            }
            return list;
        }
        File ioFile = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), EXTERNAL_DIR);
        LocalFileSystem system = TypeScriptLibraries.getFileSystem();
        if (system != null) {
            VirtualFile file = JSLibraryUtil.findFileByIoFile(system, ioFile);
            List<VirtualFile> list = Collections.singletonList(JSLibraryUtil.convertFile(file));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraries", "getFilesToRefresh"));
            }
            return list;
        }
        Set<VirtualFile> set = this.myAllLibsIncludeInvalid;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraries", "getFilesToRefresh"));
        }
        return set;
    }

    public long getModificationId() {
        return this.myModificationId;
    }
}

