/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.typescript.library.TypeScriptLibraries;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLibraryProviderImpl
implements TypeScriptLibraryProvider {
    public static final Logger LOG = Logger.getInstance(TypeScriptLibraryProviderImpl.class);
    public static final String BUNDLED_LIB_VERSION = "2.4.1";
    private static final String LIB_PREFIX = "lib";
    private static final String TS_LIB_VERSION_KEY = "ts.lib.d.ts.version";
    @NotNull
    private final Project myProject;
    private static boolean SKIP_DEFAULT_LIBRARY = false;
    @NotNull
    private volatile TypeScriptLibraries myLibrary;
    private volatile boolean myRefreshed;

    public static void setSkipDefaultLibrary(boolean noLib) {
        SKIP_DEFAULT_LIBRARY = noLib;
    }

    private static void asyncRefresh(@NotNull Runnable completeCallback, @NotNull TypeScriptLibraries library, boolean force) {
        if (completeCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completeCallback", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl", "asyncRefresh"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl", "asyncRefresh"));
        }
        String key = PropertiesComponent.getInstance().getValue(TS_LIB_VERSION_KEY);
        if (!force && BUNDLED_LIB_VERSION.equals(key)) {
            return;
        }
        LOG.info("Start refreshing typescript libraries");
        PropertiesComponent.getInstance().setValue(TS_LIB_VERSION_KEY, BUNDLED_LIB_VERSION);
        List list = VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])VfsUtilCore.toVirtualFileArray(library.getFilesToRefresh()));
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        LocalFileSystem.getInstance().refreshFiles((Iterable)list, !testMode, true, () -> {
            if (completeCallback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completeCallback", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl", "lambda$asyncRefresh$0"));
            }
            LOG.info("End refreshing typescript libraries");
            completeCallback.run();
        });
    }

    public TypeScriptLibraryProviderImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl", "<init>"));
        }
        this.myRefreshed = false;
        this.myProject = project;
        this.myLibrary = new TypeScriptLibraries();
        TypeScriptLibraryProviderImpl.asyncRefresh(() -> this.reloadLibrary(), this.myLibrary, false);
    }

    private void reloadLibrary() {
        if (!this.myRefreshed) {
            TypeScriptLibraries oldLibrary = this.myLibrary;
            this.myLibrary = new TypeScriptLibraries();
            if (this.myLibrary.getModificationId() != oldLibrary.getModificationId() && !ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.info("Refresh roots after updating typescript libraries");
                ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.getInstance(), false, true);
            }
            this.myRefreshed = true;
        }
    }

    @Override
    @NotNull
    public Set<VirtualFile> getAllPredefinedLibraries() {
        Set<VirtualFile> libs = this.myLibrary.getAllLibs();
        Set<VirtualFile> set = this.filterAndRefreshIfRequired(libs);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl", "getAllPredefinedLibraries"));
        }
        return set;
    }

    @Override
    @NotNull
    public String getLibraryVersion() {
        if (BUNDLED_LIB_VERSION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl", "getLibraryVersion"));
        }
        return BUNDLED_LIB_VERSION;
    }

    private Set<VirtualFile> filterAndRefreshIfRequired(Set<VirtualFile> libs) {
        boolean hasInvalidFiles = libs.stream().anyMatch(el -> !el.isValid());
        if (hasInvalidFiles) {
            if (!this.myRefreshed) {
                TypeScriptLibraryProviderImpl.asyncRefresh(() -> this.reloadLibrary(), this.myLibrary, true);
            } else {
                LOG.error("Some of the library files are invalidated after refresh");
            }
        }
        return hasInvalidFiles ? libs.stream().filter(VirtualFile::isValid).collect(Collectors.toSet()) : libs;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getPredefinedLibraries(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl", "getPredefinedLibraries"));
        }
        Set<VirtualFile> set = this.filterAndRefreshIfRequired(this.getPredefinedLibrariesImpl(file));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl", "getPredefinedLibraries"));
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getPredefinedLibrariesImpl(@NotNull VirtualFile file) {
        Collection<TypeScriptConfig> includes;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl", "getPredefinedLibrariesImpl"));
        }
        if (SKIP_DEFAULT_LIBRARY) {
            Set set = ContainerUtil.immutableSet((Object[])new VirtualFile[0]);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl", "getPredefinedLibrariesImpl"));
            }
            return set;
        }
        Collection<TypeScriptConfig> configs = TypeScriptConfigService.Provider.getConfigFiles(this.myProject);
        Collection<TypeScriptConfig> collection = includes = configs.size() <= 1 || TypeScriptUtil.isUnderNodeModules(file, this.myProject) ? configs : TypeScriptConfigService.Provider.getConfigInclude(this.myProject, file);
        if (includes.isEmpty()) {
            Set<VirtualFile> set = this.getLibraries(JSRootConfiguration.getInstance(this.myProject).getLanguageLevel().isES6Compatible(), null);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl", "getPredefinedLibrariesImpl"));
            }
            return set;
        }
        List additionalLibs = null;
        boolean targetES6 = false;
        for (TypeScriptConfig config2 : includes) {
            targetES6 |= config2.getLanguageTarget() == TypeScriptConfig.LanguageTarget.ES6 || config2.hasES6Lib();
            Collection<String> names = config2.getLibNames();
            if (names.isEmpty()) continue;
            if (additionalLibs == null) {
                additionalLibs = ContainerUtil.newSmartList();
            }
            additionalLibs.addAll(names);
        }
        Set<VirtualFile> set = this.getLibraries(targetES6, additionalLibs);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl", "getPredefinedLibrariesImpl"));
        }
        return set;
    }

    @NotNull
    private Set<VirtualFile> getLibraries(boolean isES6, @Nullable List<String> additionalLibs) {
        Set<VirtualFile> defaultLibrary;
        Set<VirtualFile> set = defaultLibrary = isES6 ? this.myLibrary.getES6Libs() : this.myLibrary.getDefaultLibs();
        if (additionalLibs == null || additionalLibs.isEmpty()) {
            Set<VirtualFile> set2 = defaultLibrary;
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl", "getLibraries"));
            }
            return set2;
        }
        HashSet result = ContainerUtil.newHashSet(defaultLibrary);
        for (VirtualFile file : this.myLibrary.getAllLibs()) {
            int endIndex;
            String rawName = file.getName();
            if (TypeScriptLibraryProvider.LIBS_D_TS.contains(rawName)) continue;
            int startIndex = LIB_PREFIX.length() + 1;
            if (startIndex > (endIndex = rawName.length() - ".d.ts".length()) || endIndex > rawName.length()) {
                LOG.error("Name rage error start:" + startIndex + " end: " + endIndex + " name " + rawName);
                continue;
            }
            String name = rawName.substring(startIndex, endIndex);
            if (!additionalLibs.contains(name)) continue;
            result.add(file);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl", "getLibraries"));
        }
        return hashSet;
    }
}

