/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.intentions.TypeScriptAddImportStatementFix;
import com.intellij.lang.typescript.psi.TypeScriptAddImportExecutor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAutoImportUtil {
    public static final TokenSet EXPORT_ASSIGNMENTS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT, TypeScriptElementTypes.EXPORT_ASSIGNMENT});
    public static final String[] NODE_MODULES = new String[]{"node_modules"};

    public static boolean isAvailableForImport(@NotNull PsiElement elementToImport, @NotNull JSImportPlaceInfo placeInfo) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isAvailableForImport"));
        }
        if (placeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isAvailableForImport"));
        }
        if (!ES6PsiUtil.isElementCanBeExported(elementToImport)) {
            return false;
        }
        assert (DialectDetector.isTypeScript(elementToImport));
        if (!TypeScriptAutoImportUtil.isContextAcceptable(elementToImport, placeInfo)) {
            return false;
        }
        return TypeScriptAutoImportUtil.isExportedElement(elementToImport, placeInfo);
    }

    public static boolean isExportedElement(PsiElement elementToImport, JSImportPlaceInfo placeInfo) {
        TypeScriptModule tsModule;
        PsiElement parent = elementToImport.getContext();
        if (parent instanceof JSVarStatement) {
            parent = parent.getContext();
        }
        if (parent instanceof ES6ExportDefaultAssignment) {
            return true;
        }
        if (!TypeScriptPsiUtil.isTopLevelContainer(parent) || parent instanceof JSFile && !((JSFile)parent).isCommonJSModule() || parent.isEquivalentTo(placeInfo.getContainer())) {
            return false;
        }
        if (parent instanceof TypeScriptModule && (tsModule = (TypeScriptModule)parent).isAugmentation() && !TypeScriptAutoImportUtil.isAugmentationAcceptable(tsModule)) {
            return false;
        }
        TypeScriptModuleAccessibilityChecker checker = TypeScriptModuleAccessibilityChecker.INSTANCE;
        if (checker.check(placeInfo.getPlace(), elementToImport) != null) {
            return false;
        }
        return ES6ImportHandler.isExported(elementToImport) || elementToImport instanceof JSElementBase && ((JSElementBase)elementToImport).isExportedWithDefault();
    }

    private static boolean isAugmentationAcceptable(@NotNull TypeScriptModule tsModule) {
        if (tsModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tsModule", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isAugmentationAcceptable"));
        }
        PsiElement parent = tsModule.getParent();
        if (!ES6PsiUtil.isExternalModule(parent)) {
            return false;
        }
        JSExportAssignment assignment = TypeScriptAutoImportUtil.getExportAssignment(parent);
        return assignment instanceof TypeScriptExportAssignment;
    }

    public static boolean isContextAcceptable(@NotNull PsiElement elementToImport, @NotNull JSImportPlaceInfo placeInfo) {
        boolean isClassType;
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isContextAcceptable"));
        }
        if (placeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isContextAcceptable"));
        }
        if (!(placeInfo.getPlace() instanceof JSReferenceExpression)) {
            return true;
        }
        boolean bl = isClassType = elementToImport instanceof JSClass || elementToImport instanceof TypeScriptModule;
        if (elementToImport instanceof TypeScriptModule) {
            if (!((TypeScriptModule)elementToImport).isInternal()) {
                return false;
            }
            PsiElement module = ES6PsiUtil.findExternalModule(elementToImport);
            if (module == null) {
                return false;
            }
        }
        if (placeInfo.isStrictTypeContext() && !isClassType) {
            return false;
        }
        return TypeScriptAutoImportUtil.isElementCanBeUsedInContext(elementToImport, placeInfo, isClassType);
    }

    private static boolean isElementCanBeUsedInContext(@NotNull PsiElement elementToImport, @NotNull JSImportPlaceInfo placeInfo, boolean isClassType) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isElementCanBeUsedInContext"));
        }
        if (placeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isElementCanBeUsedInContext"));
        }
        PsiElement parentContext = placeInfo.getParentElement();
        boolean isNewContext = parentContext instanceof JSNewExpression;
        boolean isCallContext = parentContext instanceof JSCallExpression;
        if (!isClassType && isNewContext) {
            return false;
        }
        if (isClassType && isCallContext && !isNewContext) {
            return false;
        }
        return !(elementToImport instanceof TypeScriptInterface) || !isCallContext;
    }

    public static void addImportStatement(@Nullable Editor editor, @NotNull String name, @NotNull JSElement elementToImport, @NotNull PsiElement place) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "addImportStatement"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "addImportStatement"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "addImportStatement"));
        }
        new TypeScriptAddImportExecutor(name, editor, place).execute(elementToImport);
    }

    public static void showError(Project project, @Nullable Editor editor) {
        String name = TypeScriptAddImportStatementFix.getActionName();
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot find module for import", (String)name, null);
    }

    static boolean isSelfExportedAugmentationModule(@NotNull TypeScriptModule container) {
        String reference;
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isSelfExportedAugmentationModule"));
        }
        PsiElement parent = container.getParent();
        JSExportAssignment assignment = TypeScriptAutoImportUtil.getExportAssignment(parent);
        if (assignment != null && (reference = assignment.getInitializerReference()) != null) {
            JSTypeResolveResult result = TypeScriptImportHandler.getInstance().resolveName(reference, (PsiElement)assignment);
            return result.getElements().contains(container);
        }
        return false;
    }

    public static TypeScriptImportStatement createTypeScriptImport(@NotNull PsiElement place, @NotNull ES6ImportPsiUtil.CreateImportExportInfo info, @NotNull String moduleName) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createTypeScriptImport"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createTypeScriptImport"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createTypeScriptImport"));
        }
        ES6ImportPsiUtil.ImportExportType importType = info.getImportType();
        String name = info.getImportedName();
        StringBuilder builder = new StringBuilder("import ");
        if (importType == ES6ImportPsiUtil.ImportExportType.TS_REQUIRE_IMPORT) {
            builder.append(name).append(" = require(").append(moduleName).append(')');
        } else {
            builder.append(name).append(" = ").append(moduleName);
        }
        builder.append(JSCodeStyleSettings.getSemicolon(place.getContainingFile()));
        ASTNode importNode = JSChangeUtil.createStatementFromTextWithContext(builder.toString(), place);
        if (importNode == null || importNode.getElementType() != TypeScriptElementTypes.IMPORT_STATEMENT) {
            return null;
        }
        return (TypeScriptImportStatement)importNode.getPsi(TypeScriptImportStatement.class);
    }

    @Nullable
    public static JSModuleNameInfo getExternalFileModuleName(@NotNull Project project, @NotNull JSElement elementToImport, @NotNull PsiElement place) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        return TypeScriptAutoImportUtil.getExternalFileModuleName(project, elementToImport, elementToImport.getContainingFile().getOriginalFile(), place);
    }

    @Nullable
    public static JSModuleNameInfo getExternalFileModuleName(@NotNull Project project, @Nullable JSElement elementToImport, @NotNull PsiFile dstPsiFile, @NotNull PsiElement place) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        if (dstPsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstPsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalFileModuleName"));
        }
        Ref ref = Ref.create();
        String[] excludedNames = JSCodeStyleSettings.getSettings(place).getBlacklistImports();
        TypeScriptAutoImportUtil.processExternalFileModuleNames(project, elementToImport, dstPsiFile, place, (Processor<JSModuleNameInfo>)((Processor)info -> {
            if (info.isValid() && (excludedNames.length == 0 || !ArrayUtil.contains((String)info.getModuleName(), (String[])excludedNames))) {
                ref.set(info);
                return false;
            }
            return true;
        }));
        return (JSModuleNameInfo)ref.get();
    }

    public static void processExternalFileModuleNames(@NotNull Project project, @Nullable JSElement toImport, @NotNull PsiFile dstPsiFile, @NotNull PsiElement place, @NotNull Processor<JSModuleNameInfo> processor) {
        JSModuleNameInfo mappings;
        TypeScriptConfig configFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processExternalFileModuleNames"));
        }
        if (dstPsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstPsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processExternalFileModuleNames"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processExternalFileModuleNames"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processExternalFileModuleNames"));
        }
        PsiFile placePsiFile = place.getContainingFile().getOriginalFile();
        VirtualFile placeFile = placePsiFile.getVirtualFile();
        VirtualFile dstFile = dstPsiFile.getVirtualFile();
        if (!TypeScriptAutoImportUtil.processModuleNameUsingNodeModules(project, dstFile, placePsiFile, toImport, processor)) {
            return;
        }
        TypeScriptConfig typeScriptConfig = configFile = DialectDetector.isTypeScript((PsiElement)placePsiFile) ? TypeScriptConfigUtil.getConfigForPsiFile(placePsiFile) : null;
        if (configFile != null && (mappings = TypeScriptAutoImportUtil.getModuleNameUsingPathMappings(project, configFile, placePsiFile, dstFile, toImport)) != null && !processor.process((Object)mappings)) {
            return;
        }
        JSModuleNameInfo moduleInfo = ES6CreateImportUtil.getExternalModuleNameForFile(place, placeFile, toImport, dstFile, configFile, true);
        if (moduleInfo != null) {
            processor.process((Object)moduleInfo);
        }
    }

    @Nullable
    public static VirtualFile getRootFromConfig(@Nullable TypeScriptConfig configFile) {
        if (configFile == null) {
            return null;
        }
        VirtualFile baseUrl = configFile.getBaseUrl();
        return baseUrl != null ? baseUrl : configFile.getConfigDirectory();
    }

    public static JSModuleNameInfo getModuleNameUsingPathMappings(@NotNull Project project, @NotNull TypeScriptConfig file, @NotNull PsiFile placePsiFile, @NotNull VirtualFile dstFile, @Nullable JSElement elementToImport) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingPathMappings"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingPathMappings"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingPathMappings"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingPathMappings"));
        }
        VirtualFile baseUrl = file.getBaseUrl();
        if (baseUrl == null) {
            return null;
        }
        JSModuleNameInfo currentMapping = null;
        for (JSModulePathSubstitution substitution : file.getPaths()) {
            String pattern = substitution.getPattern();
            if (StringUtil.isEmpty((String)pattern)) continue;
            for (String mapping : substitution.getMappings()) {
                JSModuleNameInfo possibleMapping;
                if (StringUtil.isEmpty((String)mapping) || (possibleMapping = TypeScriptAutoImportUtil.getModuleNameForMapping(project, baseUrl, dstFile, pattern, mapping, placePsiFile, elementToImport)) == null || !TypeScriptAutoImportUtil.shouldUseNewMapping(currentMapping, possibleMapping)) continue;
                currentMapping = possibleMapping;
            }
        }
        return currentMapping;
    }

    private static boolean shouldUseNewMapping(@Nullable JSModuleNameInfo oldMapping, @NotNull JSModuleNameInfo newMapping) {
        if (newMapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMapping", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "shouldUseNewMapping"));
        }
        if (oldMapping == null) {
            return true;
        }
        return oldMapping.getPath().length() > newMapping.getPath().length();
    }

    @Nullable
    private static JSModuleNameInfo getModuleNameForMapping(@NotNull Project project, @NotNull VirtualFile baseUrl, @NotNull VirtualFile dstFile, @NotNull String pattern, @NotNull String mapping, @NotNull PsiFile placePsiFile, @Nullable JSElement elementToImport) {
        boolean hasSeparatorInFirstPart;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (baseUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseUrl", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameForMapping"));
        }
        mapping = FileUtil.toSystemIndependentName((String)mapping);
        int starIndex = mapping.indexOf("*");
        if (pattern.length() < 2) {
            return null;
        }
        if (starIndex < 0) {
            VirtualFile pathFile = TypeScriptAutoImportUtil.getPossibleFileWithExtension(baseUrl, mapping);
            if (pathFile == null) {
                return null;
            }
            VirtualFile file = TypeScriptAutoImportUtil.isFromNestedDirectory(pathFile, dstFile) ? ES6CreateImportUtil.checkSymbolAndGetFile(project, dstFile, pathFile, (PsiElement)placePsiFile, elementToImport) : null;
            return file == null ? null : new JSModuleNameInfo(pattern, file, pathFile, (PsiElement)placePsiFile);
        }
        String firstPart = mapping.substring(0, starIndex);
        int separatorIndex = firstPart.lastIndexOf(47);
        VirtualFile startDirectory = baseUrl;
        boolean bl = hasSeparatorInFirstPart = separatorIndex >= 0;
        if (hasSeparatorInFirstPart) {
            startDirectory = JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, firstPart.substring(0, separatorIndex));
        }
        if (startDirectory == null) {
            return null;
        }
        List<VirtualFile> parents = TypeScriptAutoImportUtil.collectParents(dstFile, startDirectory);
        if (parents.isEmpty()) {
            return null;
        }
        VirtualFile placeDirectory = placePsiFile.getVirtualFile().getParent();
        String partOfString = mapping.substring(hasSeparatorInFirstPart ? separatorIndex : 0);
        for (VirtualFile pathFile : ContainerUtil.reverse(parents)) {
            VirtualFile file;
            String stringToCheckPattern;
            if (pathFile.equals(placeDirectory) || StringUtil.isEmpty((String)(stringToCheckPattern = VfsUtil.getPath((VirtualFile)startDirectory, (VirtualFile)pathFile, (char)'/')))) continue;
            JSModulePattern pathSubstitution = JSPathMappingsUtil.createPatternForString(partOfString);
            Pair matchedStar = JSPathMappingsUtil.findMaxElementByPaths((hasSeparatorInFirstPart ? "/" : "") + stringToCheckPattern, ContainerUtil.createMaybeSingletonList((Object)pathSubstitution));
            if (matchedStar == null || (file = ES6CreateImportUtil.checkSymbolAndGetFile(project, dstFile, pathFile, (PsiElement)placePsiFile, elementToImport)) == null) continue;
            return new JSModuleNameInfo(pattern.replace("*", (CharSequence)matchedStar.second), file, pathFile, (PsiElement)placePsiFile);
        }
        return null;
    }

    @NotNull
    private static List<VirtualFile> collectParents(@NotNull VirtualFile dstFile, VirtualFile startDirectory) {
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "collectParents"));
        }
        ArrayList parents = ContainerUtil.newArrayList((Object[])new VirtualFile[]{dstFile});
        boolean hasParent = false;
        for (VirtualFile parent = dstFile.getParent(); parent != null; parent = parent.getParent()) {
            if (startDirectory.equals(parent)) {
                hasParent = true;
                break;
            }
            parents.add(parent);
        }
        if (!hasParent) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "collectParents"));
            }
            return list;
        }
        ArrayList arrayList = parents;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "collectParents"));
        }
        return arrayList;
    }

    private static VirtualFile getPossibleFileWithExtension(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseUrl", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getPossibleFileWithExtension"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getPossibleFileWithExtension"));
        }
        if (JSFileReference.findExtension(mapping, TypeScriptUtil.TYPESCRIPT_EXTENSIONS) != null) {
            return JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, mapping);
        }
        for (String extension : TypeScriptUtil.TYPESCRIPT_EXTENSIONS) {
            VirtualFile possibleFile = JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, mapping + extension);
            if (possibleFile == null) continue;
            return possibleFile;
        }
        return JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, mapping);
    }

    public static boolean processModuleNameUsingNodeModules(@NotNull Project project, @NotNull VirtualFile dstFile, @NotNull PsiFile placePsiFile, @Nullable JSElement elementToImport, @NotNull Processor<JSModuleNameInfo> processor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processModuleNameUsingNodeModules"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processModuleNameUsingNodeModules"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processModuleNameUsingNodeModules"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "processModuleNameUsingNodeModules"));
        }
        Pair<VirtualFile, VirtualFile> libraryDirectory = ES6CreateImportUtil.findParentLibraryDirectory(project, dstFile, NODE_MODULES);
        if (libraryDirectory == null) {
            return true;
        }
        VirtualFile moduleDirectory = (VirtualFile)libraryDirectory.first;
        VirtualFile directoryToCalcModuleName = ES6CreateImportUtil.getDirectoryToCalcModuleNameInNodeModules(placePsiFile, moduleDirectory);
        if (directoryToCalcModuleName == null) {
            return true;
        }
        ArrayList elements = ContainerUtil.newArrayList(TypeScriptAutoImportUtil.collectParents(dstFile, moduleDirectory));
        elements.add(moduleDirectory);
        List virtualFiles = ContainerUtil.reverse((List)elements);
        for (VirtualFile file : virtualFiles) {
            String path;
            VirtualFile candidate;
            if (file.equals(dstFile) || (candidate = ES6CreateImportUtil.checkSymbolAndGetFile(project, dstFile, file, (PsiElement)placePsiFile, elementToImport)) == null || !TypeScriptUtil.isDefinitionFile(candidate) || processor.process((Object)new JSModuleNameInfo(path = VfsUtil.getPath((VirtualFile)directoryToCalcModuleName, (VirtualFile)file, (char)'/'), candidate, file, (PsiElement)placePsiFile))) continue;
            return false;
        }
        if (elementToImport != null && !moduleDirectory.equals(dstFile.getParent())) {
            for (VirtualFile candidate : moduleDirectory.getChildren()) {
                String path;
                JSModuleNameInfo moduleInfo;
                if (candidate.isDirectory() || !TypeScriptUtil.isDefinitionFile(candidate) || !ES6CreateImportUtil.checkSymbolInFile(project, candidate, elementToImport, (PsiElement)placePsiFile) || processor.process((Object)(moduleInfo = new JSModuleNameInfo(path = VfsUtil.getPath((VirtualFile)directoryToCalcModuleName, (VirtualFile)candidate, (char)'/'), candidate, candidate, (PsiElement)elementToImport)))) continue;
                return false;
            }
        }
        String path = VfsUtil.getPath((VirtualFile)directoryToCalcModuleName, (VirtualFile)dstFile, (char)'/');
        JSModuleNameInfo moduleInfo = new JSModuleNameInfo(path, dstFile, dstFile, (PsiElement)placePsiFile);
        return processor.process((Object)moduleInfo);
    }

    @Nullable
    static JSExportAssignment getExportAssignment(@Nullable PsiElement module) {
        if (module == null) {
            return null;
        }
        Object[] children = JSResolveUtil.getStubbedChildren(module, EXPORT_ASSIGNMENTS);
        PsiElement element = (PsiElement)ArrayUtil.getFirstElement((Object[])children);
        return element instanceof JSExportAssignment ? (JSExportAssignment)element : null;
    }

    @NotNull
    public static GlobalSearchScope createSymbolToImportSearchScope(final @NotNull Project project, @NotNull PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createSymbolToImportSearchScope"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createSymbolToImportSearchScope"));
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)context);
        final List configs = file == null ? ContainerUtil.emptyList() : TypeScriptConfigService.Provider.getConfigInclude(project, file);
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(JSResolveUtil.getResolveScope(context)){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$1", "contains"));
                }
                if (!super.contains(file) || !TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file.getFileType())) {
                    return false;
                }
                if (!TypeScriptUtil.isUnderNodeModules(file, project) || TypeScriptUtil.isDefinitionFile(file)) {
                    return true;
                }
                if (configs.isEmpty()) {
                    return false;
                }
                for (TypeScriptConfig config2 : configs) {
                    if (!config2.isIncludedFile(file, false) && !config2.isFromFileList(file)) continue;
                    return true;
                }
                return false;
            }
        };
        if (delegatingGlobalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createSymbolToImportSearchScope"));
        }
        return delegatingGlobalSearchScope;
    }

    private static boolean isFromNestedDirectory(VirtualFile parentFile, VirtualFile dstFile) {
        if (parentFile.equals(dstFile)) {
            return true;
        }
        if (!parentFile.isDirectory()) {
            parentFile = parentFile.getParent();
        }
        return VfsUtilCore.isAncestor((VirtualFile)parentFile, (VirtualFile)dstFile, (boolean)false);
    }
}

