/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptGenericTypesEvaluator
extends JSGenericTypesEvaluator {
    private static TypeScriptGenericTypesEvaluator INSTANCE = null;

    protected TypeScriptGenericTypesEvaluator() {
    }

    public static TypeScriptGenericTypesEvaluator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TypeScriptGenericTypesEvaluator();
        }
        return INSTANCE;
    }

    @Override
    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, @NotNull JSReferenceExpression methodExpression) {
        JSType rawQualifier;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
        }
        if (methodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodExpression", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
        }
        if (DialectDetector.isJavaScript((PsiElement)qualifier)) {
            type = super.evaluateGenericsFromQualifier(type, qualifier, methodExpression);
        }
        boolean hasGenerics = JSTypeUtils.hasGenericParameter(type);
        boolean hasThisGenericType = JSTypeUtils.hasThisGenericType(type);
        if (!hasGenerics && !hasThisGenericType) {
            if (!(type instanceof JSTypeImpl)) {
                JSType jSType = type;
                if (jSType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
                }
                return jSType;
            }
            JSTypeImpl jsType = (JSTypeImpl)type;
            if (!jsType.isLocal()) {
                JSType jSType = type;
                if (jSType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
                }
                return jSType;
            }
        }
        if ((rawQualifier = JSResolveUtil.getExpressionJSType(qualifier)) != null && hasThisGenericType) {
            type = TypeScriptGenericTypesEvaluator.evaluateThisType(type, rawQualifier);
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        JSType jSType = type = TypeScriptGenericTypesEvaluator.evaluateGenericsFromQualifierType(type, rawQualifier, sourceElement);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
        }
        return jSType;
    }

    private static JSType evaluateThisType(@NotNull JSType type, @NotNull JSType qualifierType) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateThisType"));
        }
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateThisType"));
        }
        return type.transformTypeHierarchy(jsType -> {
            if (qualifierType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "lambda$evaluateThisType$0"));
            }
            if (jsType instanceof TypeScriptGenericThisTypeImpl) {
                return qualifierType;
            }
            return jsType;
        });
    }

    @Contract(value="!null,_,_ -> !null")
    private static JSType evaluateGenericsFromQualifierType(@Nullable JSType type, @Nullable JSType qualifierType, @Nullable PsiElement sourceElement) {
        JSTypeSubstitutor substitutor;
        if (type != null && qualifierType != null && !(substitutor = TypeScriptGenericTypesEvaluator.getTypeSubstitutorFromQualifierType(qualifierType, sourceElement)).isEmpty()) {
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)substitutor);
        }
        return type;
    }

    @NotNull
    private static JSTypeSubstitutor getTypeSubstitutorFromQualifierType(@NotNull JSType qualifierType, @Nullable PsiElement sourceElement) {
        JSClass parentClass;
        JSType constraintType;
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getTypeSubstitutorFromQualifierType"));
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        if ((qualifierType = JSTypeUtils.unwrapDecorations(qualifierType)) instanceof JSIntersectionTypeImpl) {
            for (JSType typeToProcess : ((JSIntersectionTypeImpl)qualifierType).getTypes()) {
                JSTypeSubstitutor candidate = TypeScriptGenericTypesEvaluator.getTypeSubstitutorFromQualifierType(typeToProcess, sourceElement);
                substitutor.putAll((Map)candidate);
            }
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getTypeSubstitutorFromQualifierType"));
            }
            return jSTypeSubstitutor;
        }
        if (qualifierType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)qualifierType;
            Map<String, JSType> outerArguments = genericType.getOuterArguments();
            if (outerArguments != null) {
                substitutor.putAll(outerArguments);
            }
        } else if (qualifierType instanceof JSRecordType) {
            MultiMap<String, JSType> generics;
            PsiElement qualifierSource = qualifierType.getSource().getSourceElement();
            JSType objectType = null;
            if (qualifierSource instanceof TypeScriptObjectType) {
                objectType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)((TypeScriptObjectType)qualifierSource));
            } else if (qualifierSource instanceof JSClass) {
                objectType = TypeScriptTypeParser.buildTypeFromClass((JSClass)qualifierSource, false);
            } else if (qualifierSource instanceof JSObjectLiteralExpression) {
                objectType = JSResolveUtil.getExpressionJSType((JSExpression)qualifierSource);
            }
            if (objectType != null && !(generics = TypeScriptGenericTypesEvaluator.findGenericsTypeValues(qualifierType, objectType)).isEmpty()) {
                JSTypeSubstitutor candidate = TypeScriptGenericTypesEvaluator.intersectGenerics(generics, null);
                substitutor.putAll((Map)candidate);
                JSTypeSubstitutor jSTypeSubstitutor = substitutor;
                if (jSTypeSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getTypeSubstitutorFromQualifierType"));
                }
                return jSTypeSubstitutor;
            }
        }
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        if (arguments == null && qualifierType instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)qualifierType).getConstraintType()) != null) {
            qualifierType = constraintType;
            arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        }
        if (sourceElement != null && (arguments != null && JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false) != null || qualifierType instanceof JSTypeImpl) && (parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)sourceElement, JSClass.class)) != null) {
            Collection<JSClass> qualifierClasses = TypeScriptGenericTypesEvaluator.getQualifierClasses(qualifierType);
            for (JSClass qualifierClass : qualifierClasses) {
                List<JSType> argumentsList = arguments == null || arguments.isEmpty() ? TypeScriptGenericTypesEvaluator.getArgumentsListForQualifierType(qualifierType, qualifierClass) : arguments;
                Ref ref = Ref.create((Object)substitutor);
                TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(qualifierClass, argumentsList, parentClass, (Ref<JSTypeSubstitutor>)ref);
                if (ref.isNull()) continue;
                substitutor = (JSTypeSubstitutor)ref.get();
            }
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getTypeSubstitutorFromQualifierType"));
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static List<JSType> getArgumentsListForQualifierType(@NotNull JSType qualifierType, @NotNull JSClass qualifierClass) {
        TypeScriptTypeParameter[] parameters;
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getArgumentsListForQualifierType"));
        }
        if (qualifierClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierClass", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getArgumentsListForQualifierType"));
        }
        if (TypeScriptGenericTypesEvaluator.isInstanceJSTypeImpl(qualifierType) && (parameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)qualifierClass)).length > 0) {
            List<JSType> list = Arrays.stream(parameters).map(JSGenericTypesEvaluator::getTypeParameterDefaultType).collect(Collectors.toList());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getArgumentsListForQualifierType"));
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getArgumentsListForQualifierType"));
        }
        return list;
    }

    private static boolean isInstanceJSTypeImpl(@NotNull JSType qualifierType) {
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "isInstanceJSTypeImpl"));
        }
        return qualifierType instanceof JSTypeImpl && ((JSTypeImpl)qualifierType).getTypeContext().toJSContext() == JSContext.INSTANCE;
    }

    @NotNull
    public static JSType processClassWithGenericArguments(@Nullable JSClass aClass, @NotNull List<JSType> typeArgumentsList, @Nullable JSClass requiredParentClass, @NotNull JSType appliedGenerics) {
        if (typeArgumentsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgumentsList", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "processClassWithGenericArguments"));
        }
        if (appliedGenerics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appliedGenerics", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "processClassWithGenericArguments"));
        }
        Ref substitutor = Ref.create();
        TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(aClass, typeArgumentsList, requiredParentClass, (Ref<JSTypeSubstitutor>)substitutor);
        JSType jSType = JSTypeUtils.applyGenericArguments(appliedGenerics, (Map)substitutor.get());
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "processClassWithGenericArguments"));
        }
        return jSType;
    }

    public static void processClassWithGenericArguments(@Nullable JSClass contextClass, @NotNull List<JSType> typeArgumentsList, @Nullable JSClass expectedGenericOwnerClass, @NotNull Ref<JSTypeSubstitutor> substitutor) {
        if (typeArgumentsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgumentsList", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "processClassWithGenericArguments"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "processClassWithGenericArguments"));
        }
        TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(contextClass, typeArgumentsList, expectedGenericOwnerClass, substitutor, ContainerUtil.newHashSet());
    }

    public static boolean processClassWithGenericArguments(@Nullable JSClass contextClass, @NotNull List<JSType> typeArgumentsList, @Nullable JSClass expectedGenericOwnerClass, @NotNull Ref<JSTypeSubstitutor> substitutor, @NotNull Set<JSClass> visitedClasses) {
        if (typeArgumentsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgumentsList", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "processClassWithGenericArguments"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "processClassWithGenericArguments"));
        }
        if (visitedClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedClasses", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "processClassWithGenericArguments"));
        }
        if (!(contextClass instanceof TypeScriptTypeParameterListOwner) || expectedGenericOwnerClass == null) {
            return true;
        }
        if (contextClass.isEquivalentTo((PsiElement)expectedGenericOwnerClass)) {
            JSTypeSubstitutor genericArguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)contextClass, typeArgumentsList);
            JSTypeSubstitutor oldSubstitutor = (JSTypeSubstitutor)substitutor.get();
            if (oldSubstitutor != null && genericArguments != null) {
                genericArguments.putAll((Map)oldSubstitutor);
            }
            substitutor.set((Object)genericArguments);
            return false;
        }
        ArrayList superReferences = ContainerUtil.newArrayList();
        JSReferenceList extendsList = contextClass.getExtendsList();
        JSReferenceList implementsList = contextClass.getImplementsList();
        if (extendsList != null) {
            superReferences.addAll(extendsList.getResolvedExpressions());
        }
        if (implementsList != null) {
            superReferences.addAll(implementsList.getResolvedExpressions());
        }
        if (!superReferences.isEmpty()) {
            JSTypeSubstitutor typeArguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)contextClass, typeArgumentsList);
            for (Pair reference : superReferences) {
                if (reference.second == null || ((Collection)reference.second).isEmpty()) continue;
                List<JSType> superclassTypeArguments = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(((JSReferenceListMember)reference.first).getTypeArguments(), (Map<String, JSType>)typeArguments);
                for (JSClass jsSuperClass : (Collection)reference.second) {
                    if (!JSInheritanceUtil.isParentClass(jsSuperClass, expectedGenericOwnerClass, false)) continue;
                    if (!visitedClasses.add(jsSuperClass)) {
                        return false;
                    }
                    if (TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(jsSuperClass, superclassTypeArguments, expectedGenericOwnerClass, substitutor, visitedClasses)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    public static List<JSType> getTypeArgumentsForDeclarations(@NotNull JSTypeDeclaration[] declarations, @Nullable Map<String, JSType> typeArguments) {
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getTypeArgumentsForDeclarations"));
        }
        List mappedArguments = ContainerUtil.newSmartList();
        for (JSTypeDeclaration typeArgument : declarations) {
            JSType expandedType = TypeScriptTypeParser.buildTypeFromTypeScript(typeArgument);
            if (typeArguments != null) {
                expandedType = JSTypeUtils.applyGenericArguments(expandedType, typeArguments);
            }
            mappedArguments.add(expandedType);
        }
        List list = mappedArguments;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getTypeArgumentsForDeclarations"));
        }
        return list;
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @Nullable JSType genericType) {
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        return arguments == null ? null : TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner, arguments);
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @NotNull List<JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgumentsList", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getSubstitutorForTypeArguments"));
        }
        if (typeParameterListOwner == null) {
            return null;
        }
        return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner.getTypeParameterList(), typeArgumentsList);
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterList typeParameterList, @NotNull List<JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgumentsList", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getSubstitutorForTypeArguments"));
        }
        if (typeArgumentsList.isEmpty() || typeParameterList == null) {
            return null;
        }
        TypeScriptTypeParameter[] parameters = typeParameterList.getTypeParameters();
        return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(parameters, typeArgumentsList);
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@NotNull TypeScriptTypeParameter[] parameters, @NotNull List<JSType> typeArgumentsList) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getSubstitutorForTypeArguments"));
        }
        if (typeArgumentsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgumentsList", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getSubstitutorForTypeArguments"));
        }
        if (typeArgumentsList.size() == 0 || parameters.length == 0) {
            JSTypeSubstitutor jSTypeSubstitutor = new JSTypeSubstitutor();
            if (jSTypeSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getSubstitutorForTypeArguments"));
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor genericArguments = new JSTypeSubstitutor();
        for (int i = 0; i < parameters.length; ++i) {
            String name;
            TypeScriptTypeParameter parameter = parameters[i];
            JSType type = null;
            if (typeArgumentsList.size() > i) {
                type = typeArgumentsList.get(i);
            }
            if (type == null) {
                type = TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            }
            if ((name = parameter.getName()) == null) continue;
            genericArguments.put((Object)name, (Object)type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = genericArguments;
        if (jSTypeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getSubstitutorForTypeArguments"));
        }
        return jSTypeSubstitutor;
    }

    @Override
    @Nullable
    public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        if (!this.canHaveGenericParameters(type)) {
            return type;
        }
        if (methodExpression != null) {
            JSReferenceList list;
            TypeScriptClass tsClass;
            PsiElement callExpression = methodExpression.getParent();
            JSTypeSubstitutor map = TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(resolvedFunction, callExpression, null);
            if (TypeScriptGenericTypesEvaluator.isConstructorSuperCall(resolvedFunction, (PsiElement)methodExpression) && (tsClass = (TypeScriptClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)methodExpression, TypeScriptClass.class)) != null && resolvedFunction instanceof TypeScriptFunction && (list = tsClass.getExtendsList()) != null) {
                if (tsClass.getIndirectSuperConstructors().contains(resolvedFunction)) {
                    JSExpression element = (JSExpression)ArrayUtil.getFirstElement((Object[])list.getExpressions());
                    List<JSType> typesForGenerics = element != null ? TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(TypeScriptPsiUtil.getNestedTypeArguments(element.getParent()), null) : ContainerUtil.emptyList();
                    TypeScriptFunction tsFunction = (TypeScriptFunction)resolvedFunction;
                    JSTypeSubstitutor argumentsFromSuper = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)tsFunction, typesForGenerics);
                    if (map != null && argumentsFromSuper != null) {
                        map.putAll(argumentsFromSuper);
                    }
                } else {
                    JSClass parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolvedFunction, JSClass.class);
                    type = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments((JSClass)tsClass, (List<JSType>)ContainerUtil.emptyList(), parentClass, type);
                }
            }
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)map, false, reporter);
        }
        return super.evaluateGenerics(type, methodExpression, resolvedFunction, reporter);
    }

    @NotNull
    public static JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable PsiElement member, @Nullable PsiElement place, @Nullable JSType qualifierType, @Nullable JSTypeSubstitutor additionalSubstitutor) {
        JSTypeSubstitutor candidate;
        PsiElement parent;
        boolean isFunctionCallContext;
        if (place == null || !(member instanceof JSQualifiedNamedElement)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getTypeSubstitutorForMember"));
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        if (additionalSubstitutor != null) {
            substitutor.putAll((Map)additionalSubstitutor);
        }
        boolean bl = isFunctionCallContext = (parent = place.getParent()) instanceof JSCallExpression && member instanceof TypeScriptTypeParameterListOwner;
        if (isFunctionCallContext) {
            candidate = TypeScriptGenericTypesEvaluator.inferGenericTypesForCall(member, (JSCallExpression)parent, null);
            candidate.forEach((key, value) -> {
                if (!(value instanceof JSAnyType)) {
                    substitutor.put(key, value);
                }
            });
        }
        if (qualifierType != null) {
            candidate = TypeScriptGenericTypesEvaluator.getTypeSubstitutorFromQualifierType(qualifierType, member);
            substitutor.putAll((Map)candidate);
        }
        if (isFunctionCallContext) {
            substitutor.putAll((Map)TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(member, parent, substitutor));
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getTypeSubstitutorForMember"));
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable JSElement member, @NotNull PsiElement place) {
        List<JSFunctionWithSubstitutor> elements;
        JSFunctionWithSubstitutor functionWithSubstitutor;
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getTypeSubstitutorForMember"));
        }
        if (member == null || !DialectDetector.isTypeScript((PsiElement)member) || !(place instanceof JSReferenceExpression)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getTypeSubstitutorForMember"));
            }
            return jSTypeSubstitutor;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)place;
        JSExpression qualifier = referenceExpression.getQualifier();
        JSType qualifierType = null;
        if (qualifier != null) {
            qualifierType = JSResolveUtil.getExpressionJSType(qualifier);
        }
        if (referenceExpression.getParent() instanceof JSCallExpression && (functionWithSubstitutor = (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(elements = TypeScriptSignatureChooser.getFunctionElementsWithCheckParameterTypes((PsiElement)referenceExpression))) != null) {
            JSFunctionItem functionItem = functionWithSubstitutor.myFunctionItem;
            JSTypeSubstitutor additionalSubstitutor = functionWithSubstitutor.myTypeSubstitutor;
            JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getTypeSubstitutorForMember((PsiElement)functionItem, place, qualifierType, additionalSubstitutor);
            if (jSTypeSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getTypeSubstitutorForMember"));
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getTypeSubstitutorForMember((PsiElement)member, place, qualifierType, null);
        if (jSTypeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getTypeSubstitutorForMember"));
        }
        return jSTypeSubstitutor;
    }

    private static boolean isConstructorSuperCall(PsiElement resolveResult, PsiElement callExpression) {
        return callExpression instanceof JSSuperExpression && callExpression.getParent() instanceof JSCallExpression && resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor();
    }

    @Nullable
    public static JSType getParameterExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getParameterExpressionType"));
        }
        Ref exprTypeRef = Ref.create(null);
        JSTypeEvaluator.processWithEvaluationGuard(expression, JSEvaluateContext.JSEvaluationPlace.PARAMETER_TYPE, e -> exprTypeRef.set((Object)JSTypeEvaluator.getExpressionType(e)));
        JSTypeEvaluationResult result = (JSTypeEvaluationResult)exprTypeRef.get();
        if (result == null) {
            return null;
        }
        List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result.getResults();
        if (results.size() <= 1) {
            return JSTypeUtils.getValuableType(result.getType());
        }
        ArrayList types = ContainerUtil.newArrayList();
        JSTypeSource source = null;
        for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
            JSType type = JSTypeUtils.getValuableType(element.getType());
            if (type == null) continue;
            types.add(type);
            JSTypeSource typeSource = type.getSource();
            source = source == null ? typeSource : JSTypeSourceFactory.copyTypeSource(source, source.isExplicitlyDeclared() && typeSource.isExplicitlyDeclared());
        }
        if (types.size() <= 1) {
            return (JSType)ContainerUtil.getFirstItem((List)types);
        }
        return new JSCompositeTypeImpl(source == null ? JSTypeSource.EMPTY_TS : source, types);
    }

    public static void fillExplicitGenericArguments(@NotNull TypeScriptTypeParameter[] typeParameters, @NotNull JSTypeDeclaration[] typeArguments, @NotNull Map<String, JSType> genericArguments) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "fillExplicitGenericArguments"));
        }
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "fillExplicitGenericArguments"));
        }
        if (genericArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericArguments", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "fillExplicitGenericArguments"));
        }
        if (typeParameters.length == 0) {
            return;
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            String name;
            JSType type;
            TypeScriptTypeParameter parameter = typeParameters[i];
            JSTypeDeclaration typeArgument = typeArguments.length > i ? typeArguments[i] : null;
            JSType jSType = type = typeArgument != null ? TypeScriptTypeParser.buildTypeFromTypeScript(typeArgument) : null;
            if (typeArguments.length > 0 && type == null) {
                type = TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            }
            if ((name = parameter.getName()) == null || genericArguments.containsKey(name) && type == null) continue;
            genericArguments.put(name, type);
        }
    }

    @Contract(value="_,_,!null -> !null")
    public static JSTypeSubstitutor addExplicitGenericArgumentsFromCall(PsiElement resolveResult, PsiElement callExpression, @Nullable JSTypeSubstitutor genericArguments) {
        TypeScriptTypeParameter[] typeParameters;
        JSClass clazz;
        if (!(resolveResult instanceof TypeScriptTypeParameterListOwner)) {
            return genericArguments == null ? null : new JSTypeSubstitutor((Map)genericArguments);
        }
        JSTypeSubstitutor substitutor = genericArguments == null ? new JSTypeSubstitutor() : new JSTypeSubstitutor((Map)genericArguments);
        TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)resolveResult).getTypeParameterList();
        if (typeParameterList != null) {
            TypeScriptTypeParameter[] typeParameters2 = typeParameterList.getTypeParameters();
            JSTypeDeclaration[] typeArguments = TypeScriptPsiUtil.getNestedTypeArguments(callExpression);
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(typeParameters2, typeArguments, (Map<String, JSType>)substitutor);
        }
        if ((clazz = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolveResult, JSClass.class)) instanceof TypeScriptTypeParameterListOwner && (typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)clazz)).length > 0) {
            JSTypeDeclaration[] typeArguments = TypeScriptPsiUtil.getNewExpressionTypeArguments(callExpression);
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(typeParameters, typeArguments, (Map<String, JSType>)substitutor);
        }
        return substitutor;
    }

    @NotNull
    public static List<JSType> getArgumentTypesForSignatureChecking(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getArgumentTypesForSignatureChecking"));
        }
        List argumentTypes = ContainerUtil.newSmartList();
        for (JSExpression expression : callExpression.getArguments()) {
            argumentTypes.add(TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(expression, TypeScriptGenericTypesEvaluator.getParameterExpressionType(expression)));
        }
        List list = argumentTypes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getArgumentTypesForSignatureChecking"));
        }
        return list;
    }

    @NotNull
    public static JSType getExplicitTypeOrAny(@NotNull JSExpression expression, @Nullable JSType type) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getExplicitTypeOrAny"));
        }
        JSType jSType = type == null ? JSAnyType.get((PsiElement)expression, false) : JSTypeUtils.replaceImplicitTypesWithAny(type);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getExplicitTypeOrAny"));
        }
        return jSType;
    }

    @NotNull
    public static Collection<JSClass> getQualifierClasses(@Nullable JSType qualifierType) {
        if (qualifierType == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getQualifierClasses"));
            }
            return list;
        }
        JSTypeSource source = qualifierType.getSource();
        if (!source.isTypeScript() || !source.isExplicitlyDeclared()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getQualifierClasses"));
            }
            return list;
        }
        String type = JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false);
        PsiElement element = source.getSourceElement();
        if (type == null || element == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getQualifierClasses"));
            }
            return list;
        }
        List result = ContainerUtil.newSmartList();
        JSTypeResolveResult resolveResults = TypeScriptImportHandler.getInstance().resolveMainElementName(type, source.getSourceElement());
        for (PsiElement psiElement : resolveResults.getElements()) {
            if (!(psiElement instanceof JSClass)) continue;
            result.add((JSClass)psiElement);
        }
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getQualifierClasses"));
        }
        return list;
    }

    @NotNull
    public static List<JSType> buildGenericParameters(@NotNull TypeScriptTypeParameter[] parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "buildGenericParameters"));
        }
        List<JSType> list = TypeScriptGenericTypesEvaluator.buildGenericParameters(parameters, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "buildGenericParameters"));
        }
        return list;
    }

    @NotNull
    public static List<JSType> buildGenericParameters(@NotNull TypeScriptTypeParameter[] parameters, boolean callEnv) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "buildGenericParameters"));
        }
        ArrayList generics = ContainerUtil.newArrayList();
        for (TypeScriptTypeParameter parameter : parameters) {
            String name;
            TypeScriptType constraint = parameter.getTypeConstraint();
            JSType constraintType = null;
            if (constraint != null) {
                constraintType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)constraint);
            }
            if ((name = parameter.getName()) == null) continue;
            generics.add(new JSGenericParameterImpl(name, JSTypeSourceFactory.createTypeSource((PsiElement)parameter, true), constraintType, callEnv));
        }
        ArrayList arrayList = generics;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "buildGenericParameters"));
        }
        return arrayList;
    }

    @NotNull
    public static JSType applyTypeScriptGenericArguments(@NotNull JSFunctionTypeImpl functionType, @NotNull JSCallExpression callExpression) {
        if (functionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "applyTypeScriptGenericArguments"));
        }
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "applyTypeScriptGenericArguments"));
        }
        PsiElement sourceElement = functionType.getSource().getSourceElement();
        JSTypeSubstitutor defaultParamsSubstitutor = new JSTypeSubstitutor();
        JSType resultType = TypeScriptGenericTypesEvaluator.wrapReturnTypeWithGenerics(functionType, callExpression, defaultParamsSubstitutor);
        JSExpression methodExpression = callExpression.getMethodExpression();
        JSType evaluatedType = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(resultType, methodExpression, sourceElement);
        JSType jSType = JSTypeUtils.applyGenericArguments(evaluatedType, (Map<String, JSType>)defaultParamsSubstitutor);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "applyTypeScriptGenericArguments"));
        }
        return jSType;
    }

    private static JSType wrapReturnTypeWithGenerics(@NotNull JSFunctionTypeImpl functionType, @NotNull JSCallExpression callExpression, JSTypeSubstitutor defaultParamsSubstitutor) {
        if (functionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "wrapReturnTypeWithGenerics"));
        }
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "wrapReturnTypeWithGenerics"));
        }
        PsiElement sourceElement = functionType.getSource().getSourceElement();
        if (callExpression instanceof JSNewExpression && sourceElement instanceof TypeScriptClass) {
            JSType returnType = functionType.getReturnType();
            TypeScriptTypeParameter[] typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner(sourceElement);
            if (typeParameters.length > 0 && returnType instanceof JSNamedType) {
                List<JSType> defaultGenerics;
                JSTypeDeclaration[] arguments = TypeScriptPsiUtil.getNewExpressionTypeArguments((PsiElement)callExpression);
                if (arguments.length == 0) {
                    Arrays.stream(typeParameters).forEach(el -> {
                        JSType cfr_ignored_0 = (JSType)defaultParamsSubstitutor.put((Object)el.getName(), (Object)TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(el));
                    });
                    defaultGenerics = TypeScriptGenericTypesEvaluator.buildGenericParameters(typeParameters);
                } else {
                    defaultGenerics = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(arguments, (Map<String, JSType>)defaultParamsSubstitutor);
                }
                JSGenericTypeImpl newReturnType = new JSGenericTypeImpl(functionType.getSource(), returnType, defaultGenerics);
                return new JSFunctionTypeImpl(functionType.getSource(), functionType.getParameters(), newReturnType);
            }
        }
        return functionType;
    }
}

