/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeHelper
extends JSTypeHelper {
    private static final JSTypeHelper ourTypeHelper = new TypeScriptTypeHelper();

    private TypeScriptTypeHelper() {
    }

    public static JSTypeHelper getInstance() {
        return ourTypeHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAssignableToNamedType(@NotNull JSTypeImpl lOpType, @NotNull JSType rOpType, @Nullable ProcessingContext processingContext) {
        block12: {
            if (lOpType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lOpType", "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper", "isAssignableToNamedType"));
            }
            if (rOpType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rOpType", "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper", "isAssignableToNamedType"));
            }
            if (rOpType instanceof JSRecordType || rOpType instanceof JSFunctionTypeImpl || rOpType instanceof JSArrayTypeImpl) {
                if (processingContext == null) {
                    processingContext = new ProcessingContext();
                }
                JSType lOpResolvedType = lOpType.substitute();
                if (!JSTypeCastUtil.startRecursiveTypesComparison(lOpType, rOpType, processingContext)) {
                    return true;
                }
                try {
                    if (lOpResolvedType != lOpType) {
                        boolean bl = lOpResolvedType.isDirectlyAssignableType(rOpType, processingContext);
                        return bl;
                    }
                    break block12;
                }
                finally {
                    JSTypeCastUtil.endRecursiveTypesComparison(lOpType, rOpType, processingContext);
                }
            }
            if (rOpType instanceof JSGenericTypeImpl) {
                String rOpQName;
                String lOpQName;
                if (processingContext == null) {
                    processingContext = new ProcessingContext();
                }
                if (!JSTypeCastUtil.startRecursiveTypesComparison(lOpQName = lOpType.getResolvedTypeText(), rOpQName = JSTypeUtils.getQualifiedNameMatchingType(rOpType, true), processingContext)) {
                    return true;
                }
                JSRecordType rOpResolvedType = TypeScriptTypeParser.buildResolvedType(rOpType);
                return lOpType.isDirectlyAssignableType((JSType)rOpResolvedType, processingContext);
            }
        }
        return super.isAssignableToNamedType(lOpType, rOpType, processingContext);
    }

    @Override
    public boolean areNamedTypesAssignable(@NotNull JSNamedType lOpType, @NotNull JSNamedType rOpType, @Nullable ProcessingContext processingContext) {
        JSRecordType rOpResolvedType;
        if (lOpType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lOpType", "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper", "areNamedTypesAssignable"));
        }
        if (rOpType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rOpType", "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper", "areNamedTypesAssignable"));
        }
        if (processingContext == null) {
            processingContext = new ProcessingContext();
        }
        if (!JSTypeCastUtil.startRecursiveTypesComparison(lOpType, rOpType, processingContext)) {
            return true;
        }
        JSTypeCastUtil.AssignableResult assignableResult = TypeScriptTypeHelper.areNamedTypesClassAssignable(lOpType, rOpType);
        if (assignableResult.isStrict()) {
            boolean assignable = assignableResult.isAssignable();
            if (!assignable) {
                JSTypeCastUtil.endRecursiveTypesComparison(lOpType, rOpType, processingContext);
            }
            return assignable;
        }
        JSRecordType lOpResolvedType = lOpType.asRecordType();
        boolean result = lOpResolvedType.isDirectlyAssignableType((JSType)(rOpResolvedType = rOpType.asRecordType()), processingContext);
        if (!result) {
            JSTypeCastUtil.endRecursiveTypesComparison(lOpType, rOpType, processingContext);
        }
        return result;
    }

    @NotNull
    public static JSTypeCastUtil.AssignableResult areNamedTypesClassAssignable(@NotNull JSNamedType lOpType, @NotNull JSNamedType rOpType) {
        if (lOpType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lOpType", "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper", "areNamedTypesClassAssignable"));
        }
        if (rOpType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rOpType", "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper", "areNamedTypesClassAssignable"));
        }
        Collection<? extends PsiElement> lOpElements = TypeScriptTypeParser.resolveElementsByType(lOpType);
        Collection<? extends PsiElement> rOpElements = TypeScriptTypeParser.resolveElementsByType(rOpType);
        boolean leftEnum = false;
        boolean rightEnum = false;
        for (PsiElement psiElement : lOpElements) {
            if (psiElement instanceof TypeScriptTypeAlias) continue;
            for (PsiElement psiElement2 : rOpElements) {
                if (psiElement2 instanceof TypeScriptTypeAlias) continue;
                if (psiElement == psiElement2 || psiElement instanceof JSClass && psiElement2 instanceof JSClass && JSInheritanceUtil.isParentClass((JSClass)psiElement2, (JSClass)psiElement, false)) {
                    JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.ASSIGNABLE;
                    if (assignableResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper", "areNamedTypesClassAssignable"));
                    }
                    return assignableResult;
                }
                leftEnum = leftEnum || psiElement instanceof TypeScriptEnum;
                boolean bl = rightEnum = rightEnum || psiElement2 instanceof TypeScriptEnum;
                if ((!leftEnum || !(rOpType instanceof JSNumberType)) && (!rightEnum || !(lOpType instanceof JSNumberType))) continue;
                JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.ASSIGNABLE;
                if (assignableResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper", "areNamedTypesClassAssignable"));
                }
                return assignableResult;
            }
        }
        if (leftEnum && rightEnum) {
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
            if (assignableResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper", "areNamedTypesClassAssignable"));
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_SURE;
        if (assignableResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptTypeHelper", "areNamedTypesClassAssignable"));
        }
        return assignableResult;
    }
}

