/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigsChangedListener;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeScriptConfigService {
    public boolean isAccessible(@NotNull VirtualFile var1, @NotNull VirtualFile var2);

    @NotNull
    public Collection<TypeScriptConfig> getConfigInclude(@NotNull VirtualFile var1);

    @Nullable
    public TypeScriptConfig getConfig(@NotNull VirtualFile var1);

    @NotNull
    public Collection<TypeScriptConfig> getConfigFiles();

    public boolean isConfigInclude(@NotNull VirtualFile var1, @NotNull TypeScriptConfig var2);

    public void addChangeListener(@NotNull TypeScriptConfigsChangedListener var1);

    public boolean hasConfigs();

    @NotNull
    public ModificationTracker getTracker();

    public static class Provider {
        @Nullable
        public static TypeScriptConfigService get(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider", "get"));
            }
            return (TypeScriptConfigService)ServiceManager.getService((Project)project, TypeScriptConfigService.class);
        }

        public static boolean isAccessible(@NotNull Project project, @NotNull VirtualFile scope, @NotNull VirtualFile referencedFile) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider", "isAccessible"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider", "isAccessible"));
            }
            if (referencedFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider", "isAccessible"));
            }
            TypeScriptConfigService service = Provider.get(project);
            if (service == null) {
                return true;
            }
            return service.isAccessible(scope, referencedFile);
        }

        public static boolean isAccessible(@NotNull PsiElement source, @NotNull PsiElement reference) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider", "isAccessible"));
            }
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider", "isAccessible"));
            }
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)source);
            VirtualFile ref = PsiUtilCore.getVirtualFile((PsiElement)reference);
            if (file == null || ref == null) {
                return true;
            }
            return Provider.isAccessible(source.getProject(), file, ref);
        }

        public static boolean hasConfigs(@Nullable Project project) {
            if (!Provider.checkProject(project)) {
                return false;
            }
            TypeScriptConfigService service = Provider.get(project);
            if (service == null) {
                return false;
            }
            return service.hasConfigs();
        }

        @NotNull
        public static Collection<TypeScriptConfig> getConfigInclude(@Nullable Project project, @NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider", "getConfigInclude"));
            }
            if (!Provider.checkProject(project)) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider", "getConfigInclude"));
                }
                return list;
            }
            TypeScriptConfigService service = Provider.get(project);
            if (service == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider", "getConfigInclude"));
                }
                return list;
            }
            Collection<TypeScriptConfig> collection = service.getConfigInclude(file);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider", "getConfigInclude"));
            }
            return collection;
        }

        private static boolean checkProject(@Nullable Project project) {
            return project != null && !project.isDefault() && !project.isDisposed();
        }

        @NotNull
        public static Collection<TypeScriptConfig> getConfigFiles(@Nullable Project project) {
            if (!Provider.checkProject(project)) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider", "getConfigFiles"));
                }
                return list;
            }
            TypeScriptConfigService service = Provider.get(project);
            if (service == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider", "getConfigFiles"));
                }
                return list;
            }
            Collection<TypeScriptConfig> collection = service.getConfigFiles();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider", "getConfigFiles"));
            }
            return collection;
        }

        public static boolean isConfigInclude(@Nullable Project project, @NotNull VirtualFile file, @NotNull TypeScriptConfig config2) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider", "isConfigInclude"));
            }
            if (config2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigService$Provider", "isConfigInclude"));
            }
            if (!Provider.checkProject(project)) {
                return false;
            }
            TypeScriptConfigService service = Provider.get(project);
            if (service == null) {
                return false;
            }
            return service.isConfigInclude(file, config2);
        }

        public static TypeScriptConfig getConfig(Project project, @Nullable VirtualFile file) {
            if (file == null || !Provider.checkProject(project)) {
                return null;
            }
            TypeScriptConfigService service = Provider.get(project);
            if (service == null) {
                return null;
            }
            return service.getConfig(file);
        }
    }
}

