/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.bugs;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class DivideByZeroJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("divide.by.zero.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bugs/DivideByZeroJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bugs/DivideByZeroJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("division.by.zero.error.string", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bugs/DivideByZeroJSInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DivisionByZeroVisitor();
    }

    private static boolean isZero(JSExpression expression) {
        String text = expression.getText();
        return "0".equals(text) || "0x0".equals(text) || "0X0".equals(text) || "0.0".equals(text) || "0L".equals(text) || "0l".equals(text);
    }

    private static class DivisionByZeroVisitor
    extends BaseInspectionVisitor {
        private DivisionByZeroVisitor() {
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/bugs/DivideByZeroJSInspection$DivisionByZeroVisitor", "visitJSBinaryExpression"));
            }
            super.visitJSBinaryExpression(expression);
            JSExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression.getOperationSign();
            if (!JSTokenTypes.DIV.equals(tokenType) && !JSTokenTypes.PERC.equals(tokenType)) {
                return;
            }
            if (!DivideByZeroJSInspection.isZero(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression);
        }

        public void visitJSAssignmentExpression(JSAssignmentExpression expression) {
            super.visitJSAssignmentExpression(expression);
            JSExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression.getOperationSign();
            if (!JSTokenTypes.DIVEQ.equals(tokenType) && !JSTokenTypes.PERCEQ.equals(tokenType)) {
                return;
            }
            if (!DivideByZeroJSInspection.isZero(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression);
        }
    }
}

