/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.codeInsight;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.javascript.testFramework.codeInsight.GenerateActionContext;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.BaseJSTokenTypes;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsGeneratorUtils {
    private JsGeneratorUtils() {
    }

    public static void generateProperty(@NotNull JSObjectLiteralExpression objectLiteralExpression, @NotNull GenerateActionContext context, @NotNull String markedPropertyStr) {
        boolean generateCommaAfter;
        if (objectLiteralExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectLiteralExpression", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "generateProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "generateProperty"));
        }
        if (markedPropertyStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markedPropertyStr", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "generateProperty"));
        }
        PsiElement precedingAnchor = objectLiteralExpression.getFirstChild();
        if (precedingAnchor == null) {
            return;
        }
        int caretOffset = context.getDocumentCaretOffset();
        JSProperty precedingProperty = JsGeneratorUtils.findPrecedingProperty(objectLiteralExpression, caretOffset);
        JSProperty followingProperty = JsGeneratorUtils.findFollowingProperty(objectLiteralExpression, caretOffset);
        boolean generateCommaBefore = false;
        boolean bl = generateCommaAfter = followingProperty != null;
        if (precedingProperty != null) {
            precedingAnchor = precedingProperty;
            PsiElement comma = JsGeneratorUtils.findNextSiblingComma((PsiElement)precedingProperty);
            boolean bl2 = generateCommaBefore = comma == null;
            if (comma != null) {
                precedingAnchor = comma;
            }
        }
        TextRange whitespaceTextRange = JsGeneratorUtils.unionFollowingWhitespaceTextRanges(precedingAnchor);
        JsGeneratorUtils.generateProperty(context, markedPropertyStr, whitespaceTextRange, generateCommaBefore, generateCommaAfter);
    }

    private static void generateProperty(@NotNull GenerateActionContext context, @NotNull String markedPropertyStr, @NotNull TextRange whitespaceTextRange, boolean commaBeforeRequired, boolean commaAfterRequired) {
        int moveCaretToOffset;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "generateProperty"));
        }
        if (markedPropertyStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markedPropertyStr", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "generateProperty"));
        }
        if (whitespaceTextRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whitespaceTextRange", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "generateProperty"));
        }
        int caretOffset = context.getDocumentCaretOffset();
        boolean insideWhitespaceArea = whitespaceTextRange.contains(caretOffset);
        int n = moveCaretToOffset = insideWhitespaceArea ? caretOffset : whitespaceTextRange.getStartOffset();
        if (commaBeforeRequired) {
            JsGeneratorUtils.generateCommaAt(context, whitespaceTextRange.getStartOffset());
            ++moveCaretToOffset;
        }
        context.getCaretModel().moveToOffset(moveCaretToOffset);
        LineRange whitespaceLineRange = JsGeneratorUtils.createLineRangeByTextRange(context, whitespaceTextRange);
        int caretLineNumber = JsGeneratorUtils.getLineNumberAtOffset(context, moveCaretToOffset);
        String leadingNewLine = "";
        if (caretLineNumber == whitespaceLineRange.getStartLine()) {
            leadingNewLine = "\n";
        }
        Template template = JsGeneratorUtils.createDefaultTemplate(leadingNewLine + markedPropertyStr);
        if (commaAfterRequired) {
            template.addTextSegment(",");
        }
        if (whitespaceLineRange.getStartLine() == whitespaceLineRange.getEndLine()) {
            template.addTextSegment("\n");
        }
        context.startTemplate(template);
    }

    private static void generateCommaAt(@NotNull GenerateActionContext context, int offset) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "generateCommaAt"));
        }
        context.getCaretModel().moveToOffset(offset);
        Template template = JsGeneratorUtils.createDefaultTemplate(",");
        context.startTemplate(template);
    }

    @Nullable
    private static JSProperty findPrecedingProperty(@NotNull JSObjectLiteralExpression objectLiteralExpression, int caretOffset) {
        if (objectLiteralExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectLiteralExpression", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "findPrecedingProperty"));
        }
        JSProperty[] properties = JsPsiUtils.getProperties(objectLiteralExpression);
        JSProperty preceding = null;
        for (JSProperty currentProperty : properties) {
            int currentPropertyStartOffset = currentProperty.getTextRange().getStartOffset();
            int currentPropertyEndOffset = currentProperty.getTextRange().getEndOffset();
            if (currentPropertyStartOffset < caretOffset && caretOffset < currentPropertyEndOffset) {
                return currentProperty;
            }
            if (currentPropertyEndOffset > caretOffset || preceding != null && preceding.getTextRange().getEndOffset() >= currentPropertyEndOffset) continue;
            preceding = currentProperty;
        }
        return preceding;
    }

    @Nullable
    private static JSProperty findFollowingProperty(@NotNull JSObjectLiteralExpression objectLiteralExpression, int caretOffset) {
        if (objectLiteralExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectLiteralExpression", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "findFollowingProperty"));
        }
        JSProperty[] properties = JsPsiUtils.getProperties(objectLiteralExpression);
        JSProperty following = null;
        for (JSProperty property : properties) {
            int startOffset = property.getTextRange().getStartOffset();
            if (caretOffset > startOffset || following != null && startOffset >= following.getTextRange().getStartOffset()) continue;
            following = property;
        }
        return following;
    }

    @Nullable
    public static PsiElement findNextSiblingComma(@NotNull PsiElement precedingAnchor) {
        if (precedingAnchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "precedingAnchor", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "findNextSiblingComma"));
        }
        PsiElement next = precedingAnchor.getNextSibling();
        while (next instanceof ASTNode) {
            ASTNode node = (ASTNode)next;
            IElementType elementType = node.getElementType();
            if (elementType == BaseJSTokenTypes.COMMA) {
                return next;
            }
            if (elementType != BaseJSTokenTypes.WHITE_SPACE) break;
            next = next.getNextSibling();
        }
        return null;
    }

    @NotNull
    private static TextRange unionFollowingWhitespaceTextRanges(@NotNull PsiElement element) {
        int startOffset;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "unionFollowingWhitespaceTextRanges"));
        }
        int endOffset = startOffset = element.getTextRange().getEndOffset();
        for (PsiElement e = element.getNextSibling(); e != null && JsPsiUtils.isElementOfType(e, BaseJSTokenTypes.WHITE_SPACE); e = e.getNextSibling()) {
            endOffset = e.getTextRange().getEndOffset();
        }
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "unionFollowingWhitespaceTextRanges"));
        }
        return textRange;
    }

    public static void generateObjectLiteralWithPropertyAsArgument(@NotNull GenerateActionContext context, @NotNull String markedPropertyStr, @NotNull JSArgumentList argumentList, int addAtPosition) {
        PsiElement precedingElement;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "generateObjectLiteralWithPropertyAsArgument"));
        }
        if (markedPropertyStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markedPropertyStr", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "generateObjectLiteralWithPropertyAsArgument"));
        }
        if (argumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "generateObjectLiteralWithPropertyAsArgument"));
        }
        JSExpression[] expressions = JsPsiUtils.getArguments(argumentList);
        if (expressions.length < addAtPosition) {
            return;
        }
        Object object = precedingElement = addAtPosition == 0 ? argumentList.getFirstChild() : expressions[addAtPosition - 1];
        if (precedingElement == null) {
            return;
        }
        PsiElement comma = JsGeneratorUtils.findNextSiblingComma(precedingElement);
        if (comma != null) {
            precedingElement = comma;
        }
        context.getCaretModel().moveToOffset(precedingElement.getTextRange().getEndOffset());
        String leadingPrefix = comma == null && addAtPosition != 0 ? "," : "";
        Template template = JsGeneratorUtils.createDefaultTemplate(leadingPrefix + markedPropertyStr);
        context.startTemplate(template);
    }

    public static int findSuitableOffsetForNewStatement(@NotNull PsiElement psiElement, int caretOffset) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "findSuitableOffsetForNewStatement"));
        }
        for (PsiElement parent = psiElement.getParent(); parent != null && !(parent instanceof JSBlockStatement) && !(parent instanceof PsiFile); parent = parent.getParent()) {
            psiElement = parent;
        }
        if (JsPsiUtils.isElementOfType(psiElement, BaseJSTokenTypes.RBRACE)) {
            return psiElement.getTextRange().getStartOffset();
        }
        TextRange whitespaceTextRange = JsPsiUtils.isElementOfType(psiElement, BaseJSTokenTypes.WHITE_SPACE) ? psiElement.getTextRange() : JsGeneratorUtils.unionFollowingWhitespaceTextRanges(psiElement);
        if (whitespaceTextRange.containsOffset(caretOffset)) {
            return caretOffset;
        }
        return whitespaceTextRange.getStartOffset();
    }

    @NotNull
    public static Template createDefaultTemplate(@Nullable String markedText) {
        TemplateImpl template = new TemplateImpl("", "");
        template.setToIndent(true);
        template.setToReformat(true);
        template.setToShortenLongNames(false);
        template.setInline(false);
        JsGeneratorUtils.fillTemplateWithMarkedText((Template)template, markedText);
        TemplateImpl templateImpl = template;
        if (templateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "createDefaultTemplate"));
        }
        return templateImpl;
    }

    public static void fillTemplateWithMarkedText(@NotNull Template template, @Nullable String markedText) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils", "fillTemplateWithMarkedText"));
        }
        if (markedText == null) {
            return;
        }
        Pattern p = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher m = p.matcher(markedText);
        int startInd = 0;
        do {
            boolean variableFound;
            String plainText = (variableFound = m.find()) ? markedText.substring(startInd, m.start()) : markedText.substring(startInd);
            JsGeneratorUtils.fillTemplateWithPlainText(template, plainText);
            if (variableFound) {
                String variableName = m.group(1);
                template.addVariable(variableName.replaceAll(" ", "_"), (Expression)new ConstantNode(variableName), (Expression)new ConstantNode(variableName), true);
                startInd = m.end();
                continue;
            }
            startInd = markedText.length();
        } while (startInd < markedText.length());
    }

    private static void fillTemplateWithPlainText(Template template, String plaintText) {
        int endInd;
        int startInd = 0;
        do {
            int caretIndex;
            String txt;
            if ((txt = plaintText.substring(startInd, endInd = (caretIndex = plaintText.indexOf(124, startInd)) >= 0 ? caretIndex : plaintText.length())).length() > 0) {
                template.addTextSegment(txt);
            }
            if (caretIndex < 0) continue;
            template.addEndVariable();
        } while ((startInd = endInd + 1) < plaintText.length());
    }

    private static int getLineNumberAtOffset(GenerateActionContext context, int offset) {
        return context.getDocument().getLineNumber(offset);
    }

    private static LineRange createLineRangeByTextRange(GenerateActionContext context, TextRange textRange) {
        return new LineRange(JsGeneratorUtils.getLineNumberAtOffset(context, textRange.getStartOffset()), JsGeneratorUtils.getLineNumberAtOffset(context, textRange.getEndOffset()));
    }

    private static class LineRange {
        private final int myStartLine;
        private final int myEndLine;

        private LineRange(int startLine, int endLine) {
            this.myStartLine = startLine;
            this.myEndLine = endLine;
        }

        public int getStartLine() {
            return this.myStartLine;
        }

        public int getEndLine() {
            return this.myEndLine;
        }
    }
}

