/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.navigation;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.FileUrlProvider;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.testFramework.JsTestFileByTestNameIndex;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTestLocationProvider
implements SMTestLocator {
    private static final String PROTOCOL_ID__TEST_SUITE = "suite";
    private static final String PROTOCOL_ID__TEST = "test";
    private final boolean myTestLocationWithPreferredFilePath;

    public JSTestLocationProvider() {
        this(false);
    }

    public JSTestLocationProvider(boolean testLocationWithPreferredFilePath) {
        this.myTestLocationWithPreferredFilePath = testLocationWithPreferredFilePath;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider", "getLocation"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider", "getLocation"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider", "getLocation"));
        }
        if ("file".equals(protocol)) {
            List list = FileUrlProvider.INSTANCE.getLocation(protocol, path, project, scope);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider", "getLocation"));
            }
            return list;
        }
        Object location = PROTOCOL_ID__TEST_SUITE.equals(protocol) || PROTOCOL_ID__TEST.equals(protocol) ? this.getTestLocation(project, path) : null;
        if (location != null) {
            List<Location> list = Collections.singletonList(location);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider", "getLocation"));
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider", "getLocation"));
        }
        return list;
    }

    @Nullable
    private Location getTestLocation(@NotNull Project project, @NotNull String locationData) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider", "getTestLocation"));
        }
        if (locationData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locationData", "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider", "getTestLocation"));
        }
        List<String> path = EscapeUtils.split(locationData, '.');
        if (path.isEmpty()) {
            return null;
        }
        String testFilePath = null;
        List<String> names = path;
        if (this.myTestLocationWithPreferredFilePath) {
            testFilePath = (String)ContainerUtil.getFirstItem(path);
            names = path.subList(1, path.size());
        }
        if (names.isEmpty()) {
            return null;
        }
        PsiElement element = JSTestLocationProvider.findFqnElement(project, new JsTestFqn(JSTestFileType.JASMINE, names), testFilePath);
        if (element == null) {
            element = JSTestLocationProvider.findFqnElement(project, new JsTestFqn(JSTestFileType.QUNIT, names), testFilePath);
        }
        return element != null ? PsiLocation.fromPsiElement((PsiElement)element) : null;
    }

    @Nullable
    private static PsiElement findFqnElement(@NotNull Project project, @NotNull JsTestFqn testFqn, @Nullable String preferredTestFilePath) {
        PsiElement result;
        VirtualFile testFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider", "findFqnElement"));
        }
        if (testFqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFqn", "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider", "findFqnElement"));
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        VirtualFile virtualFile = testFile = StringUtil.isNotEmpty((String)preferredTestFilePath) ? LocalFileSystem.getInstance().findFileByPath(preferredTestFilePath) : null;
        if (testFile != null && (result = JSTestLocationProvider.doFindFqnElement(project, testFqn, Collections.singletonList(testFile))) != null) {
            return result;
        }
        List<VirtualFile> testFiles = JsTestFileByTestNameIndex.findFiles(testFqn, scope, testFile);
        return JSTestLocationProvider.doFindFqnElement(project, testFqn, testFiles);
    }

    @Nullable
    private static PsiElement doFindFqnElement(@NotNull Project project, @NotNull JsTestFqn testFqn, @NotNull List<VirtualFile> testFiles) {
        block6: {
            block5: {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider", "doFindFqnElement"));
                }
                if (testFqn == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFqn", "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider", "doFindFqnElement"));
                }
                if (testFiles == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFiles", "com/intellij/javascript/testFramework/navigation/JSTestLocationProvider", "doFindFqnElement"));
                }
                if (testFqn.getType() != JSTestFileType.JASMINE) break block5;
                JasmineFileStructureBuilder builder = JasmineFileStructureBuilder.getInstance();
                for (VirtualFile file : testFiles) {
                    JasmineFileStructure jasmineFileStructure;
                    PsiElement element;
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                    if (!(psiFile instanceof JSFile) || (element = (jasmineFileStructure = (JasmineFileStructure)builder.fetchCachedTestFileStructure((JSFile)psiFile)).findPsiElement(testFqn.getNames(), null)) == null || !element.isValid()) continue;
                    return element;
                }
                break block6;
            }
            if (testFqn.getType() != JSTestFileType.QUNIT) break block6;
            QUnitFileStructureBuilder builder = QUnitFileStructureBuilder.getInstance();
            for (VirtualFile file : testFiles) {
                PsiElement element;
                String testMethodName;
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (!(psiFile instanceof JSFile)) continue;
                QUnitFileStructure qunitFileStructure = (QUnitFileStructure)builder.fetchCachedTestFileStructure((JSFile)psiFile);
                String testCaseName = (String)ContainerUtil.getFirstItem(testFqn.getNames());
                String string = testMethodName = testFqn.getNames().size() > 1 ? testFqn.getNames().get(1) : null;
                if (testCaseName == null || (element = qunitFileStructure.findPsiElement(testCaseName, testMethodName)) == null || !element.isValid()) continue;
                return element;
            }
        }
        return null;
    }
}

