/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.Specificity;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CssSelector
extends CssElement {
    public static final CssSelector[] EMPTY_ARRAY = new CssSelector[0];

    @NotNull
    public String getPresentableText();

    public PsiElement[] getElements();

    @NotNull
    public Combinator[] getCombinators();

    @NotNull
    public CssSimpleSelector[] getSimpleSelectors();

    public Specificity getSpecificity();

    public boolean processAmpersandEvaluatedSelectors(@NotNull CssSelector var1, @Nullable Language var2, @NotNull Processor<CssSelector> var3);

    public boolean isAmpersandSelector();

    public boolean isMatch(XmlTag var1, CssResolver var2, @Nullable Map<XmlTag, CssSimpleSelector> var3);

    @Nullable
    public CssRuleset getRuleset();

    public static enum Combinator {
        DESCENDANT(' '),
        CHILD('>'),
        SIBLING('+'),
        FOLLOWING_SIBLING('~'),
        COLUMN('|', "||");

        private final char myIdentifier;
        private final String myPresentation;

        private Combinator(char identifier, String presentation) {
            this.myIdentifier = identifier;
            this.myPresentation = presentation;
        }

        private Combinator(char identifier) {
            this(identifier, null);
        }

        public char getIdentifier() {
            return this.myIdentifier;
        }

        public String getPresentation() {
            return StringUtil.notNullize((String)this.myPresentation, (String)String.valueOf(this.myIdentifier));
        }

        public static Combinator fromIdentifier(char c) {
            for (Combinator combinator : Combinator.values()) {
                if (combinator.myIdentifier != c) continue;
                return combinator;
            }
            throw new IllegalArgumentException("Illegal combinator identifier: " + c);
        }
    }
}

