/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssCompletionContext {
    private final PsiElement myElement;
    private final CssCompletionContext myParent;
    private final boolean myCurrent;

    private CssCompletionContext(@Nullable PsiElement element, @Nullable CssCompletionContext parent, boolean current) {
        this.myElement = element;
        this.myParent = parent;
        this.myCurrent = current;
    }

    public boolean isEmpty() {
        return this.myElement == null && this.myParent == null;
    }

    @Nullable
    public String getElementText() {
        return this.myElement == null ? null : this.myElement.getText().toLowerCase();
    }

    public int getLength() {
        int length = 0;
        for (CssCompletionContext c = this; c != null; c = c.getParent()) {
            length += c.getElement() == null ? 0 : 1;
        }
        return length;
    }

    public boolean isValueBelongs(@NotNull CssPropertyValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/CssCompletionContext", "isValueBelongs"));
        }
        CssCompletionContext parent = this.getParent();
        return value.isValueBelongs(this.getElement()) || parent != null && parent.isValueBelongs(value);
    }

    public static CssCompletionContext createContext(@Nullable PsiElement element, @Nullable CssCompletionContext parent) {
        return CssCompletionContext.createContext(element, parent, false);
    }

    public static CssCompletionContext createContext(@Nullable PsiElement element, @Nullable CssCompletionContext parent, boolean current) {
        return new CssCompletionContext(element, parent, current);
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public CssCompletionContext getParent() {
        return this.myParent;
    }

    public boolean matchesTermType(@Nullable CssTermType type) {
        if (type == null) {
            return true;
        }
        if (this.myElement == null) {
            return false;
        }
        CssTerm cssTerm = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, CssTerm.class, (boolean)false);
        return cssTerm != null && type == cssTerm.getTermType();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (CssCompletionContext c = this; c != null; c = c.getParent()) {
            buffer.insert(0, c.getElementText()).insert(0, ' ');
        }
        return buffer.insert(0, "Context:").toString();
    }

    public boolean isCurrent() {
        return this.myCurrent;
    }
}

