/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.integration.SpringIntegrationBundle;
import com.intellij.spring.integration.inspections.SpringIntegrationInspectionBase;
import com.intellij.spring.integration.model.xml.core.Channel;
import com.intellij.spring.integration.model.xml.core.Poller;
import com.intellij.spring.integration.model.xml.ftp.BaseFtpAdapterType;
import com.intellij.spring.integration.model.xml.http.InboundChannelAdapter;
import com.intellij.spring.integration.model.xml.httpinvoker.SpringIntegrationHttpInvokerDomElement;
import com.intellij.spring.integration.model.xml.jms.OutboundGateway;
import com.intellij.spring.integration.model.xml.mail.ImapIdleChannelAdapter;
import com.intellij.spring.integration.model.xml.sftp.BaseSftpAdapterType;
import com.intellij.spring.integration.model.xml.xml.XpathSelector;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringIntegrationDeprecations21Inspection
extends SpringIntegrationInspectionBase {
    protected SpringModelVisitor createVisitor(DomElementAnnotationHolder holder, @NotNull Beans beans, @Nullable CommonSpringModel model) {
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/integration/inspections/SpringIntegrationDeprecations21Inspection", "createVisitor"));
        }
        final DeprecationVisitor visitor = new DeprecationVisitor(holder);
        return new SpringModelVisitor(){

            protected boolean visitBean(CommonSpringBean bean) {
                if (bean instanceof DomSpringBean) {
                    ((DomSpringBean)bean).accept(visitor);
                }
                return true;
            }
        };
    }

    private static class DeprecationVisitor
    implements DomElementVisitor {
        private final DomElementAnnotationHolder holder;

        public DeprecationVisitor(DomElementAnnotationHolder holder) {
            this.holder = holder;
        }

        public void visitDomElement(DomElement element) {
            this.checkGenericFtp(element);
            this.checkGenericSftp(element);
            if (element instanceof SpringIntegrationHttpInvokerDomElement) {
                this.visitDeprecated(element, "SpringIntegrationDeprecation21Inspection.httpinvoker.removed");
            }
        }

        private void checkGenericFtp(DomElement element) {
            if (element instanceof BaseFtpAdapterType) {
                BaseFtpAdapterType type = (BaseFtpAdapterType)element;
                this.visitDeprecated((DomElement)type.getCacheSessions(), "SpringIntegrationDeprecation21Inspection.cache.sessions");
            }
        }

        private void checkGenericSftp(DomElement element) {
            if (element instanceof BaseSftpAdapterType) {
                BaseSftpAdapterType type = (BaseSftpAdapterType)element;
                this.visitDeprecated((DomElement)type.getCacheSessions(), "SpringIntegrationDeprecation21Inspection.cache.sessions");
            }
        }

        public void visitChannel(Channel channel) {
            this.visitDeprecated((DomElement)channel.getDispatcherAttr(), "SpringIntegrationDeprecation21Inspection.channel.dispatcher.attribute");
        }

        public void visitPoller(Poller poller) {
            this.visitDeprecated(poller.getCronTrigger(), "SpringIntegrationDeprecation21Inspection.cron.trigger");
            this.visitDeprecated(poller.getIntervalTrigger(), "SpringIntegrationDeprecation21Inspection.interval.trigger");
        }

        public void visitHttpInboundChannelAdapter(InboundChannelAdapter inboundChannelAdapter) {
            this.visitDeprecated((DomElement)inboundChannelAdapter.getName(), "SpringIntegrationDeprecation21Inspection.http.inbound.channel.adapter.name");
        }

        public void visitJmsOutboundGateway(OutboundGateway outboundGateway) {
            this.visitDeprecated((DomElement)outboundGateway.getDeliveryMode(), "SpringIntegrationDeprecation21Inspection.jms.outbound.gateway.delivery.mode");
        }

        public void visitImapIdleChannelAdapter(ImapIdleChannelAdapter imapIdleChannelAdapter) {
            this.visitDeprecated((DomElement)imapIdleChannelAdapter.getTaskExecutor(), "SpringIntegrationDeprecation21Inspection.mail.imap.idle.channel.adapter.task.executor");
        }

        public void visitXmlXpathSelector(XpathSelector xpathSelector) {
            this.visitDeprecated(xpathSelector, "SpringIntegrationDeprecation21Inspection.xml.xpath.selector");
        }

        private void visitDeprecated(DomElement element, String messageKey) {
            if (DomUtil.hasXml((DomElement)element)) {
                this.holder.createProblem(element, ProblemHighlightType.LIKE_DEPRECATED, SpringIntegrationBundle.message(messageKey, new Object[0]), null, new LocalQuickFix[0]);
            }
        }
    }
}

