/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.impl.JavaSdkUtil;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;

public class PathUtil {
    public static final String JPS_KOTLIN_HOME_PROPERTY = "jps.kotlin.home";
    public static final String JS_LIB_JAR_NAME = "kotlin-stdlib-js.jar";
    public static final String JS_LIB_10_JAR_NAME = "kotlin-jslib.jar";
    public static final String ALLOPEN_PLUGIN_JAR_NAME = "allopen-compiler-plugin.jar";
    public static final String NOARG_PLUGIN_JAR_NAME = "noarg-compiler-plugin.jar";
    public static final String SAM_WITH_RECEIVER_PLUGIN_JAR_NAME = "sam-with-receiver-compiler-plugin.jar";
    public static final String JS_LIB_SRC_JAR_NAME = "kotlin-stdlib-js-sources.jar";
    public static final String KOTLIN_JAVA_RUNTIME_JAR = "kotlin-runtime.jar";
    public static final String KOTLIN_JAVA_RUNTIME_JRE7_JAR = "kotlin-stdlib-jre7.jar";
    public static final String KOTLIN_JAVA_RUNTIME_JRE8_JAR = "kotlin-stdlib-jre8.jar";
    public static final String KOTLIN_JAVA_RUNTIME_JRE7_SRC_JAR = "kotlin-stdlib-jre7-sources.jar";
    public static final String KOTLIN_JAVA_RUNTIME_JRE8_SRC_JAR = "kotlin-stdlib-jre8-sources.jar";
    public static final String KOTLIN_JAVA_STDLIB_JAR = "kotlin-stdlib.jar";
    public static final String KOTLIN_JAVA_REFLECT_JAR = "kotlin-reflect.jar";
    public static final String KOTLIN_JAVA_SCRIPT_RUNTIME_JAR = "kotlin-script-runtime.jar";
    public static final String KOTLIN_TEST_JAR = "kotlin-test.jar";
    public static final String KOTLIN_TEST_JS_JAR = "kotlin-test-js.jar";
    public static final String KOTLIN_JAVA_STDLIB_SRC_JAR = "kotlin-stdlib-sources.jar";
    public static final String KOTLIN_JAVA_STDLIB_SRC_JAR_OLD = "kotlin-runtime-sources.jar";
    public static final String KOTLIN_REFLECT_SRC_JAR = "kotlin-reflect-sources.jar";
    public static final String KOTLIN_TEST_SRC_JAR = "kotlin-test-sources.jar";
    public static final String KOTLIN_COMPILER_JAR = "kotlin-compiler.jar";
    public static final Pattern KOTLIN_RUNTIME_JAR_PATTERN = Pattern.compile("kotlin-(stdlib|runtime)(-\\d[\\d.]+(-.+)?)?\\.jar");
    public static final Pattern KOTLIN_STDLIB_JS_JAR_PATTERN = Pattern.compile("kotlin-stdlib-js.*\\.jar");
    public static final Pattern KOTLIN_JS_LIBRARY_JAR_PATTERN = Pattern.compile("kotlin-js-library.*\\.jar");
    public static final String HOME_FOLDER_NAME = "kotlinc";
    private static final File NO_PATH = new File("<no_path>");

    private PathUtil() {
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForIdeaPlugin() {
        KotlinPaths kotlinPaths = ApplicationManager.getApplication().isUnitTestMode() ? PathUtil.getKotlinPathsForDistDirectory() : new KotlinPathsFromHomeDir(PathUtil.getCompilerPathForIdeaPlugin());
        if (kotlinPaths == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForIdeaPlugin"));
        }
        return kotlinPaths;
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForJpsPlugin() {
        String jpsKotlinHome = System.getProperty(JPS_KOTLIN_HOME_PROPERTY);
        if (jpsKotlinHome != null) {
            KotlinPathsFromHomeDir kotlinPathsFromHomeDir = new KotlinPathsFromHomeDir(new File(jpsKotlinHome));
            if (kotlinPathsFromHomeDir == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForJpsPlugin"));
            }
            return kotlinPathsFromHomeDir;
        }
        KotlinPathsFromHomeDir kotlinPathsFromHomeDir = new KotlinPathsFromHomeDir(PathUtil.getCompilerPathForJpsPlugin());
        if (kotlinPathsFromHomeDir == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForJpsPlugin"));
        }
        return kotlinPathsFromHomeDir;
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForJpsPluginOrJpsTests() {
        if ("true".equalsIgnoreCase(System.getProperty("kotlin.jps.tests"))) {
            KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForDistDirectory();
            if (kotlinPaths == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForJpsPluginOrJpsTests"));
            }
            return kotlinPaths;
        }
        KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForJpsPlugin();
        if (kotlinPaths == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForJpsPluginOrJpsTests"));
        }
        return kotlinPaths;
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForCompiler() {
        if (!PathUtil.getPathUtilJar().isFile()) {
            KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForDistDirectory();
            if (kotlinPaths == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForCompiler"));
            }
            return kotlinPaths;
        }
        KotlinPathsFromHomeDir kotlinPathsFromHomeDir = new KotlinPathsFromHomeDir(PathUtil.getCompilerPathForCompilerJar());
        if (kotlinPathsFromHomeDir == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForCompiler"));
        }
        return kotlinPathsFromHomeDir;
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForDistDirectory() {
        KotlinPathsFromHomeDir kotlinPathsFromHomeDir = new KotlinPathsFromHomeDir(new File("dist", HOME_FOLDER_NAME));
        if (kotlinPathsFromHomeDir == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getKotlinPathsForDistDirectory"));
        }
        return kotlinPathsFromHomeDir;
    }

    @NotNull
    private static File getCompilerPathForCompilerJar() {
        File jar = PathUtil.getPathUtilJar();
        if (!jar.exists()) {
            File file = NO_PATH;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForCompilerJar"));
            }
            return file;
        }
        if (jar.getName().equals(KOTLIN_COMPILER_JAR)) {
            File lib = jar.getParentFile();
            File file = lib.getParentFile();
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForCompilerJar"));
            }
            return file;
        }
        File file = NO_PATH;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForCompilerJar"));
        }
        return file;
    }

    @NotNull
    private static File getCompilerPathForJpsPlugin() {
        File jar = PathUtil.getPathUtilJar();
        if (!jar.exists()) {
            File file = NO_PATH;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForJpsPlugin"));
            }
            return file;
        }
        if (jar.getName().equals("kotlin-jps-plugin.jar")) {
            File pluginHome = jar.getParentFile().getParentFile().getParentFile();
            File file = new File(pluginHome, HOME_FOLDER_NAME);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForJpsPlugin"));
            }
            return file;
        }
        File file = NO_PATH;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForJpsPlugin"));
        }
        return file;
    }

    @NotNull
    private static File getCompilerPathForIdeaPlugin() {
        File jar = PathUtil.getPathUtilJar();
        if (!jar.exists()) {
            File file = NO_PATH;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForIdeaPlugin"));
            }
            return file;
        }
        if (jar.getName().equals("kotlin-plugin.jar")) {
            File lib = jar.getParentFile();
            File pluginHome = lib.getParentFile();
            File file = new File(pluginHome, HOME_FOLDER_NAME);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForIdeaPlugin"));
            }
            return file;
        }
        File file = NO_PATH;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getCompilerPathForIdeaPlugin"));
        }
        return file;
    }

    @NotNull
    public static File getPathUtilJar() {
        File file = PathUtil.getResourcePathForClass(PathUtil.class);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getPathUtilJar"));
        }
        return file;
    }

    @NotNull
    public static File getResourcePathForClass(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/utils/PathUtil", "getResourcePathForClass"));
        }
        String path = "/" + aClass.getName().replace('.', '/') + ".class";
        String resourceRoot = PathManager.getResourceRoot((Class)aClass, (String)path);
        if (resourceRoot == null) {
            throw new IllegalStateException("Resource not found: " + path);
        }
        File file = new File(resourceRoot).getAbsoluteFile();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getResourcePathForClass"));
        }
        return file;
    }

    @NotNull
    public static List<File> getJdkClassesRootsFromCurrentJre() {
        List<File> list = PathUtil.getJdkClassesRootsFromJre(System.getProperty("java.home"));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getJdkClassesRootsFromCurrentJre"));
        }
        return list;
    }

    @NotNull
    public static List<File> getJdkClassesRootsFromJre(@NotNull String javaHome) {
        if (javaHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaHome", "org/jetbrains/kotlin/utils/PathUtil", "getJdkClassesRootsFromJre"));
        }
        List list = JavaSdkUtil.getJdkClassesRoots((File)new File(javaHome), (boolean)true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getJdkClassesRootsFromJre"));
        }
        return list;
    }

    @NotNull
    public static List<File> getJdkClassesRoots(@NotNull File jdkHome) {
        if (jdkHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkHome", "org/jetbrains/kotlin/utils/PathUtil", "getJdkClassesRoots"));
        }
        List list = JavaSdkUtil.getJdkClassesRoots((File)jdkHome, (boolean)false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/PathUtil", "getJdkClassesRoots"));
        }
        return list;
    }
}

