/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop;

import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.search.MethodSuperSearcher;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.CombinedSpringModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.aop.AopConfig;
import com.intellij.spring.model.xml.aop.AspectjAutoproxy;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.tx.AnnotationDriven;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringAdvisedElementsSearcher
extends AopAdvisedElementsSearcher {
    private final AtomicNotNullLazyValue<Boolean> myCglibProxyType;
    private final Factory<CommonSpringModel> myModelFactory;

    public SpringAdvisedElementsSearcher(@NotNull PsiManager manager, NotNullFactory<CommonSpringModel> modelFactory) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "<init>"));
        }
        super(manager);
        this.myCglibProxyType = new AtomicNotNullLazyValue<Boolean>(){

            @NotNull
            protected Boolean compute() {
                for (XmlSpringModel xmlModel : SpringAdvisedElementsSearcher.findXmlModels(SpringAdvisedElementsSearcher.this.getSpringModel())) {
                    for (LocalXmlModel localXmlModel : xmlModel.getLocalSpringModels()) {
                        DomFileElement root = localXmlModel.getRoot();
                        if (root == null || !SpringAdvisedElementsSearcher.isCglib((DomFileElement<Beans>)root)) continue;
                        Boolean bl = true;
                        if (bl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/aop/SpringAdvisedElementsSearcher$1", "compute"));
                        }
                        return bl;
                    }
                }
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/aop/SpringAdvisedElementsSearcher$1", "compute"));
                }
                return bl;
            }
        };
        this.myModelFactory = modelFactory;
    }

    private static boolean isCglib(DomFileElement<Beans> root) {
        return (Boolean)CachedValuesManager.getManager((Project)root.getManager().getProject()).getCachedValue(root, () -> CachedValueProvider.Result.create((Object)SpringAdvisedElementsSearcher.calcIsCglib(root), (Object[])new Object[]{root}));
    }

    private static boolean calcIsCglib(DomFileElement<Beans> domFileElement) {
        boolean hasAopNamespace = SpringDomUtils.hasNamespace(domFileElement, (String)"Spring AOP namespace key");
        boolean hasTxNamespace = SpringDomUtils.hasNamespace(domFileElement, (String)"Spring TX namespace key");
        if (!hasAopNamespace && !hasTxNamespace) {
            return false;
        }
        DomElement rootElement = domFileElement.getRootElement();
        if (hasAopNamespace && SpringDomUtils.hasElement(domFileElement, AopConfig.class)) {
            for (AopConfig config : DomUtil.getDefinedChildrenOfType((DomElement)rootElement, AopConfig.class, (boolean)true, (boolean)false)) {
                if (!Boolean.TRUE.equals(config.getProxyTargetClass().getValue())) continue;
                return true;
            }
        }
        if (!SpringDomUtils.hasElement(domFileElement, AnnotationDriven.class) && !SpringDomUtils.hasElement(domFileElement, AspectjAutoproxy.class)) {
            return false;
        }
        CommonProcessors.FindProcessor<CommonSpringBean> processor = new CommonProcessors.FindProcessor<CommonSpringBean>(){

            protected boolean accept(CommonSpringBean bean) {
                return bean instanceof AnnotationDriven && Boolean.TRUE.equals(((AnnotationDriven)bean).getProxyTargetClass().getValue()) || bean instanceof AspectjAutoproxy && Boolean.TRUE.equals(((AspectjAutoproxy)bean).getProxyTargetClass().getValue());
            }
        };
        SpringBeanUtils.getInstance().processChildBeans(rootElement, false, (Processor)processor);
        return processor.isFound();
    }

    public boolean isInherentlyAdvisable(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "isInherentlyAdvisable"));
        }
        return SpringAdvisedElementsSearcher.isSpringAopAdvisable(psiClass);
    }

    public boolean isAdvisableInModel(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "isAdvisableInModel"));
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return false;
        }
        return SpringModelSearchers.doesBeanExist((CommonSpringModel)this.getSpringModel(), (PsiClass)psiClass);
    }

    private static boolean isSpringAopAdvisable(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "isSpringAopAdvisable"));
        }
        if (psiClass.isInterface() || psiClass.hasModifierProperty("final")) {
            return false;
        }
        if (SpringAdvisedElementsSearcher.isSpringAopClass(psiClass)) {
            return false;
        }
        return SpringAdvisedElementsSearcher.isAspectjAdvisable((PsiClass)psiClass);
    }

    public LinkedHashSet<PsiClass> collectAdvisedClasses() {
        MyBeanVisitor visitor = new MyBeanVisitor();
        Collection beans = (Collection)ReadAction.compute(() -> this.getSpringModel().getAllCommonBeans());
        for (SpringBeanPointer pointer : beans) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(() -> {
                if (!pointer.isValid()) {
                    return;
                }
                if (pointer instanceof DomSpringBeanPointer) {
                    SpringModelVisitor.visitBean((SpringModelVisitor)visitor, (CommonSpringBean)((DomSpringBeanPointer)pointer).getSpringBean());
                } else {
                    visitor.processBeanClass(pointer.getEffectiveBeanTypes());
                }
            });
        }
        return visitor.result;
    }

    public static List<XmlSpringModel> findXmlModels(CommonSpringModel model) {
        if (model instanceof XmlSpringModel) {
            return Collections.singletonList((XmlSpringModel)model);
        }
        if (model instanceof CombinedSpringModel) {
            return ContainerUtil.findAll((Collection)((CombinedSpringModel)model).getUnderlyingModels(), XmlSpringModel.class);
        }
        return Collections.emptyList();
    }

    private static boolean isSpringAopClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "isSpringAopClass"));
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "lambda$isSpringAopClass$4"));
            }
            boolean result = !InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)true, psiClass1 -> {
                String qname = psiClass1.getQualifiedName();
                return !"org.springframework.aop.Advisor".equals(qname) && !"org.aopalliance.aop.Advice".equals(qname) && !"org.springframework.aop.framework.AopInfrastructureBean".equals(qname);
            });
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    private static boolean hasInterfaces(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "hasInterfaces"));
        }
        return !JamCommonUtil.processSuperClassList((PsiClass)psiClass, (Collection)new THashSet(), psiClass1 -> psiClass1.getInterfaces().length == 0);
    }

    public boolean canBeAdvised(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "canBeAdvised"));
        }
        if (!super.canBeAdvised(method)) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        if (method.hasModifierProperty("final")) {
            return false;
        }
        return !method.hasModifierProperty("private");
    }

    public boolean acceptsBoundMethodHeavy(@NotNull PsiMethod method) {
        PsiClass psiClass;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "acceptsBoundMethodHeavy"));
        }
        if (this.isJdkProxyType() && ((psiClass = method.getContainingClass()) == null || SpringAdvisedElementsSearcher.hasInterfaces(psiClass) && !SpringAdvisedElementsSearcher.isFromInterface(method, psiClass))) {
            return false;
        }
        return super.acceptsBoundMethodHeavy(method);
    }

    public boolean isJdkProxyType() {
        return (Boolean)this.myCglibProxyType.getValue() == false;
    }

    private static boolean isFromInterface(@NotNull PsiMethod method, PsiClass psiClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/aop/SpringAdvisedElementsSearcher", "isFromInterface"));
        }
        return !new MethodSuperSearcher().execute(new SuperMethodsSearch.SearchParameters(method, psiClass, true, false), signature -> {
            PsiClass aClass = signature.getMethod().getContainingClass();
            return aClass == null || !aClass.isInterface();
        });
    }

    public CommonSpringModel getSpringModel() {
        return (CommonSpringModel)this.myModelFactory.create();
    }

    private static class MyBeanVisitor
    extends SpringModelVisitor {
        private final LinkedHashSet<PsiClass> result = ContainerUtilRt.newLinkedHashSet();

        private MyBeanVisitor() {
        }

        protected boolean visitBean(CommonSpringBean bean) {
            ProgressManager.checkCanceled();
            this.processBeanClass(BeanService.getInstance().getEffectiveBeanTypes(bean));
            super.visitBean(bean);
            return true;
        }

        final void processBeanClass(@NotNull PsiType[] effectiveTypes) {
            if (effectiveTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectiveTypes", "com/intellij/spring/aop/SpringAdvisedElementsSearcher$MyBeanVisitor", "processBeanClass"));
            }
            for (PsiType psiType : effectiveTypes) {
                PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)psiType);
                if (psiClass == null || !SpringAdvisedElementsSearcher.isSpringAopAdvisable(psiClass)) continue;
                this.result.add(psiClass);
                this.addAdvisableSupers(psiClass);
            }
        }

        private void addAdvisableSupers(PsiClass beanClass) {
            InheritanceUtil.processSupers((PsiClass)beanClass, (boolean)false, psiClass -> {
                if (SpringAdvisedElementsSearcher.isSpringAopAdvisable(psiClass)) {
                    this.result.add((PsiClass)psiClass);
                }
                return true;
            });
        }
    }
}

