/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.reference.jsp;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.reference.TaglibUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import icons.Struts2Icons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext context) {
        String namespace;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/reference/jsp/ActionReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/struts2/reference/jsp/ActionReferenceProvider", "getReferencesByElement"));
        }
        StrutsManager strutsManager = StrutsManager.getInstance(psiElement.getProject());
        StrutsModel strutsModel = strutsManager.getCombinedModel(psiElement);
        if (strutsModel == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)psiElement;
        String path = xmlAttributeValue.getValue();
        String actionName = TaglibUtil.trimActionPath(path);
        List<Action> actions = strutsModel.findActionsByName(actionName, namespace = ActionReferenceProvider.getNamespace(xmlAttributeValue));
        Action action = actions.isEmpty() ? null : actions.get(0);
        int bangIndex = path.indexOf(33);
        if (bangIndex == -1) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new ActionReference(xmlAttributeValue, action, namespace, strutsModel)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new ActionReference(xmlAttributeValue, action, namespace, strutsModel), new ActionMethodReference(xmlAttributeValue, action, bangIndex)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    @Nullable
    private static String getNamespace(@NotNull XmlAttributeValue xmlAttributeValue) {
        if (xmlAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "com/intellij/struts2/reference/jsp/ActionReferenceProvider", "getNamespace"));
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)xmlAttributeValue, XmlTag.class);
        if (tag == null) {
            return null;
        }
        return tag.getAttributeValue("namespace");
    }

    public static class ActionReference
    extends PsiReferenceBase<XmlAttributeValue>
    implements EmptyResolveMessageProvider {
        private final Action action;
        private final String namespace;
        private final StrutsModel strutsModel;

        private ActionReference(XmlAttributeValue xmlAttributeValue, @Nullable Action action, @Nullable @NonNls String namespace, StrutsModel strutsModel) {
            super((PsiElement)xmlAttributeValue);
            this.action = action;
            this.namespace = namespace;
            this.strutsModel = strutsModel;
        }

        public PsiElement resolve() {
            if (TaglibUtil.isDynamicExpression(((XmlAttributeValue)this.myElement).getValue())) {
                return this.myElement;
            }
            if (this.action == null) {
                return null;
            }
            return this.action.getXmlTag();
        }

        @NotNull
        public Object[] getVariants() {
            List<Action> actionList = this.strutsModel.getActionsForNamespace(this.namespace);
            ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>(actionList.size());
            for (Action action : actionList) {
                String actionPath = action.getName().getStringValue();
                if (actionPath == null) continue;
                variants.add(LookupElementBuilder.create((String)actionPath).withIcon(Struts2Icons.Action).withTypeText(action.getNamespace()));
            }
            Object[] objectArray = ArrayUtil.toObjectArray(variants);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionReferenceProvider$ActionReference", "getVariants"));
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = "Cannot resolve action '" + this.getValue() + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionReferenceProvider$ActionReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }
    }

    private static class ActionMethodReference
    extends PsiReferenceBase<XmlAttributeValue>
    implements EmptyResolveMessageProvider {
        @Nullable
        private final Action action;

        private ActionMethodReference(XmlAttributeValue xmlAttributeValue, @Nullable Action action, int bangIndex) {
            super((PsiElement)xmlAttributeValue);
            this.action = action;
            this.setRangeInElement(TextRange.from((int)(this.getRangeInElement().getStartOffset() + bangIndex + 1), (int)(this.getRangeInElement().getLength() - 1 - bangIndex)));
        }

        public PsiElement resolve() {
            if (this.action == null) {
                return null;
            }
            String methodName = this.getValue();
            return this.action.findActionMethod(methodName);
        }

        @NotNull
        public Object[] getVariants() {
            if (this.action == null) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionReferenceProvider$ActionMethodReference", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)this.action.getActionMethods());
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionReferenceProvider$ActionMethodReference", "getVariants"));
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = "Cannot resolve action method '" + this.getValue() + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionReferenceProvider$ActionMethodReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }
    }
}

