/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.structure;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.xml.XmlStructureViewBuilderProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.structure.StructureViewTreeModel;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.structure.DomStructureViewBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseStructureViewBuilderProvider
implements XmlStructureViewBuilderProvider {
    static final ConstantFunction<DomElement, DomService.StructureViewMode> ALWAYS_SHOW = new ConstantFunction((Object)DomService.StructureViewMode.SHOW);

    BaseStructureViewBuilderProvider() {
    }

    @Nullable
    protected abstract DomFileElement getFileElement(@NotNull XmlFile var1);

    protected abstract Class[] getAlwaysPlus();

    protected abstract Class[] getAlwaysLeaf();

    @Nullable
    public StructureViewBuilder createStructureViewBuilder(final @NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/struts2/structure/BaseStructureViewBuilderProvider", "createStructureViewBuilder"));
        }
        DomFileElement fileElement = this.getFileElement(xmlFile);
        if (fileElement == null) {
            return null;
        }
        return new DomStructureViewBuilder(xmlFile, (Function)ALWAYS_SHOW){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                StructureViewTreeModel structureViewTreeModel = new StructureViewTreeModel(xmlFile, editor, BaseStructureViewBuilderProvider.this.getAlwaysPlus(), BaseStructureViewBuilderProvider.this.getAlwaysLeaf(), (Function<DomElement, DomService.StructureViewMode>)ALWAYS_SHOW);
                if (structureViewTreeModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/structure/BaseStructureViewBuilderProvider$1", "createStructureViewModel"));
                }
                return structureViewTreeModel;
            }
        };
    }
}

