/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea;

import com.google.common.hash.Hashing;
import com.intellij.openapi.module.Module;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogAnonymizerUtil {
    private static final String SALT = Integer.toString(new SecureRandom().nextInt());

    public static boolean isPublicClass(@Nullable String className) {
        if (className == null) {
            return false;
        }
        return (className = className.replace("/", ".")).startsWith("java.") || className.startsWith("javax.") || className.startsWith("com.android.") || className.startsWith("android.") || className.startsWith("com.google.");
    }

    @NotNull
    public static String anonymizeClassName(@Nullable String className) {
        if (className == null) {
            if ("null" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/LogAnonymizerUtil", "anonymizeClassName"));
            }
            return "null";
        }
        String string = LogAnonymizerUtil.isPublicClass(className = className.replace("/", ".")) ? className : "class:" + Hashing.sha256().hashString((CharSequence)(SALT + className), StandardCharsets.UTF_8).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/LogAnonymizerUtil", "anonymizeClassName"));
        }
        return string;
    }

    @NotNull
    public static String anonymize(@Nullable Module module) {
        if (module == null) {
            if ("null" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/LogAnonymizerUtil", "anonymize"));
            }
            return "null";
        }
        if (module.isDisposed()) {
            if ("<disposed>" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/LogAnonymizerUtil", "anonymize"));
            }
            return "<disposed>";
        }
        String string = "module:" + Hashing.sha256().hashString((CharSequence)(SALT + module.getName()), StandardCharsets.UTF_8).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/LogAnonymizerUtil", "anonymize"));
        }
        return string;
    }
}

