/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.diff;

import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.apk.viewer.diff.ApkDiffEntry;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.util.concurrent.ExecutorService;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApkDiffParser {
    private static final ListeningExecutorService ourExecutorService = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
    private final VirtualFile myApkRootOld;
    private final VirtualFile myApkRootNew;
    private ListenableFuture<DefaultMutableTreeNode> myTreeStructure;

    public ApkDiffParser(@NotNull VirtualFile apkRootOld, @NotNull VirtualFile apkRootNew) {
        if (apkRootOld == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkRootOld", "com/android/tools/idea/apk/viewer/diff/ApkDiffParser", "<init>"));
        }
        if (apkRootNew == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkRootNew", "com/android/tools/idea/apk/viewer/diff/ApkDiffParser", "<init>"));
        }
        if (!apkRootOld.getFileSystem().equals((Object)ApkFileSystem.getInstance())) {
            throw new IllegalArgumentException("Invalid Old APK");
        }
        if (!apkRootNew.getFileSystem().equals((Object)ApkFileSystem.getInstance())) {
            throw new IllegalArgumentException("Invalid New APK");
        }
        this.myApkRootOld = apkRootOld;
        this.myApkRootNew = apkRootNew;
    }

    @NotNull
    public synchronized ListenableFuture<DefaultMutableTreeNode> constructTreeStructure() {
        if (this.myTreeStructure == null) {
            this.myTreeStructure = ourExecutorService.submit(() -> ApkDiffParser.createTreeNode(this.myApkRootOld, this.myApkRootNew));
        }
        ListenableFuture<DefaultMutableTreeNode> listenableFuture = this.myTreeStructure;
        if (listenableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/diff/ApkDiffParser", "constructTreeStructure"));
        }
        return listenableFuture;
    }

    @NotNull
    static DefaultMutableTreeNode createTreeNode(@Nullable VirtualFile oldFile, @Nullable VirtualFile newFile) {
        VirtualFile zipRoot;
        String name;
        if (oldFile == null && newFile == null) {
            throw new IllegalArgumentException("Both old and new files are null");
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        long oldSize = 0L;
        long newSize = 0L;
        HashSet childrenInOldFile = new HashSet();
        String string = name = oldFile == null ? newFile.getName() : oldFile.getName();
        if (oldFile != null) {
            if (StringUtil.equals((CharSequence)oldFile.getExtension(), (CharSequence)"zip") && (zipRoot = ApkFileSystem.getInstance().extractAndGetContentRoot(oldFile)) != null) {
                oldFile = zipRoot;
            }
            if (oldFile.isDirectory()) {
                zipRoot = oldFile.getChildren();
                int n = ((VirtualFile)zipRoot).length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile oldChild = zipRoot[i];
                    VirtualFile newChild = newFile == null ? null : newFile.findChild(oldChild.getName());
                    childrenInOldFile.add((Object)oldChild.getName());
                    DefaultMutableTreeNode childNode = ApkDiffParser.createTreeNode(oldChild, newChild);
                    node.add(childNode);
                    ApkDiffEntry entry = (ApkDiffEntry)childNode.getUserObject();
                    oldSize += entry.getOldSize();
                    newSize += entry.getNewSize();
                }
                if (oldFile.getLength() > 0L) {
                    oldSize = oldFile.getLength();
                }
            } else {
                oldSize += oldFile.getLength();
            }
        }
        if (newFile != null) {
            if (StringUtil.equals((CharSequence)newFile.getExtension(), (CharSequence)"zip") && (zipRoot = ApkFileSystem.getInstance().extractAndGetContentRoot(newFile)) != null) {
                newFile = zipRoot;
            }
            if (newFile.isDirectory()) {
                for (VirtualFile newChild : newFile.getChildren()) {
                    if (childrenInOldFile.contains((Object)newChild.getName())) continue;
                    DefaultMutableTreeNode childNode = ApkDiffParser.createTreeNode(null, newChild);
                    node.add(childNode);
                    ApkDiffEntry entry = (ApkDiffEntry)childNode.getUserObject();
                    oldSize += entry.getOldSize();
                    newSize += entry.getNewSize();
                }
                if (newFile.getLength() > 0L) {
                    newSize = newFile.getLength();
                }
            } else {
                newSize += newFile.getLength();
            }
        }
        node.setUserObject(new ApkDiffEntry(name, oldFile, newFile, oldSize, newSize));
        ApkParser.sort(node);
        DefaultMutableTreeNode defaultMutableTreeNode = node;
        if (defaultMutableTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/diff/ApkDiffParser", "createTreeNode"));
        }
        return defaultMutableTreeNode;
    }
}

