/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.ide.common.res2.DataBindingResourceType;
import com.android.tools.idea.databinding.BrUtil;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.ResourceCacheValueProvider;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightField;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightBrClass
extends AndroidLightClassBase {
    private static final String BINDABLE_QUALIFIED_NAME = "android.databinding.Bindable";
    private final AndroidFacet myFacet;
    private CachedValue<PsiField[]> myFieldCache;
    @NotNull
    private String[] myCachedFieldNames;
    private final String myQualifiedName;
    private PsiFile myContainingFile;

    public LightBrClass(@NotNull PsiManager psiManager, final AndroidFacet facet) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/android/tools/idea/databinding/LightBrClass", "<init>"));
        }
        super(psiManager);
        this.myCachedFieldNames = new String[]{"_all"};
        this.myQualifiedName = DataBindingUtil.getBrQualifiedName(facet);
        this.myFacet = facet;
        this.myFieldCache = CachedValuesManager.getManager((Project)facet.getModule().getProject()).createCachedValue((CachedValueProvider)new ResourceCacheValueProvider<PsiField[]>(facet, new ModificationTracker[]{psiManager.getModificationTracker().getJavaStructureModificationTracker()}){

            @Override
            PsiField[] doCompute() {
                Project project = facet.getModule().getProject();
                PsiElementFactory elementFactory = PsiElementFactory.SERVICE.getInstance((Project)project);
                LocalResourceRepository moduleResources = facet.getModuleResources(false);
                if (moduleResources == null) {
                    return this.defaultValue();
                }
                Map<String, DataBindingInfo> dataBindingResourceFiles = moduleResources.getDataBindingResourceFiles();
                if (dataBindingResourceFiles == null) {
                    return this.defaultValue();
                }
                HashSet variableNames = new HashSet();
                for (DataBindingInfo info : dataBindingResourceFiles.values()) {
                    for (PsiDataBindingResourceItem item : info.getItems(DataBindingResourceType.VARIABLE)) {
                        variableNames.add(item.getName());
                    }
                }
                Set bindables = LightBrClass.this.collectVariableNamesFromBindables();
                if (bindables != null) {
                    variableNames.addAll(bindables);
                }
                PsiField[] result = new PsiField[variableNames.size() + 1];
                result[0] = LightBrClass.this.createPsiField(project, elementFactory, "_all");
                int i = 1;
                for (String variable : variableNames) {
                    result[i++] = LightBrClass.this.createPsiField(project, elementFactory, variable);
                }
                LightBrClass.access$202(LightBrClass.this, ArrayUtil.toStringArray((Collection)variableNames));
                return result;
            }

            @Override
            PsiField[] defaultValue() {
                Project project = facet.getModule().getProject();
                return new PsiField[]{LightBrClass.this.createPsiField(project, PsiElementFactory.SERVICE.getInstance((Project)project), "_all")};
            }
        }, false);
    }

    private Set<String> collectVariableNamesFromBindables() {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myFacet.getModule().getProject());
        PsiClass aClass = facade.findClass(BINDABLE_QUALIFIED_NAME, this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(false));
        if (aClass == null) {
            return null;
        }
        Collection psiElements = AnnotatedElementsSearch.searchElements((PsiClass)aClass, (SearchScope)this.myFacet.getModule().getModuleScope(), (Class[])new Class[]{PsiMethod.class, PsiField.class}).findAll();
        return BrUtil.collectIds(psiElements);
    }

    private PsiField createPsiField(Project project, PsiElementFactory factory, String id) {
        PsiField field = factory.createField(id, (PsiType)PsiType.INT);
        PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"public", (boolean)true);
        PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"static", (boolean)true);
        PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
        return new LightBRField(PsiManager.getInstance((Project)project), field, this);
    }

    public String toString() {
        return "BR class for " + (Object)((Object)this.myFacet);
    }

    @Nullable
    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    public String getName() {
        return "BR";
    }

    @NotNull
    public String[] getAllFieldNames() {
        if (this.myCachedFieldNames == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/LightBrClass", "getAllFieldNames"));
        }
        return this.myCachedFieldNames;
    }

    @Nullable
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = (PsiField[])this.myFieldCache.getValue();
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/LightBrClass", "getFields"));
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = this.getFields();
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/LightBrClass", "getAllFields"));
        }
        return psiFieldArray;
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        PsiClass aClass;
        if (this.myContainingFile == null && (aClass = JavaPsiFacade.getInstance((Project)this.myFacet.getModule().getProject()).findClass(DataBindingUtil.getGeneratedPackageName(this.myFacet) + ".R", this.myFacet.getModule().getModuleScope())) != null) {
            this.myContainingFile = aClass.getContainingFile();
        }
        return this.myContainingFile;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return new LightIdentifier(this.getManager(), this.getName());
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiFile containingFile = this.getContainingFile();
        Object object = containingFile == null ? super.getNavigationElement() : containingFile;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/LightBrClass", "getNavigationElement"));
        }
        return object;
    }

    public boolean isValid() {
        return true;
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    static /* synthetic */ String[] access$202(LightBrClass x0, String[] x1) {
        x0.myCachedFieldNames = x1;
        return x1;
    }

    static class LightBRField
    extends LightField
    implements ModificationTracker {
        public LightBRField(@NotNull PsiManager manager, @NotNull PsiField field, @NotNull PsiClass containingClass) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/databinding/LightBrClass$LightBRField", "<init>"));
            }
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/databinding/LightBrClass$LightBRField", "<init>"));
            }
            if (containingClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/android/tools/idea/databinding/LightBrClass$LightBRField", "<init>"));
            }
            super(manager, field, containingClass);
        }

        public long getModificationCount() {
            return 0L;
        }
    }
}

