/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.HashMap;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CrashReport {
    public static final String PRODUCT_ANDROID_STUDIO = "AndroidStudio";
    private static final ImmutableSet<Class<? extends Throwable>> THROWABLE_CLASSES_TO_TRACK_MESSAGES = ImmutableSet.of(ArrayIndexOutOfBoundsException.class, ClassCastException.class, ClassNotFoundException.class, IndexOutOfBoundsException.class);
    @NotNull
    public final String productId;
    @Nullable
    public final String version;
    @Nullable
    public final Map<String, String> productData;
    @NotNull
    private final Type myType;

    private CrashReport(@NotNull String productId, @Nullable String version, @Nullable Map<String, String> productData, @NotNull Type type) {
        if (productId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productId", "com/android/tools/idea/diagnostics/crash/CrashReport", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/diagnostics/crash/CrashReport", "<init>"));
        }
        this.productId = productId;
        this.version = version;
        this.productData = productData;
        this.myType = type;
    }

    public void serialize(@NotNull MultipartEntityBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/diagnostics/crash/CrashReport", "serialize"));
        }
        builder.addTextBody("type", this.myType.toString());
        if (this.productData != null) {
            this.productData.forEach((arg_0, arg_1) -> ((MultipartEntityBuilder)builder).addTextBody(arg_0, arg_1));
        }
        this.serializeTo(builder);
    }

    protected abstract void serializeTo(@NotNull MultipartEntityBuilder var1);

    @NotNull
    public static Throwable getRootCause(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/diagnostics/crash/CrashReport", "getRootCause"));
        }
        int depth = 0;
        while (depth++ < 20) {
            if (t.getCause() == null) {
                Throwable throwable = t;
                if (throwable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport", "getRootCause"));
                }
                return throwable;
            }
            t = t.getCause();
        }
        Throwable throwable = t;
        if (throwable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport", "getRootCause"));
        }
        return throwable;
    }

    @NotNull
    public static String getDescription(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/diagnostics/crash/CrashReport", "getDescription"));
        }
        if (THROWABLE_CLASSES_TO_TRACK_MESSAGES.contains(t.getClass())) {
            String string = ExceptionUtil.getThrowableText((Throwable)t);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport", "getDescription"));
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append(t.getClass().getName());
        sb.append(": <elided>\n");
        for (StackTraceElement el : t.getStackTrace()) {
            sb.append("\tat ");
            sb.append(el);
            sb.append('\n');
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport", "getDescription"));
        }
        return string;
    }

    public static class Builder {
        private String myProductId = "AndroidStudio";
        private String myVersion;
        private Type myType = Type.Exception;
        private String myExceptionInfo = "<unknown>";
        private List<String> myCrashDescriptions;
        private String myThreadDump;
        private String myFileName;
        private Map<String, String> myProductData;

        private Builder() {
        }

        @NotNull
        public Builder setProduct(@NotNull String productId) {
            if (productId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productId", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "setProduct"));
            }
            this.myProductId = productId;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "setProduct"));
            }
            return builder;
        }

        @NotNull
        public Builder setVersion(@NotNull String version) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "setVersion"));
            }
            this.myVersion = version;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "setVersion"));
            }
            return builder;
        }

        @NotNull
        public Builder addProductData(@NotNull Map<String, String> kv) {
            if (kv == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kv", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "addProductData"));
            }
            if (this.myProductData == null) {
                this.myProductData = new HashMap();
            }
            this.myProductData.putAll(kv);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "addProductData"));
            }
            return builder;
        }

        @NotNull
        private Builder setType(@NotNull Type type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "setType"));
            }
            this.myType = type;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "setType"));
            }
            return builder;
        }

        @NotNull
        private Builder setThrowable(@NotNull Throwable t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "setThrowable"));
            }
            this.myExceptionInfo = CrashReport.getDescription(CrashReport.getRootCause(t));
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "setThrowable"));
            }
            return builder;
        }

        @NotNull
        private Builder setDescriptions(@NotNull List<String> descriptions) {
            if (descriptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "setDescriptions"));
            }
            this.myCrashDescriptions = descriptions;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "setDescriptions"));
            }
            return builder;
        }

        @NotNull
        private Builder setThreadDump(@NotNull String fileName, @NotNull String threadDump) {
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "setThreadDump"));
            }
            if (threadDump == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadDump", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "setThreadDump"));
            }
            this.myFileName = fileName;
            this.myThreadDump = threadDump;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "setThreadDump"));
            }
            return builder;
        }

        @NotNull
        public CrashReport build() {
            switch (this.myType) {
                case Crash: {
                    StudioCrashReport studioCrashReport = new StudioCrashReport(this.myProductId, this.myVersion, this.myCrashDescriptions, this.myProductData);
                    if (studioCrashReport == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "build"));
                    }
                    return studioCrashReport;
                }
                case Performance: {
                    StudioPerformanceWatcherReport studioPerformanceWatcherReport = new StudioPerformanceWatcherReport(this.myProductId, this.myVersion, this.myFileName, this.myThreadDump, this.myProductData);
                    if (studioPerformanceWatcherReport == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "build"));
                    }
                    return studioPerformanceWatcherReport;
                }
            }
            ExceptionReport exceptionReport = new ExceptionReport(this.myProductId, this.myVersion, this.myExceptionInfo, this.myProductData);
            if (exceptionReport == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "build"));
            }
            return exceptionReport;
        }

        @NotNull
        public static Builder createForException(@NotNull Throwable t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "createForException"));
            }
            Builder builder = new Builder().setType(Type.Exception).setThrowable(t);
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "createForException"));
            }
            return builder;
        }

        @NotNull
        public static Builder createForCrashes(@NotNull List<String> descriptions) {
            if (descriptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "createForCrashes"));
            }
            Builder builder = new Builder().setType(Type.Crash).setDescriptions(descriptions);
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "createForCrashes"));
            }
            return builder;
        }

        @NotNull
        public static Builder createForPerfReport(@NotNull String fileName, @NotNull String threadDump) {
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "createForPerfReport"));
            }
            if (threadDump == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadDump", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "createForPerfReport"));
            }
            Builder builder = new Builder().setType(Type.Performance).setThreadDump(fileName, threadDump);
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/crash/CrashReport$Builder", "createForPerfReport"));
            }
            return builder;
        }
    }

    private static class StudioPerformanceWatcherReport
    extends CrashReport {
        private final String myFileName;
        private final String myThreadDump;

        private StudioPerformanceWatcherReport(@NotNull String productId, @Nullable String version, @NotNull String fileName, @NotNull String threadDump, @Nullable Map<String, String> productData) {
            if (productId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productId", "com/android/tools/idea/diagnostics/crash/CrashReport$StudioPerformanceWatcherReport", "<init>"));
            }
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/diagnostics/crash/CrashReport$StudioPerformanceWatcherReport", "<init>"));
            }
            if (threadDump == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadDump", "com/android/tools/idea/diagnostics/crash/CrashReport$StudioPerformanceWatcherReport", "<init>"));
            }
            super(productId, version, productData, Type.Performance);
            this.myFileName = fileName;
            this.myThreadDump = threadDump;
        }

        @Override
        protected void serializeTo(@NotNull MultipartEntityBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/diagnostics/crash/CrashReport$StudioPerformanceWatcherReport", "serializeTo"));
            }
            builder.addTextBody(this.myFileName, this.myThreadDump, ContentType.create((String)"text/plain", (Charset)Charsets.UTF_8));
        }
    }

    private static class StudioCrashReport
    extends CrashReport {
        private final List<String> myDescriptions;

        private StudioCrashReport(@NotNull String productId, @Nullable String version, @NotNull List<String> descriptions, @Nullable Map<String, String> productData) {
            if (productId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productId", "com/android/tools/idea/diagnostics/crash/CrashReport$StudioCrashReport", "<init>"));
            }
            if (descriptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/android/tools/idea/diagnostics/crash/CrashReport$StudioCrashReport", "<init>"));
            }
            super(productId, version, productData, Type.Crash);
            this.myDescriptions = descriptions;
        }

        @Override
        protected void serializeTo(@NotNull MultipartEntityBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/diagnostics/crash/CrashReport$StudioCrashReport", "serializeTo"));
            }
            builder.addTextBody("numCrashes", Integer.toString(this.myDescriptions.size()));
            builder.addTextBody("crashDesc", Joiner.on((String)"\n\n").join(this.myDescriptions));
        }
    }

    private static class ExceptionReport
    extends CrashReport {
        @NotNull
        private final String myExceptionInfo;

        private ExceptionReport(@NotNull String productId, @Nullable String version, @NotNull String exceptionInfo, @Nullable Map<String, String> productData) {
            if (productId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "productId", "com/android/tools/idea/diagnostics/crash/CrashReport$ExceptionReport", "<init>"));
            }
            if (exceptionInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionInfo", "com/android/tools/idea/diagnostics/crash/CrashReport$ExceptionReport", "<init>"));
            }
            super(productId, version, productData, Type.Exception);
            this.myExceptionInfo = exceptionInfo;
        }

        @Override
        protected void serializeTo(@NotNull MultipartEntityBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/diagnostics/crash/CrashReport$ExceptionReport", "serializeTo"));
            }
            builder.addTextBody("exception_info", this.myExceptionInfo);
        }
    }

    public static enum Type {
        Crash,
        Exception,
        Performance;

    }
}

