/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.tools.idea.editors.manifest.ManifestPanel;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.model.MergedManifest;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import java.awt.BorderLayout;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestEditor
extends UserDataHolderBase
implements FileEditor {
    private final AndroidFacet myFacet;
    private JPanel myLazyContainer;
    private ManifestPanel myManifestPanel;
    private final VirtualFile mySelectedFile;
    private boolean mySelected;
    private final PsiTreeChangeListener myPsiChangeListener;
    private final BuildVariantView.BuildVariantSelectionChangeListener buildVariantListener;

    ManifestEditor(@NotNull AndroidFacet facet, @NotNull VirtualFile manifestFile) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/editors/manifest/ManifestEditor", "<init>"));
        }
        if (manifestFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFile", "com/android/tools/idea/editors/manifest/ManifestEditor", "<init>"));
        }
        this.myPsiChangeListener = new PsiTreeChangeAdapter(){

            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/manifest/ManifestEditor$1", "propertyChanged"));
                }
                ManifestEditor.this.psiChange(event);
            }

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/manifest/ManifestEditor$1", "childAdded"));
                }
                ManifestEditor.this.psiChange(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/manifest/ManifestEditor$1", "childRemoved"));
                }
                ManifestEditor.this.psiChange(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/manifest/ManifestEditor$1", "childReplaced"));
                }
                ManifestEditor.this.psiChange(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/manifest/ManifestEditor$1", "childMoved"));
                }
                ManifestEditor.this.psiChange(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/manifest/ManifestEditor$1", "childrenChanged"));
                }
                ManifestEditor.this.psiChange(event);
            }
        };
        this.buildVariantListener = new BuildVariantView.BuildVariantSelectionChangeListener(){

            @Override
            public void buildVariantsConfigChanged() {
                ManifestEditor.this.reload();
            }
        };
        this.myFacet = facet;
        this.mySelectedFile = manifestFile;
        this.myLazyContainer = new JPanel(new BorderLayout());
    }

    private void psiChange(PsiTreeChangeEvent event) {
        PsiFile file = event.getFile();
        if (file != null && "AndroidManifest.xml".equals(file.getName())) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManifestEditor.this.reload();
                }
            });
        }
    }

    private void reload() {
        if (this.mySelected) {
            this.myManifestPanel.setManifest(MergedManifest.get(this.myFacet), this.mySelectedFile);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myLazyContainer;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/manifest/ManifestEditor", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("Merged Manifest" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/manifest/ManifestEditor", "getName"));
        }
        return "Merged Manifest";
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/manifest/ManifestEditor", "setState"));
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        this.mySelected = true;
        final Project thisProject = this.myFacet.getModule().getProject();
        if (this.myManifestPanel == null) {
            this.myManifestPanel = new ManifestPanel(this.myFacet);
            this.myLazyContainer.add(this.myManifestPanel);
            GradleSyncState.subscribe(thisProject, new GradleSyncListener.Adapter(){

                @Override
                public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/manifest/ManifestEditor$4", "syncFailed"));
                    }
                    if (errorMessage == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/editors/manifest/ManifestEditor$4", "syncFailed"));
                    }
                    if (thisProject == project) {
                        ManifestEditor.this.reload();
                    }
                }

                @Override
                public void syncSucceeded(@NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/manifest/ManifestEditor$4", "syncSucceeded"));
                    }
                    if (thisProject == project) {
                        ManifestEditor.this.reload();
                    }
                }
            }, (Disposable)this);
        }
        PsiManager.getInstance((Project)thisProject).addPsiTreeChangeListener(this.myPsiChangeListener);
        BuildVariantView.getInstance(thisProject).addListener(this.buildVariantListener);
        this.reload();
    }

    public void deselectNotify() {
        this.mySelected = false;
        Project thisProject = this.myFacet.getModule().getProject();
        PsiManager.getInstance((Project)thisProject).removePsiTreeChangeListener(this.myPsiChangeListener);
        BuildVariantView.getInstance(thisProject).removeListener(this.buildVariantListener);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/manifest/ManifestEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/manifest/ManifestEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }
}

