/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResourceEditor;
import com.android.tools.idea.editors.strings.StringsVirtualFile;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class StringResourceEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final String ID = "string-resource-editor";

    public static boolean canViewTranslations(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/strings/StringResourceEditorProvider", "canViewTranslations"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/strings/StringResourceEditorProvider", "canViewTranslations"));
        }
        if (!file.getName().equals(AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STRING))) {
            return false;
        }
        if (ResourceHelper.getFolderType(file) != ResourceFolderType.VALUES) {
            return false;
        }
        Module m = ProjectFileIndex.SERVICE.getInstance((Project)project).getModuleForFile(file);
        return m != null && AndroidFacet.getInstance(m) != null;
    }

    public static void openEditor(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/strings/StringResourceEditorProvider", "openEditor"));
        }
        StringsVirtualFile vf = StringsVirtualFile.getStringsVirtualFile(module);
        if (vf != null) {
            ApplicationManager.getApplication().invokeLater(() -> StringResourceEditorProvider.lambda$openEditor$0(module, (VirtualFile)vf));
        }
    }

    public static void openEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/strings/StringResourceEditorProvider", "openEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/strings/StringResourceEditorProvider", "openEditor"));
        }
        StringsVirtualFile stringsFile = StringsVirtualFile.getInstance(project, file);
        assert (stringsFile != null);
        ApplicationManager.getApplication().invokeLater(() -> StringResourceEditorProvider.lambda$openEditor$1(project, (VirtualFile)stringsFile));
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/strings/StringResourceEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/strings/StringResourceEditorProvider", "accept"));
        }
        return file instanceof StringsVirtualFile;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/strings/StringResourceEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/strings/StringResourceEditorProvider", "createEditor"));
        }
        StringResourceEditor stringResourceEditor = new StringResourceEditor((StringsVirtualFile)file);
        if (stringResourceEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceEditorProvider", "createEditor"));
        }
        return stringResourceEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceEditorProvider", "getEditorTypeId"));
        }
        return ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringResourceEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }

    private static /* synthetic */ void lambda$openEditor$1(@NotNull Project project, VirtualFile stringsFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/strings/StringResourceEditorProvider", "lambda$openEditor$1"));
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, stringsFile);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    private static /* synthetic */ void lambda$openEditor$0(@NotNull Module module, VirtualFile vf) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/strings/StringResourceEditorProvider", "lambda$openEditor$0"));
        }
        Project project = module.getProject();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, vf);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }
}

