/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.FontUtil;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JTable;

public class StringsCellRenderer
extends ColoredTableCellRenderer {
    private static final SimpleTextAttributes CELL_ERROR_ATTRIBUTES = new SimpleTextAttributes(8, (Color)JBColor.red);

    protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        Font f;
        if (!(value instanceof String)) {
            return;
        }
        String s = (String)value;
        if (StringsCellRenderer.shouldClip(s)) {
            s = StringsCellRenderer.clip(s);
        }
        row = table.convertRowIndexToModel(row);
        column = table.convertColumnIndexToModel(column);
        String problem = ((StringResourceTableModel)table.getModel()).getCellProblem(row, column);
        SimpleTextAttributes attributes = problem == null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : (column == 0 ? SimpleTextAttributes.ERROR_ATTRIBUTES : CELL_ERROR_ATTRIBUTES);
        Font currentFont = table.getFont();
        if (currentFont != (f = FontUtil.getFontAbleToDisplay(s, currentFont))) {
            this.setFont(f);
        }
        this.setToolTipText(problem);
        this.append(s, attributes);
    }

    public static boolean shouldClip(String s) {
        return StringUtil.containsChar((String)s, (char)'\n');
    }

    private static String clip(String str) {
        int end = str.indexOf(10);
        return end < 0 ? str : str.substring(0, end) + "[...]";
    }
}

