/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.lint.checks.ApiLookup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolutionUtils {
    private static final Logger LOG = Logger.getInstance(ResolutionUtils.class);

    private ResolutionUtils() {
    }

    @NotNull
    public static String getStyleResourceUrl(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyleResourceUrl"));
        }
        String string = ResolutionUtils.getResourceUrlFromQualifiedName(qualifiedName, "style");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyleResourceUrl"));
        }
        return string;
    }

    public static String getResourceUrlFromQualifiedName(@NotNull String qualifiedName, @NotNull String type) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/editors/theme/ResolutionUtils", "getResourceUrlFromQualifiedName"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/theme/ResolutionUtils", "getResourceUrlFromQualifiedName"));
        }
        String startChar = "attr".equals(type) ? "?" : "@";
        int colonIndex = qualifiedName.indexOf(58);
        if (colonIndex != -1) {
            String namespace = qualifiedName.substring(0, colonIndex + 1);
            String themeNameWithoutNamespace = StringUtil.trimStart((String)qualifiedName, (String)namespace);
            return startChar + namespace + type + "/" + themeNameWithoutNamespace;
        }
        return startChar + type + "/" + qualifiedName;
    }

    @NotNull
    public static String getQualifiedNameFromResourceUrl(@NotNull String styleResourceUrl) {
        if (styleResourceUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleResourceUrl", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedNameFromResourceUrl"));
        }
        ResourceUrl url = ResourceUrl.parse((String)styleResourceUrl);
        assert (url != null) : styleResourceUrl;
        String string = url.namespace != null ? url.namespace + ':' + url.name : url.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedNameFromResourceUrl"));
        }
        return string;
    }

    @NotNull
    public static String getNameFromQualifiedName(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/editors/theme/ResolutionUtils", "getNameFromQualifiedName"));
        }
        int colonIndex = qualifiedName.indexOf(58);
        String string = colonIndex != -1 ? qualifiedName.substring(colonIndex + 1) : qualifiedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getNameFromQualifiedName"));
        }
        return string;
    }

    @NotNull
    public static String getQualifiedStyleName(@NotNull StyleResourceValue style) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedStyleName"));
        }
        String name = style.getName();
        String string = style.isFramework() ? "android:" + name : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedStyleName"));
        }
        return string;
    }

    @NotNull
    public static String getQualifiedItemName(@NotNull ItemResourceValue item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedItemName"));
        }
        String name = item.getName();
        String string = item.isFrameworkAttr() ? "android:" + name : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedItemName"));
        }
        return string;
    }

    @NotNull
    public static String getQualifiedValue(@NotNull ItemResourceValue item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedValue"));
        }
        ResourceUrl url = ResourceUrl.parse((String)item.getRawXmlValue(), (boolean)item.isFramework());
        String string = url == null ? item.getRawXmlValue() : url.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedValue"));
        }
        return string;
    }

    @Nullable
    private static StyleResourceValue getStyleResourceValue(@NotNull ResourceResolver resolver, @NotNull String qualifiedStyleName) {
        boolean isFrameworkStyle;
        String styleName;
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyleResourceValue"));
        }
        if (qualifiedStyleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedStyleName", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyleResourceValue"));
        }
        assert (!qualifiedStyleName.startsWith("@android:style/"));
        assert (!qualifiedStyleName.startsWith("@style/"));
        if (qualifiedStyleName.startsWith("android:")) {
            styleName = qualifiedStyleName.substring("android:".length());
            isFrameworkStyle = true;
        } else {
            styleName = qualifiedStyleName;
            isFrameworkStyle = false;
        }
        return resolver.getStyle(styleName, isFrameworkStyle);
    }

    @Nullable
    public static ConfiguredThemeEditorStyle getStyle(@NotNull Configuration configuration, @NotNull ResourceResolver resolver, @NotNull String qualifiedStyleName, @Nullable Module module) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyle"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyle"));
        }
        if (qualifiedStyleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedStyleName", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyle"));
        }
        StyleResourceValue style = ResolutionUtils.getStyleResourceValue(resolver, qualifiedStyleName);
        return style == null ? null : new ConfiguredThemeEditorStyle(configuration, style, module);
    }

    @Nullable
    public static ConfiguredThemeEditorStyle getStyle(@NotNull Configuration configuration, @NotNull String qualifiedStyleName, @Nullable Module module) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyle"));
        }
        if (qualifiedStyleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedStyleName", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyle"));
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        return ResolutionUtils.getStyle(configuration, configuration.getResourceResolver(), qualifiedStyleName, module);
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Configuration configuration, @NotNull ItemResourceValue itemResValue) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ResolutionUtils", "getAttributeDefinition"));
        }
        if (itemResValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemResValue", "com/android/tools/idea/editors/theme/ResolutionUtils", "getAttributeDefinition"));
        }
        return ResolutionUtils.getAttributeDefinition(configuration.getModule(), configuration, ResolutionUtils.getQualifiedItemName(itemResValue));
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Module module, @Nullable Configuration configuration, @NotNull String name) {
        AttributeDefinitions definitions;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ResolutionUtils", "getAttributeDefinition"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/ResolutionUtils", "getAttributeDefinition"));
        }
        if (name.startsWith("android:")) {
            IAndroidTarget target;
            if (configuration == null) {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                assert (facet != null);
                target = facet.getConfigurationManager().getDefaultTarget();
            } else {
                target = configuration.getRealTarget();
            }
            assert (target != null);
            AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, module);
            assert (androidTargetData != null);
            definitions = androidTargetData.getAllAttrDefs(module.getProject());
        } else {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null) : String.format("Module %s is not an Android module", module.getName());
            definitions = facet.getLocalResourceManager().getAttributeDefinitions();
        }
        if (definitions == null) {
            return null;
        }
        return definitions.getAttrDefByName(ResolutionUtils.getNameFromQualifiedName(name));
    }

    public static int getOriginalApiLevel(@Nullable String name, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ResolutionUtils", "getOriginalApiLevel"));
        }
        if (name == null) {
            return -1;
        }
        ApiLookup apiLookup = LintIdeClient.getApiLookup(project);
        if (apiLookup == null) {
            LOG.warn("Could not find Lint client for project " + project.getName());
            return -1;
        }
        ResourceUrl resUrl = ResourceUrl.parse((String)name);
        if (resUrl == null) {
            if (!name.startsWith("android:")) {
                return -1;
            }
            return apiLookup.getFieldVersion("android/R$attr", name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN));
        }
        if (!resUrl.framework) {
            return -1;
        }
        return apiLookup.getFieldVersion("android/R$" + resUrl.type, AndroidResourceUtil.getFieldNameByResourceName(resUrl.name));
    }

    @Nullable
    public static String getParentQualifiedName(@NotNull StyleResourceValue style) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/editors/theme/ResolutionUtils", "getParentQualifiedName"));
        }
        String parentName = ResourceResolver.getParentName((StyleResourceValue)style);
        if (parentName == null) {
            return null;
        }
        if (parentName.startsWith("@")) {
            parentName = ResolutionUtils.getQualifiedNameFromResourceUrl(parentName);
        }
        if (style.isFramework() && !parentName.startsWith("android:")) {
            parentName = "android:" + parentName;
        }
        return parentName;
    }

    @NotNull
    public static Collection<ItemResourceValue> getThemeAttributes(@NotNull ResourceResolver resolver, @NotNull String themeUrl) {
        StyleResourceValue theme;
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/editors/theme/ResolutionUtils", "getThemeAttributes"));
        }
        if (themeUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeUrl", "com/android/tools/idea/editors/theme/ResolutionUtils", "getThemeAttributes"));
        }
        HashMap<String, ItemResourceValue> allItems = new HashMap<String, ItemResourceValue>();
        String themeName = ResolutionUtils.getQualifiedNameFromResourceUrl(themeUrl);
        while ((theme = resolver.getStyle(ResolutionUtils.getNameFromQualifiedName(themeName), themeName.startsWith("android:"))) != null) {
            Collection themeItems = theme.getValues();
            for (ItemResourceValue item : themeItems) {
                String itemName = ResolutionUtils.getQualifiedItemName(item);
                if (allItems.containsKey(itemName)) continue;
                allItems.put(itemName, item);
            }
            themeName = ResolutionUtils.getParentQualifiedName(theme);
            if (themeName != null) continue;
        }
        Collection<ItemResourceValue> collection = allItems.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getThemeAttributes"));
        }
        return collection;
    }

    @Nullable
    public static ResourceType getAttrType(@NotNull ItemResourceValue item, @NotNull Configuration configuration) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/ResolutionUtils", "getAttrType"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ResolutionUtils", "getAttrType"));
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        ResourceValue resolvedValue = resolver.resolveResValue((ResourceValue)item);
        ResourceType attrType = resolvedValue.getResourceType();
        if (attrType != null) {
            return attrType;
        }
        AttributeDefinition def = ResolutionUtils.getAttributeDefinition(configuration, item);
        if (def != null) {
            for (AttributeFormat attrFormat : def.getFormats()) {
                attrType = AndroidDomUtil.getResourceType(attrFormat);
                if (attrType == null) continue;
                return attrType;
            }
        }
        return null;
    }

    @NotNull
    public static FolderConfiguration getFolderConfiguration(@NotNull AndroidFacet facet, @NotNull ResourceValue resolvedValue, @NotNull FolderConfiguration configuration) {
        List configurables;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/editors/theme/ResolutionUtils", "getFolderConfiguration"));
        }
        if (resolvedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedValue", "com/android/tools/idea/editors/theme/ResolutionUtils", "getFolderConfiguration"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ResolutionUtils", "getFolderConfiguration"));
        }
        if (resolvedValue.isFramework()) {
            ConfigurationManager configurationManager = facet.getConfigurationManager();
            IAndroidTarget target = configurationManager.getDefaultTarget();
            assert (target != null);
            ResourceRepository resourceRepository = configurationManager.getResolverCache().getFrameworkResources(configuration, target);
            assert (resourceRepository != null);
            ResourceItem resourceItem = resourceRepository.getResourceItem(resolvedValue.getResourceType(), resolvedValue.getName());
            configurables = resourceItem.getSourceFileList();
        } else {
            AppResourceRepository appResourceRepository = facet.getAppResources(true);
            configurables = appResourceRepository.getResourceItem(resolvedValue.getResourceType(), resolvedValue.getName());
        }
        Configurable configurable = configuration.findMatchingConfigurable(configurables);
        assert (configurable != null);
        FolderConfiguration folderConfiguration = configurable.getConfiguration();
        if (folderConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getFolderConfiguration"));
        }
        return folderConfiguration;
    }
}

