/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.datastructs;

import com.android.tools.idea.experimental.codeanalysis.datastructs.Modifier;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGField;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGMethod;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGPartialMethodSignature;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.BlockGraph;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCFGClass
implements PsiAnnotationOwner {
    public static PsiAnnotation[] emptyAnnotationArray = new PsiAnnotation[0];
    public static final PsiCFGClass[] EMPTY_ARRAY = new PsiCFGClass[0];
    private PsiClass mRef;
    private PsiLambdaExpression mLambdaExpressionRef;
    private PsiAnnotation[] annotationArray = emptyAnnotationArray;
    private PsiFile mPsiFileRef;
    private int mModifierbits;
    private boolean mIsInterface = false;
    protected Map<PsiMethod, PsiCFGMethod> mMethodMap;
    protected Map<PsiCFGPartialMethodSignature, PsiCFGMethod> mSignatureMethodMap;
    protected ArrayList<PsiCFGMethod> mMethodList;
    protected Map<String, PsiCFGField> mFieldMap;
    protected boolean mIsAnonlymous;
    protected boolean mIsLambda;
    protected boolean mIsNestedClass;
    protected PsiCFGMethod mNestedClassParentMethod;
    protected BlockGraph mNestedClassParentBlock;
    protected ArrayList<PsiCFGClass> declaredAnonymousClass;
    protected ArrayList<PsiCFGClass> declaredLambda;
    protected String qualifiedClassName;
    protected PsiCFGClass mSuperCFGClass;
    protected Set<PsiCFGClass> mImplementedInterfacesSet;
    protected Set<PsiCFGClass> mDirectSubClasses;
    protected Set<PsiCFGClass> mDirectSubInterfaces;
    protected Map<String, Set<PsiCFGClass>> nestedInnerClassMap;
    protected boolean mLibraryClass;
    protected PsiCFGClass mDirectOverriddenInterface;

    public PsiCFGClass(@Nullable PsiClass origin, @Nullable PsiFile declearingFile) {
        this.mRef = origin;
        this.mPsiFileRef = declearingFile;
        this.parseModifierList();
        this.mIsAnonlymous = false;
        this.mIsLambda = false;
        this.mLibraryClass = false;
        this.mIsNestedClass = false;
        this.mNestedClassParentMethod = null;
        this.qualifiedClassName = origin != null && origin.getQualifiedName() != null ? origin.getQualifiedName() : "";
        this.declaredAnonymousClass = Lists.newArrayList();
        this.declaredLambda = Lists.newArrayList();
        this.mMethodMap = Maps.newHashMap();
        this.mFieldMap = Maps.newHashMap();
        this.mSuperCFGClass = null;
        this.mImplementedInterfacesSet = Sets.newHashSet();
        this.mDirectSubClasses = Sets.newHashSet();
        this.mDirectSubInterfaces = Sets.newHashSet();
        this.mMethodList = Lists.newArrayList();
        this.mSignatureMethodMap = Maps.newHashMap();
        this.nestedInnerClassMap = Maps.newHashMap();
    }

    public void setLibraryClass() {
        this.mLibraryClass = true;
    }

    public boolean isLibraryClass() {
        return this.mLibraryClass;
    }

    @Nullable
    public PsiCFGClass getSuperClass() {
        return this.mSuperCFGClass;
    }

    public void setSuperClass(@NotNull PsiCFGClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "setSuperClass"));
        }
        this.mSuperCFGClass = clazz;
    }

    public void addSubClass(@NotNull PsiCFGClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "addSubClass"));
        }
        this.mDirectSubClasses.add(clazz);
    }

    @NotNull
    public Set<PsiCFGClass> getSubClassSet() {
        Set<PsiCFGClass> set = this.mDirectSubClasses;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "getSubClassSet"));
        }
        return set;
    }

    public void addSubInterface(@NotNull PsiCFGClass interfaze) {
        if (interfaze == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaze", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "addSubInterface"));
        }
        this.mDirectSubClasses.add(interfaze);
    }

    public void addInterface(@NotNull PsiCFGClass interfaze) {
        if (interfaze == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaze", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "addInterface"));
        }
        this.mImplementedInterfacesSet.add(interfaze);
    }

    @NotNull
    public Set<PsiCFGClass> getImplementedInterfaceSet() {
        Set<PsiCFGClass> set = this.mImplementedInterfacesSet;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "getImplementedInterfaceSet"));
        }
        return set;
    }

    @NotNull
    public PsiCFGClass[] getImplementedInterfaceArray() {
        PsiCFGClass[] psiCFGClassArray = this.mImplementedInterfacesSet.toArray(EMPTY_ARRAY);
        if (psiCFGClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "getImplementedInterfaceArray"));
        }
        return psiCFGClassArray;
    }

    @NotNull
    public PsiCFGClass[] getAllSupers() {
        ArrayList supersList = Lists.newArrayList();
        supersList.add(this.mSuperCFGClass);
        supersList.addAll(this.mImplementedInterfacesSet);
        PsiCFGClass[] psiCFGClassArray = supersList.toArray(EMPTY_ARRAY);
        if (psiCFGClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "getAllSupers"));
        }
        return psiCFGClassArray;
    }

    @Nullable
    public PsiLambdaExpression getPsiLambdaRef() {
        return this.mLambdaExpressionRef;
    }

    public void setLambdaRef(@NotNull PsiLambdaExpression lambdaRef) {
        if (lambdaRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaRef", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "setLambdaRef"));
        }
        this.mLambdaExpressionRef = lambdaRef;
        this.mIsLambda = true;
    }

    @Nullable
    public PsiClass getPsiClass() {
        return this.mRef;
    }

    public boolean isPublic() {
        return (this.mModifierbits & 1) != 0;
    }

    public boolean isInterface() {
        return this.mIsInterface;
    }

    public void setIsInterface(boolean isInterface) {
        this.mIsInterface = isInterface;
    }

    @Nullable
    public PsiFile getDeclearingFile() {
        return this.mPsiFileRef;
    }

    public boolean isAnonymous() {
        return this.mIsAnonlymous;
    }

    public void setAnonlymous() {
        this.mIsAnonlymous = true;
    }

    public void setNested() {
        this.mIsNestedClass = true;
    }

    public boolean isNested() {
        return this.mIsNestedClass;
    }

    @Nullable
    public PsiCFGMethod getDeclaringCFGMethod() {
        return this.mNestedClassParentMethod;
    }

    public void setDeclaringCFGMethod(PsiCFGMethod method) {
        this.mNestedClassParentMethod = method;
    }

    public BlockGraph getDeclaringBlock() {
        return this.mNestedClassParentBlock;
    }

    public void setDeclaringBlock(BlockGraph parentBlock) {
        this.mNestedClassParentBlock = parentBlock;
    }

    public String toString() {
        return this.getQualifiedClassName();
    }

    public PsiCFGClass getAnonymousClassDirectParent() {
        return this.mDirectOverriddenInterface;
    }

    public PsiCFGClass addAnonymousClass(PsiCFGClass anonymousClass) {
        int curCount = this.declaredAnonymousClass.size() + 1;
        anonymousClass.qualifiedClassName = this.qualifiedClassName + "$" + curCount;
        this.declaredAnonymousClass.add(anonymousClass);
        return anonymousClass;
    }

    public PsiCFGClass addNestedInnerClass(PsiCFGClass nestedClass, String name) {
        String qualifiedName;
        Set<Object> currentCFGClassSet;
        if (name == null) {
            name = "";
        }
        if (this.nestedInnerClassMap.containsKey(name)) {
            currentCFGClassSet = this.nestedInnerClassMap.get(name);
        } else {
            currentCFGClassSet = Sets.newHashSet();
            this.nestedInnerClassMap.put(name, (Set<PsiCFGClass>)currentCFGClassSet);
        }
        int indexNumber = currentCFGClassSet.size() + 1;
        nestedClass.qualifiedClassName = qualifiedName = String.format("%s.$%d%s", this.qualifiedClassName, indexNumber, name);
        currentCFGClassSet.add(nestedClass);
        return nestedClass;
    }

    public PsiCFGClass addLambda(PsiCFGClass lambdaClass) {
        int curCount = this.declaredLambda.size() + 1;
        lambdaClass.qualifiedClassName = this.qualifiedClassName + "$lambda$" + curCount;
        this.declaredLambda.add(lambdaClass);
        return lambdaClass;
    }

    public void setDirectOverride(PsiCFGClass cfgClass) {
        this.mDirectOverriddenInterface = cfgClass;
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        if (this.mRef.getModifierList() != null) {
            PsiAnnotation[] psiAnnotationArray = this.mRef.getModifierList().getAnnotations();
            if (psiAnnotationArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "getAnnotations"));
            }
            return psiAnnotationArray;
        }
        if (emptyAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "getAnnotations"));
        }
        return emptyAnnotationArray;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        if (this.mRef.getModifierList() != null) {
            PsiAnnotation[] psiAnnotationArray = this.mRef.getModifierList().getApplicableAnnotations();
            if (psiAnnotationArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "getApplicableAnnotations"));
            }
            return psiAnnotationArray;
        }
        if (emptyAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "getApplicableAnnotations"));
        }
        return emptyAnnotationArray;
    }

    @Nullable
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "findAnnotation"));
        }
        if (this.mRef.getModifierList() != null) {
            return this.mRef.getModifierList().findAnnotation(qualifiedName);
        }
        return null;
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "addAnnotation"));
        }
        if (this.mRef.getModifierList() != null) {
            PsiAnnotation psiAnnotation = this.mRef.getModifierList().addAnnotation(qualifiedName);
            if (psiAnnotation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "addAnnotation"));
            }
            return psiAnnotation;
        }
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "addAnnotation"));
        }
        return null;
    }

    private void parseModifierList() {
        if (this.mRef != null) {
            PsiModifierList modList = this.mRef.getModifierList();
            if (modList == null) {
                this.mModifierbits = 2;
            } else {
                Modifier.ParseModifierList(modList);
            }
        }
    }

    @NotNull
    public String getQualifiedClassName() {
        String string = this.qualifiedClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "getQualifiedClassName"));
        }
        return string;
    }

    public void addMethod(@NotNull PsiCFGMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "addMethod"));
        }
        this.mMethodList.add(method);
        PsiMethod methodRef = method.getMethodRef();
        if (methodRef != null) {
            this.mMethodMap.put(methodRef, method);
        }
        this.mSignatureMethodMap.put(method.getSignature(), method);
    }

    public void addField(@NotNull PsiCFGField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "addField"));
        }
        this.mFieldMap.put(field.getPsiFieldRef().getName(), field);
    }

    @Nullable
    public PsiCFGField getField(String name) {
        if (this.mFieldMap.containsKey(name)) {
            return this.mFieldMap.get(name);
        }
        return null;
    }

    @Nullable
    public PsiCFGMethod getMethod(PsiMethod method) {
        if (this.mMethodMap.containsKey(method)) {
            return this.mMethodMap.get(method);
        }
        return null;
    }

    @Nullable
    public PsiCFGMethod getMethod(PsiCFGPartialMethodSignature signature) {
        if (this.mSignatureMethodMap.containsKey(signature)) {
            return this.mSignatureMethodMap.get(signature);
        }
        return null;
    }

    @NotNull
    public PsiCFGMethod[] getAllMethods() {
        PsiCFGMethod[] retArray = this.mMethodList.toArray(PsiCFGMethod.EMPTY_ARRAY);
        if (retArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "getAllMethods"));
        }
        return retArray;
    }

    @NotNull
    public PsiCFGField[] getAllFields() {
        PsiCFGField[] retArray = new PsiCFGField[this.mFieldMap.size()];
        int i = 0;
        for (String key : this.mFieldMap.keySet()) {
            retArray[i++] = this.mFieldMap.get(key);
        }
        if (retArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass", "getAllFields"));
        }
        return retArray;
    }
}

