/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.datastructs;

import com.android.tools.idea.experimental.codeanalysis.datastructs.ClassMember;
import com.android.tools.idea.experimental.codeanalysis.datastructs.Modifier;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGClass;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCFGField
implements ClassMember,
PsiAnnotationOwner {
    protected PsiCFGClass mDeclearingClass;
    protected PsiField mPsiFieldRef;
    protected int modifierBits;

    public PsiCFGField(@NotNull PsiField field, @NotNull PsiCFGClass clazz) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGField", "<init>"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGField", "<init>"));
        }
        this.mDeclearingClass = clazz;
        this.mPsiFieldRef = field;
        this.parseModifiers();
    }

    private void parseModifiers() {
        PsiModifierList modifierList = this.mPsiFieldRef.getModifierList();
        this.modifierBits = Modifier.ParseModifierList(modifierList);
    }

    public PsiField getPsiFieldRef() {
        return this.mPsiFieldRef;
    }

    @Override
    public PsiCFGClass getDeclaringClass() {
        return this.mDeclearingClass;
    }

    @Override
    public boolean isProtected() {
        return (this.modifierBits & 4) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.modifierBits & 2) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.modifierBits & 1) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.modifierBits & 8) != 0;
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{};
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGField", "getAnnotations"));
        }
        return psiAnnotationArray;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{};
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGField", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Nullable
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGField", "findAnnotation"));
        }
        return null;
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGField", "addAnnotation"));
        }
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGField", "addAnnotation"));
        }
        return null;
    }
}

