/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.folding;

import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.folding.AndroidFoldingSettings;
import com.android.tools.idea.folding.InlinedResource;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceFoldingBuilder
extends FoldingBuilderEx {
    private static final String ANDROID_RESOURCE_INT = "android.annotation.ResourceInt";
    private static final boolean FORCE_PROJECT_RESOURCE_LOADING = true;
    private static final boolean ONLY_FOLD_ANNOTATED_METHODS = false;
    private static final boolean UNIT_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    public static final String DIMEN_PREFIX = "@dimen/";
    public static final String INTEGER_PREFIX = "@integer/";

    private static boolean isFoldingEnabled() {
        return AndroidFoldingSettings.getInstance().isCollapseAndroidStrings();
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/folding/ResourceFoldingBuilder", "isCollapsedByDefault"));
        }
        return ResourceFoldingBuilder.isFoldingEnabled();
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        String foldLabel;
        InlinedResource string;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/folding/ResourceFoldingBuilder", "getPlaceholderText"));
        }
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
        if (element != null && (string = ResourceFoldingBuilder.getResolvedString(element)) != InlinedResource.NONE && (foldLabel = string.getResolvedString()) != null) {
            return foldLabel;
        }
        return element != null ? element.getText() : node.getText();
    }

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement element, @NotNull Document document, boolean quick) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/folding/ResourceFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/android/tools/idea/folding/ResourceFoldingBuilder", "buildFoldRegions"));
        }
        if (!(element instanceof PsiJavaFile) && !(element instanceof XmlFile) || quick && !UNIT_TEST_MODE || !ResourceFoldingBuilder.isFoldingEnabled()) {
            if (FoldingDescriptor.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/folding/ResourceFoldingBuilder", "buildFoldRegions"));
            }
            return FoldingDescriptor.EMPTY;
        }
        final ArrayList result = new ArrayList();
        if (element instanceof PsiJavaFile) {
            PsiJavaFile file = (PsiJavaFile)element;
            file.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    InlinedResource inlinedResource = ResourceFoldingBuilder.findJavaExpressionReference(expression);
                    if (inlinedResource != InlinedResource.NONE) {
                        result.add(inlinedResource.getDescriptor());
                    }
                    super.visitReferenceExpression(expression);
                }
            });
        } else {
            XmlFile file = (XmlFile)element;
            file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlAttributeValue(XmlAttributeValue value) {
                    FoldingDescriptor descriptor;
                    InlinedResource inlinedResource = ResourceFoldingBuilder.findXmlValueReference(value);
                    if (inlinedResource != InlinedResource.NONE && (descriptor = inlinedResource.getDescriptor()) != null) {
                        result.add(descriptor);
                    }
                    super.visitXmlAttributeValue(value);
                }
            });
        }
        FoldingDescriptor[] foldingDescriptorArray = result.toArray(new FoldingDescriptor[result.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/folding/ResourceFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    @NotNull
    private static InlinedResource getResolvedString(PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            InlinedResource inlinedResource = ResourceFoldingBuilder.findJavaExpressionReference((PsiReferenceExpression)element);
            if (inlinedResource == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/folding/ResourceFoldingBuilder", "getResolvedString"));
            }
            return inlinedResource;
        }
        if (element instanceof XmlAttributeValue) {
            InlinedResource inlinedResource = ResourceFoldingBuilder.findXmlValueReference((XmlAttributeValue)element);
            if (inlinedResource == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/folding/ResourceFoldingBuilder", "getResolvedString"));
            }
            return inlinedResource;
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)element;
            for (PsiExpression expression : call.getArgumentList().getExpressions()) {
                InlinedResource string;
                if (!(expression instanceof PsiReferenceExpression) || (string = ResourceFoldingBuilder.findJavaExpressionReference((PsiReferenceExpression)expression)) == InlinedResource.NONE) continue;
                InlinedResource inlinedResource = string;
                if (inlinedResource == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/folding/ResourceFoldingBuilder", "getResolvedString"));
                }
                return inlinedResource;
            }
        }
        InlinedResource inlinedResource = InlinedResource.NONE;
        if (inlinedResource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/folding/ResourceFoldingBuilder", "getResolvedString"));
        }
        return inlinedResource;
    }

    @NotNull
    private static InlinedResource findXmlValueReference(XmlAttributeValue element) {
        String value = element.getValue();
        if (value.startsWith("@string/")) {
            String name = value.substring("@string/".length());
            InlinedResource inlinedResource = ResourceFoldingBuilder.createdInlinedResource(ResourceType.STRING, name, (PsiElement)element);
            if (inlinedResource == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/folding/ResourceFoldingBuilder", "findXmlValueReference"));
            }
            return inlinedResource;
        }
        if (value.startsWith(DIMEN_PREFIX)) {
            String name = value.substring(DIMEN_PREFIX.length());
            InlinedResource inlinedResource = ResourceFoldingBuilder.createdInlinedResource(ResourceType.DIMEN, name, (PsiElement)element);
            if (inlinedResource == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/folding/ResourceFoldingBuilder", "findXmlValueReference"));
            }
            return inlinedResource;
        }
        if (value.startsWith(INTEGER_PREFIX)) {
            String name = value.substring(INTEGER_PREFIX.length());
            InlinedResource inlinedResource = ResourceFoldingBuilder.createdInlinedResource(ResourceType.INTEGER, name, (PsiElement)element);
            if (inlinedResource == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/folding/ResourceFoldingBuilder", "findXmlValueReference"));
            }
            return inlinedResource;
        }
        InlinedResource inlinedResource = InlinedResource.NONE;
        if (inlinedResource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/folding/ResourceFoldingBuilder", "findXmlValueReference"));
        }
        return inlinedResource;
    }

    @NotNull
    private static InlinedResource findJavaExpressionReference(PsiReferenceExpression expression) {
        PsiElement call;
        AndroidPsiUtils.ResourceReferenceType referenceType = AndroidPsiUtils.getResourceReferenceType(expression);
        if (referenceType != AndroidPsiUtils.ResourceReferenceType.APP) {
            InlinedResource inlinedResource = InlinedResource.NONE;
            if (inlinedResource == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/folding/ResourceFoldingBuilder", "findJavaExpressionReference"));
            }
            return inlinedResource;
        }
        ResourceType type = AndroidPsiUtils.getResourceType((PsiElement)expression);
        if (type == null || type != ResourceType.STRING && type != ResourceType.DIMEN && type != ResourceType.INTEGER && type != ResourceType.PLURALS) {
            InlinedResource inlinedResource = InlinedResource.NONE;
            if (inlinedResource == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/folding/ResourceFoldingBuilder", "findJavaExpressionReference"));
            }
            return inlinedResource;
        }
        PsiElement parameterList = expression.getParent();
        String name = AndroidPsiUtils.getResourceName((PsiElement)expression);
        if (parameterList instanceof PsiExpressionList && (call = parameterList.getParent()) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)call;
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (methodName != null && (methodName.equals("getString") || methodName.equals("getText") || methodName.equals("getInteger") || methodName.startsWith("getDimension") || methodName.startsWith("getQuantityString"))) {
                ResourceType resourceType = type;
                InlinedResource inlinedResource = ResourceFoldingBuilder.createdInlinedResource(resourceType, name, (PsiElement)callExpression);
                if (inlinedResource == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/folding/ResourceFoldingBuilder", "findJavaExpressionReference"));
                }
                return inlinedResource;
            }
            if (!UNIT_TEST_MODE) {
                // empty if block
            }
        }
        InlinedResource inlinedResource = ResourceFoldingBuilder.createdInlinedResource(type, name, (PsiElement)expression);
        if (inlinedResource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/folding/ResourceFoldingBuilder", "findJavaExpressionReference"));
        }
        return inlinedResource;
    }

    @Nullable
    private static LocalResourceRepository getAppResources(PsiElement element) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        return AppResourceRepository.getAppResources(module, true);
    }

    private static InlinedResource createdInlinedResource(@NotNull ResourceType type, @NotNull String name, @NotNull PsiElement foldElement) {
        ASTNode node;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/folding/ResourceFoldingBuilder", "createdInlinedResource"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/folding/ResourceFoldingBuilder", "createdInlinedResource"));
        }
        if (foldElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElement", "com/android/tools/idea/folding/ResourceFoldingBuilder", "createdInlinedResource"));
        }
        LocalResourceRepository appResources = ResourceFoldingBuilder.getAppResources(foldElement);
        if (appResources != null && appResources.hasResourceItem(type, name) && (node = foldElement.getNode()) != null) {
            TextRange textRange = foldElement.getTextRange();
            HashSet<Object> dependencies = new HashSet<Object>();
            dependencies.add(foldElement);
            FoldingDescriptor descriptor = new FoldingDescriptor(node, textRange, null, dependencies);
            InlinedResource inlinedResource = new InlinedResource(type, name, appResources, descriptor, foldElement);
            dependencies.add(inlinedResource);
            return inlinedResource;
        }
        return InlinedResource.NONE;
    }

    public static boolean allowsResourceType(@NotNull ResourceType type, @Nullable PsiModifierListOwner owner) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/folding/ResourceFoldingBuilder", "allowsResourceType"));
        }
        if (owner == null) {
            return false;
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{ANDROID_RESOURCE_INT});
        Boolean allowed = ResourceFoldingBuilder.allowsResourceType(type, annotation);
        return allowed != null && allowed != false;
    }

    @Nullable
    public static Boolean allowsResourceType(@NotNull ResourceType type, @Nullable PsiAnnotation annotation) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/folding/ResourceFoldingBuilder", "allowsResourceType"));
        }
        if (annotation == null) {
            return null;
        }
        assert (ANDROID_RESOURCE_INT.equals(annotation.getQualifiedName()));
        PsiAnnotationParameterList annotationParameters = annotation.getParameterList();
        for (PsiNameValuePair pair : annotationParameters.getAttributes()) {
            PsiAnnotationMemberValue value = pair.getValue();
            if (value instanceof PsiReferenceExpression) {
                PsiReferenceExpression expression = (PsiReferenceExpression)value;
                return ResourceFoldingBuilder.allowsResourceType(type, expression);
            }
            if (!(value instanceof PsiArrayInitializerMemberValue)) continue;
            PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)value;
            for (PsiAnnotationMemberValue v : mv.getInitializers()) {
                Boolean b;
                if (!(v instanceof PsiReferenceExpression) || (b = ResourceFoldingBuilder.allowsResourceType(type, (PsiReferenceExpression)v)) == null) continue;
                return b;
            }
        }
        return null;
    }

    private static Boolean allowsResourceType(ResourceType type, PsiReferenceExpression v) {
        String name = v.getText();
        if (name.equals("all")) {
            return true;
        }
        if (name.equals("none")) {
            return false;
        }
        return type.getName().equalsIgnoreCase(name);
    }
}

