/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.android.tools.idea.gradle.util.ui.ToolWindowAlikePanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalAndroidModelView {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Tree myTree;

    public InternalAndroidModelView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/InternalAndroidModelView", "<init>"));
        }
        this.myProject = project;
        this.myTree = new Tree();
        GradleSyncState.subscribe(this.myProject, new GradleSyncListener.Adapter(){

            @Override
            public void syncStarted(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/InternalAndroidModelView$1", "syncStarted"));
                }
                InternalAndroidModelView.this.updateContents();
            }

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/InternalAndroidModelView$1", "syncSucceeded"));
                }
                InternalAndroidModelView.this.updateContents();
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/InternalAndroidModelView$1", "syncFailed"));
                }
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/InternalAndroidModelView$1", "syncFailed"));
                }
                InternalAndroidModelView.this.updateContents();
            }

            @Override
            public void syncSkipped(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/InternalAndroidModelView$1", "syncSkipped"));
                }
                InternalAndroidModelView.this.updateContents();
            }
        });
    }

    public static InternalAndroidModelView getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/InternalAndroidModelView", "getInstance"));
        }
        return (InternalAndroidModelView)ServiceManager.getService((Project)project, InternalAndroidModelView.class);
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/android/tools/idea/gradle/InternalAndroidModelView", "createToolWindowContent"));
        }
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        ToolWindowAlikePanel toolWindowPanel = ToolWindowAlikePanel.createTreePanel(this.myProject.getName(), (JTree)this.myTree);
        Content content = contentFactory.createContent((JComponent)toolWindowPanel, "", false);
        toolWindow.getContentManager().addContent(content);
        this.updateContents();
    }

    private void updateContents() {
        this.myTree.setRootVisible(true);
        if (GradleSyncState.getInstance(this.myProject).isSyncInProgress()) {
            this.myTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Gradle project sync in progress ...")));
            return;
        }
        this.myTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Loading ...")));
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(this.myProject.getName());
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                NdkModuleModel ndkModuleModel;
                AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                if (androidModel != null) {
                    DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode(module.getName());
                    AndroidProject androidProject = androidModel.waitForAndGetProxyAndroidProject();
                    this.addProxyObject(moduleNode, androidProject);
                    rootNode.add(moduleNode);
                }
                if ((ndkModuleModel = NdkModuleModel.get(module)) == null) continue;
                String nodeName = androidModel == null ? module.getName() : module.getName() + " (native)";
                DefaultMutableTreeNode nativeModuleNode = new DefaultMutableTreeNode(nodeName);
                NativeAndroidProject nativeAndroidProject = ndkModuleModel.waitForAndGetProxyAndroidProject();
                this.addProxyObject(nativeModuleNode, nativeAndroidProject);
                rootNode.add(nativeModuleNode);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
                renderer.setOpenIcon(AllIcons.Nodes.NewFolder);
                renderer.setClosedIcon(AllIcons.Nodes.NewFolder);
                renderer.setLeafIcon(AllIcons.ObjectBrowser.ShowModules);
                this.myTree.setCellRenderer((TreeCellRenderer)renderer);
                DefaultTreeModel model = new DefaultTreeModel(rootNode);
                this.myTree.setRootVisible(false);
                this.myTree.setModel((TreeModel)model);
            });
        });
    }

    void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/InternalAndroidModelView", "addProxyObject"));
        }
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/android/tools/idea/gradle/InternalAndroidModelView", "addProxyObject"));
        }
        this.addProxyObject(node, obj, false);
    }

    private void addProxyObject(@NotNull DefaultMutableTreeNode node, @NotNull Object obj, boolean useDerivedNodeName) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/InternalAndroidModelView", "addProxyObject"));
        }
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/android/tools/idea/gradle/InternalAndroidModelView", "addProxyObject"));
        }
        assert (ProxyUtil.isAndroidModelProxyObject(obj));
        String name = null;
        for (Map.Entry<String, Object> entry : ProxyUtil.getAndroidModelProxyValues(obj).entrySet()) {
            String property = entry.getKey();
            property = property.substring(0, property.lastIndexOf(40));
            property = property.substring(property.lastIndexOf(46) + 1, property.length());
            property = StringUtil.trimStart((String)property, (String)"get");
            Object value = entry.getValue();
            if (value != null && property.equals("Name")) {
                name = value.toString();
            }
            this.addPropertyNode(node, property, value);
        }
        if (useDerivedNodeName && name != null) {
            node.setUserObject(name);
        }
    }

    private void addPropertyNode(@NotNull DefaultMutableTreeNode node, @NotNull String property, @Nullable Object value) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/InternalAndroidModelView", "addPropertyNode"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/InternalAndroidModelView", "addPropertyNode"));
        }
        DefaultMutableTreeNode propertyNode = new DefaultMutableTreeNode(property);
        if (value != null && ProxyUtil.isAndroidModelProxyObject(value)) {
            this.addProxyObject(propertyNode, value, property.isEmpty());
        } else if (value instanceof Collection && !((Collection)value).isEmpty()) {
            for (Object obj : (Collection)value) {
                this.addPropertyNode(propertyNode, "", obj);
            }
        } else if (value instanceof Map && !((Map)value).isEmpty()) {
            Map map = (Map)value;
            for (Object key : map.keySet()) {
                this.addPropertyNode(propertyNode, key.toString(), map.get(key));
            }
        } else if (value instanceof ProxyUtil.InvocationErrorValue) {
            Throwable exception = ((ProxyUtil.InvocationErrorValue)value).exception;
            propertyNode.setUserObject(InternalAndroidModelView.getNodeValue(property, "Error: " + exception.getClass().getName()));
        } else {
            propertyNode.setUserObject(InternalAndroidModelView.getNodeValue(property, this.getStringForValue(value)));
        }
        InternalAndroidModelView.addToNode(node, propertyNode);
    }

    @NotNull
    private String getStringForValue(@Nullable Object value) {
        if (value != null && value instanceof File) {
            String filePath = ((File)value).getPath();
            String basePath = this.myProject.getBasePath();
            if (basePath != null) {
                if (!(basePath = FileUtil.toSystemDependentName((String)basePath)).endsWith(File.separator)) {
                    basePath = basePath + File.separator;
                }
                if (filePath.startsWith(basePath)) {
                    String string = filePath.substring(basePath.length());
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/InternalAndroidModelView", "getStringForValue"));
                    }
                    return string;
                }
            }
        }
        String string = value == null ? "null" : value.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/InternalAndroidModelView", "getStringForValue"));
        }
        return string;
    }

    @NotNull
    private static String getNodeValue(@NotNull String property, @NotNull String value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/InternalAndroidModelView", "getNodeValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/InternalAndroidModelView", "getNodeValue"));
        }
        String string = property.isEmpty() ? value : property + " -> " + value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/InternalAndroidModelView", "getNodeValue"));
        }
        return string;
    }

    private static void addToNode(@NotNull DefaultMutableTreeNode parent, @NotNull DefaultMutableTreeNode newChild) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/InternalAndroidModelView", "addToNode"));
        }
        if (newChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "com/android/tools/idea/gradle/InternalAndroidModelView", "addToNode"));
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultMutableTreeNode existingChild = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (InternalAndroidModelView.compareTo(existingChild, newChild) < 0) continue;
            parent.insert(newChild, i);
            return;
        }
        parent.add(newChild);
    }

    private static int compareTo(@NotNull DefaultMutableTreeNode node1, @NotNull DefaultMutableTreeNode node2) {
        if (node1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node1", "com/android/tools/idea/gradle/InternalAndroidModelView", "compareTo"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node2", "com/android/tools/idea/gradle/InternalAndroidModelView", "compareTo"));
        }
        if (node1.isLeaf() && !node2.isLeaf()) {
            return -1;
        }
        if (!node1.isLeaf() && node2.isLeaf()) {
            return 1;
        }
        return node1.getUserObject().toString().compareTo(node2.getUserObject().toString());
    }
}

