/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.model.GradleFileModel;
import com.android.tools.idea.gradle.dsl.model.GradlePropertiesModel;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.model.build.BuildScriptModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.model.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.model.java.JavaModel;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleValue;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GradleBuildModel
extends GradleFileModel {
    @NonNls
    private static final String PLUGIN = "plugin";
    @NotNull
    private List<GradleDslExpressionMap> myToBeAppliedPlugins;

    @Nullable
    public static GradleBuildModel get(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "get"));
        }
        VirtualFile file = GradleUtil.getGradleBuildFile(Projects.getBaseDirPath(project));
        return file != null ? GradleBuildModel.parseBuildFile(file, project, project.getName()) : null;
    }

    @Nullable
    public static GradleBuildModel get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "get"));
        }
        VirtualFile file = GradleUtil.getGradleBuildFile(module);
        return file != null ? GradleBuildModel.parseBuildFile(file, module.getProject(), module.getName()) : null;
    }

    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        GradleBuildModel gradleBuildModel = GradleBuildModel.parseBuildFile(file, project, "<Unknown>");
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        return gradleBuildModel;
    }

    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        GradleBuildDslFile buildDslFile = new GradleBuildDslFile(file, project, moduleName);
        GradleBuildModel.populateWithParentModuleSubProjectsProperties(buildDslFile);
        GradleBuildModel.populateSiblingDslFileWithGradlePropertiesFile(buildDslFile);
        buildDslFile.parse();
        GradleBuildModel gradleBuildModel = new GradleBuildModel(buildDslFile);
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "parseBuildFile"));
        }
        return gradleBuildModel;
    }

    private static void populateWithParentModuleSubProjectsProperties(@NotNull GradleBuildDslFile buildDslFile) {
        if (buildDslFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDslFile", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "populateWithParentModuleSubProjectsProperties"));
        }
        GradleSettingsModel gradleSettingsModel = GradleSettingsModel.get(buildDslFile.getProject());
        if (gradleSettingsModel == null) {
            return;
        }
        String modulePath = gradleSettingsModel.moduleWithDirectory(buildDslFile.getDirectoryPath());
        if (modulePath == null) {
            return;
        }
        GradleBuildModel parentModuleModel = gradleSettingsModel.getParentModuleModel(modulePath);
        if (parentModuleModel == null) {
            return;
        }
        GradleDslFile parentModuleDslFile = parentModuleModel.myGradleDslFile;
        buildDslFile.setParentModuleDslFile(parentModuleDslFile);
        SubProjectsDslElement subProjectsDslElement = parentModuleDslFile.getPropertyElement("subprojects", SubProjectsDslElement.class);
        if (subProjectsDslElement == null) {
            return;
        }
        buildDslFile.setParsedElement("subprojects", subProjectsDslElement);
        for (Map.Entry<String, GradleDslElement> entry : subProjectsDslElement.getPropertyElements().entrySet()) {
            buildDslFile.setParsedElement(entry.getKey(), entry.getValue());
        }
    }

    private static void populateSiblingDslFileWithGradlePropertiesFile(@NotNull GradleBuildDslFile buildDslFile) {
        if (buildDslFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDslFile", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "populateSiblingDslFileWithGradlePropertiesFile"));
        }
        File propertiesFilePath = new File(buildDslFile.getDirectoryPath(), "gradle.properties");
        VirtualFile propertiesFile = VfsUtil.findFileByIoFile((File)propertiesFilePath, (boolean)true);
        if (propertiesFile == null) {
            return;
        }
        GradlePropertiesModel propertiesModel = GradlePropertiesModel.parsePropertiesFile(propertiesFile, buildDslFile.getProject(), buildDslFile.getName());
        if (propertiesModel == null) {
            return;
        }
        GradleDslFile propertiesDslFile = propertiesModel.myGradleDslFile;
        buildDslFile.setSiblingDslFile(propertiesDslFile);
        propertiesDslFile.setSiblingDslFile(buildDslFile);
    }

    private GradleBuildModel(@NotNull GradleBuildDslFile buildDslFile) {
        if (buildDslFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDslFile", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "<init>"));
        }
        super(buildDslFile);
        this.myToBeAppliedPlugins = new ArrayList<GradleDslExpressionMap>();
    }

    @NotNull
    public List<GradleNotNullValue<String>> appliedPlugins() {
        ApplyDslElement applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class);
        if (applyDslElement == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "appliedPlugins"));
            }
            return immutableList;
        }
        List<GradleNotNullValue<String>> listProperty = applyDslElement.getListProperty(PLUGIN, String.class);
        if (listProperty == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "appliedPlugins"));
            }
            return immutableList;
        }
        ArrayList<GradleNotNullValue<String>> plugins = new ArrayList<GradleNotNullValue<String>>();
        HashSet pluginValues = new HashSet();
        for (GradleNotNullValue<String> plugin : listProperty) {
            if (!pluginValues.add(plugin.value())) continue;
            plugins.add(plugin);
        }
        for (GradleDslExpressionMap toBeAppliedPlugin : this.myToBeAppliedPlugins) {
            GradleNullableValue<String> plugin = toBeAppliedPlugin.getLiteralProperty(PLUGIN, String.class);
            assert (plugin instanceof GradleNotNullValue);
            if (!pluginValues.add(plugin.value())) continue;
            plugins.add((GradleNotNullValue)plugin);
        }
        ArrayList<GradleNotNullValue<String>> arrayList = plugins;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "appliedPlugins"));
        }
        return arrayList;
    }

    @NotNull
    public GradleBuildModel applyPlugin(@NotNull String plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PLUGIN, "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "applyPlugin"));
        }
        if (GradleValue.getValues(this.appliedPlugins()).contains(plugin.trim())) {
            GradleBuildModel gradleBuildModel = this;
            if (gradleBuildModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "applyPlugin"));
            }
            return gradleBuildModel;
        }
        GradleDslExpressionMap applyMap = new GradleDslExpressionMap(this.myGradleDslFile, "apply");
        applyMap.addNewLiteral(PLUGIN, plugin.trim());
        this.myToBeAppliedPlugins.add(applyMap);
        GradleBuildModel gradleBuildModel = this;
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "applyPlugin"));
        }
        return gradleBuildModel;
    }

    @NotNull
    public GradleBuildModel removePlugin(@NotNull String plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PLUGIN, "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "removePlugin"));
        }
        plugin = plugin.trim();
        ApplyDslElement applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class);
        if (applyDslElement == null) {
            GradleBuildModel gradleBuildModel = this;
            if (gradleBuildModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "removePlugin"));
            }
            return gradleBuildModel;
        }
        ArrayList<GradleDslExpressionMap> toBeRemovedPlugins = new ArrayList<GradleDslExpressionMap>();
        for (GradleDslExpressionMap applyMap : this.myToBeAppliedPlugins) {
            if (!plugin.equals(applyMap.getLiteralProperty(PLUGIN, String.class).value())) continue;
            toBeRemovedPlugins.add(applyMap);
        }
        this.myToBeAppliedPlugins.removeAll(toBeRemovedPlugins);
        while (GradleValue.getValues(applyDslElement.getListProperty(PLUGIN, String.class)).contains(plugin)) {
            applyDslElement.removeFromExpressionList(PLUGIN, plugin);
        }
        GradleBuildModel gradleBuildModel = this;
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "removePlugin"));
        }
        return gradleBuildModel;
    }

    @Nullable
    public AndroidModel android() {
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.find(this.myGradleDslFile.getProject());
        if (androidPluginInfo != null && androidPluginInfo.isExperimental()) {
            return null;
        }
        AndroidDslElement androidDslElement = this.myGradleDslFile.getPropertyElement("android", AndroidDslElement.class);
        if (androidDslElement == null) {
            androidDslElement = new AndroidDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("android", androidDslElement);
        }
        return new AndroidModel(androidDslElement);
    }

    @NotNull
    public BuildScriptModel buildscript() {
        BuildScriptDslElement buildScriptDslElement = this.myGradleDslFile.getPropertyElement("buildscript", BuildScriptDslElement.class);
        if (buildScriptDslElement == null) {
            buildScriptDslElement = new BuildScriptDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("buildscript", buildScriptDslElement);
        }
        BuildScriptModel buildScriptModel = new BuildScriptModel(buildScriptDslElement);
        if (buildScriptModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "buildscript"));
        }
        return buildScriptModel;
    }

    public DependenciesModel dependencies() {
        DependenciesDslElement dependenciesDslElement = this.myGradleDslFile.getPropertyElement("dependencies", DependenciesDslElement.class);
        if (dependenciesDslElement == null) {
            dependenciesDslElement = new DependenciesDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("dependencies", dependenciesDslElement);
        }
        return new DependenciesModel(dependenciesDslElement);
    }

    @NotNull
    public ExtModel ext() {
        ExtDslElement extDslElement = this.myGradleDslFile.getPropertyElement("ext", ExtDslElement.class);
        if (extDslElement == null) {
            extDslElement = new ExtDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("ext", extDslElement);
        }
        ExtModel extModel = new ExtModel(extDslElement);
        if (extModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "ext"));
        }
        return extModel;
    }

    @NotNull
    public JavaModel java() {
        JavaDslElement javaDslElement = this.myGradleDslFile.getPropertyElement("java", JavaDslElement.class);
        if (javaDslElement == null) {
            javaDslElement = new JavaDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("java", javaDslElement);
        }
        JavaModel javaModel = new JavaModel(javaDslElement);
        if (javaModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "java"));
        }
        return javaModel;
    }

    @NotNull
    public RepositoriesModel repositories() {
        RepositoriesDslElement repositoriesDslElement = this.myGradleDslFile.getPropertyElement("repositories", RepositoriesDslElement.class);
        if (repositoriesDslElement == null) {
            repositoriesDslElement = new RepositoriesDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("repositories", repositoriesDslElement);
        }
        RepositoriesModel repositoriesModel = new RepositoriesModel(repositoriesDslElement);
        if (repositoriesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel", "repositories"));
        }
        return repositoriesModel;
    }

    @Override
    public void resetState() {
        this.myToBeAppliedPlugins.clear();
        super.resetState();
    }

    @Override
    public void applyChanges() {
        for (GradleDslExpressionMap applyMap : this.myToBeAppliedPlugins) {
            applyMap.create();
            applyMap.applyChanges();
            this.myGradleDslFile.addParsedElement("apply", applyMap);
        }
        this.myToBeAppliedPlugins.clear();
        super.applyChanges();
    }

    private static class GradleBuildDslFile
    extends GradleDslFile {
        private GradleBuildDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "<init>"));
            }
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "<init>"));
            }
            super(file, project, moduleName);
        }

        @Override
        public void reparse() {
            super.reparse();
        }

        @Override
        protected void parse(@NotNull GroovyFile psiFile) {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "parse"));
            }
            psiFile.acceptChildren((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

                public void visitMethodCallExpression(GrMethodCallExpression e) {
                    this.process((GroovyPsiElement)e);
                }

                public void visitAssignmentExpression(GrAssignmentExpression e) {
                    this.process((GroovyPsiElement)e);
                }

                public void visitApplicationStatement(GrApplicationStatement e) {
                    this.process((GroovyPsiElement)e);
                }

                void process(GroovyPsiElement e) {
                    GradleDslParser.parse(e, this);
                }
            }));
        }

        @Override
        public void addParsedElement(@NotNull String property, @NotNull GradleDslElement element) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "addParsedElement"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "addParsedElement"));
            }
            if ("apply".equals(property) && element instanceof GradleDslExpressionMap) {
                ApplyDslElement applyDslElement = this.getPropertyElement("apply", ApplyDslElement.class);
                if (applyDslElement == null) {
                    applyDslElement = new ApplyDslElement(this);
                    super.addParsedElement("apply", applyDslElement);
                }
                for (Map.Entry<String, GradleDslElement> entry : ((GradleDslExpressionMap)element).getPropertyElements().entrySet()) {
                    applyDslElement.addParsedElement(entry.getKey(), entry.getValue());
                }
                return;
            }
            super.addParsedElement(property, element);
        }

        @Override
        public void setParsedElement(@NotNull String property, @NotNull GradleDslElement element) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "setParsedElement"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/model/GradleBuildModel$GradleBuildDslFile", "setParsedElement"));
            }
            if (("sourceCompatibility".equals(property) || "targetCompatibility".equals(property)) && (element instanceof GradleDslLiteral || element instanceof GradleDslReference)) {
                JavaDslElement javaDslElement = this.getPropertyElement("java", JavaDslElement.class);
                if (javaDslElement == null) {
                    javaDslElement = new JavaDslElement(this);
                    super.setParsedElement("java", javaDslElement);
                }
                javaDslElement.setParsedElement(property, element);
                return;
            }
            super.setParsedElement(property, element);
        }

        @Override
        protected void reset() {
            super.reset();
        }

        @Override
        protected void apply() {
            super.apply();
        }
    }
}

