/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.android.AbstractFlavorTypeDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.utils.Pair;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFlavorTypeModel
extends GradleDslBlockModel {
    @NonNls
    private static final String CONSUMER_PROGUARD_FILES = "consumerProguardFiles";
    @NonNls
    private static final String MANIFEST_PLACEHOLDERS = "manifestPlaceholders";
    @NonNls
    private static final String MULTI_DEX_ENABLED = "multiDexEnabled";
    @NonNls
    private static final String PROGUARD_FILES = "proguardFiles";
    @NonNls
    private static final String RES_VALUE = "resValue";
    @NonNls
    private static final String USE_JACK = "useJack";

    public AbstractFlavorTypeModel(@NotNull AbstractFlavorTypeDslElement dslElement) {
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "<init>"));
        }
        super(dslElement);
    }

    @NotNull
    public String name() {
        String string = this.myDslElement.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "name"));
        }
        return string;
    }

    @Nullable
    public List<GradleNotNullValue<String>> consumerProguardFiles() {
        return this.myDslElement.getListProperty(CONSUMER_PROGUARD_FILES, String.class);
    }

    @NotNull
    public AbstractFlavorTypeModel addConsumerProguardFile(@NotNull String consumerProguardFile) {
        if (consumerProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumerProguardFile", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "addConsumerProguardFile"));
        }
        this.myDslElement.addToNewLiteralList(CONSUMER_PROGUARD_FILES, consumerProguardFile);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "addConsumerProguardFile"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel removeConsumerProguardFile(@NotNull String consumerProguardFile) {
        if (consumerProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumerProguardFile", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeConsumerProguardFile"));
        }
        this.myDslElement.removeFromExpressionList(CONSUMER_PROGUARD_FILES, consumerProguardFile);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeConsumerProguardFile"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel removeAllConsumerProguardFiles() {
        this.myDslElement.removeProperty(CONSUMER_PROGUARD_FILES);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeAllConsumerProguardFiles"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel replaceConsumerProguardFile(@NotNull String oldConsumerProguardFile, @NotNull String newConsumerProguardFile) {
        if (oldConsumerProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldConsumerProguardFile", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "replaceConsumerProguardFile"));
        }
        if (newConsumerProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newConsumerProguardFile", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "replaceConsumerProguardFile"));
        }
        this.myDslElement.replaceInExpressionList(CONSUMER_PROGUARD_FILES, oldConsumerProguardFile, newConsumerProguardFile);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "replaceConsumerProguardFile"));
        }
        return abstractFlavorTypeModel;
    }

    @Nullable
    public Map<String, GradleNotNullValue<Object>> manifestPlaceholders() {
        return this.myDslElement.getMapProperty(MANIFEST_PLACEHOLDERS, Object.class);
    }

    @NotNull
    public AbstractFlavorTypeModel setManifestPlaceholder(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "setManifestPlaceholder"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "setManifestPlaceholder"));
        }
        this.myDslElement.setInNewLiteralMap(MANIFEST_PLACEHOLDERS, name, value);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "setManifestPlaceholder"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel setManifestPlaceholder(@NotNull String name, int value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "setManifestPlaceholder"));
        }
        this.myDslElement.setInNewLiteralMap(MANIFEST_PLACEHOLDERS, name, value);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "setManifestPlaceholder"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel setManifestPlaceholder(@NotNull String name, boolean value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "setManifestPlaceholder"));
        }
        this.myDslElement.setInNewLiteralMap(MANIFEST_PLACEHOLDERS, name, value);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "setManifestPlaceholder"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel removeManifestPlaceholder(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeManifestPlaceholder"));
        }
        this.myDslElement.removeFromExpressionMap(MANIFEST_PLACEHOLDERS, name);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeManifestPlaceholder"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel removeAllManifestPlaceholders() {
        this.myDslElement.removeProperty(MANIFEST_PLACEHOLDERS);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeAllManifestPlaceholders"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public GradleNullableValue<Boolean> multiDexEnabled() {
        GradleNullableValue<Boolean> gradleNullableValue = this.myDslElement.getLiteralProperty(MULTI_DEX_ENABLED, Boolean.class);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", MULTI_DEX_ENABLED));
        }
        return gradleNullableValue;
    }

    @NotNull
    public AbstractFlavorTypeModel setMultiDexEnabled(boolean multiDexEnabled) {
        this.myDslElement.setNewLiteral(MULTI_DEX_ENABLED, multiDexEnabled);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "setMultiDexEnabled"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel removeMultiDexEnabled() {
        this.myDslElement.removeProperty(MULTI_DEX_ENABLED);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeMultiDexEnabled"));
        }
        return abstractFlavorTypeModel;
    }

    @Nullable
    public List<GradleNotNullValue<String>> proguardFiles() {
        return this.myDslElement.getListProperty(PROGUARD_FILES, String.class);
    }

    @NotNull
    public AbstractFlavorTypeModel addProguardFile(@NotNull String proguardFile) {
        if (proguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proguardFile", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "addProguardFile"));
        }
        this.myDslElement.addToNewLiteralList(PROGUARD_FILES, proguardFile);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "addProguardFile"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel removeProguardFile(@NotNull String proguardFile) {
        if (proguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proguardFile", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeProguardFile"));
        }
        this.myDslElement.removeFromExpressionList(PROGUARD_FILES, proguardFile);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeProguardFile"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel removeAllProguardFiles() {
        this.myDslElement.removeProperty(PROGUARD_FILES);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeAllProguardFiles"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel replaceProguardFile(@NotNull String oldProguardFile, @NotNull String newProguardFile) {
        if (oldProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldProguardFile", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "replaceProguardFile"));
        }
        if (newProguardFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newProguardFile", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "replaceProguardFile"));
        }
        this.myDslElement.replaceInExpressionList(PROGUARD_FILES, oldProguardFile, newProguardFile);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "replaceProguardFile"));
        }
        return abstractFlavorTypeModel;
    }

    @Nullable
    protected List<Pair<GradleDslExpressionList, TypeNameValueElement>> getTypeNameValueElements(@NotNull String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementName", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "getTypeNameValueElements"));
        }
        GradleDslElementList typeNameValueElements = this.myDslElement.getPropertyElement(elementName, GradleDslElementList.class);
        if (typeNameValueElements == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (GradleDslElement typeNameValue : typeNameValueElements.getElements()) {
            GradleDslExpressionList listElement;
            List<GradleNotNullValue<String>> values;
            if (!(typeNameValue instanceof GradleDslExpressionList) || (values = (listElement = (GradleDslExpressionList)typeNameValue).getValues(String.class)).size() != 3) continue;
            result.add(Pair.of((Object)listElement, (Object)new TypeNameValueElement(elementName, values.get(0).value(), values.get(1).value(), values.get(2).value())));
        }
        return result;
    }

    @Nullable
    public List<GradleNotNullValue<ResValue>> resValues() {
        List<Pair<GradleDslExpressionList, TypeNameValueElement>> typeNameValueElements = this.getTypeNameValueElements(RES_VALUE);
        if (typeNameValueElements == null) {
            return null;
        }
        ArrayList resValues = Lists.newArrayListWithCapacity((int)typeNameValueElements.size());
        for (Pair<GradleDslExpressionList, TypeNameValueElement> elementPair : typeNameValueElements) {
            GradleDslExpressionList listElement = (GradleDslExpressionList)elementPair.getFirst();
            TypeNameValueElement typeNameValueElement = (TypeNameValueElement)elementPair.getSecond();
            resValues.add(new GradleNotNullValue<ResValue>(listElement, new ResValue(typeNameValueElement.type(), typeNameValueElement.name(), typeNameValueElement.value())));
        }
        return resValues;
    }

    @NotNull
    protected AbstractFlavorTypeModel addTypeNameValueElement(@NotNull TypeNameValueElement typeNameValueElement) {
        if (typeNameValueElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeNameValueElement", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "addTypeNameValueElement"));
        }
        GradleDslElementList elementList = this.myDslElement.getPropertyElement(typeNameValueElement.myElementName, GradleDslElementList.class);
        if (elementList == null) {
            elementList = new GradleDslElementList(this.myDslElement, typeNameValueElement.myElementName);
            this.myDslElement.setNewElement(typeNameValueElement.myElementName, elementList);
        }
        elementList.addNewElement(typeNameValueElement.toLiteralListElement(this.myDslElement));
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "addTypeNameValueElement"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel addResValue(@NotNull ResValue resValue) {
        if (resValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", RES_VALUE, "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "addResValue"));
        }
        AbstractFlavorTypeModel abstractFlavorTypeModel = this.addTypeNameValueElement(resValue);
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "addResValue"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    protected AbstractFlavorTypeModel removeTypeNameValueElement(@NotNull TypeNameValueElement typeNameValueElement) {
        if (typeNameValueElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeNameValueElement", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeTypeNameValueElement"));
        }
        GradleDslElementList elementList = this.myDslElement.getPropertyElement(typeNameValueElement.myElementName, GradleDslElementList.class);
        if (elementList != null) {
            for (GradleDslExpressionList element : elementList.getElements(GradleDslExpressionList.class)) {
                List<GradleNotNullValue<String>> values = element.getValues(String.class);
                if (values.size() != 3 || !typeNameValueElement.type().equals(values.get(0).value()) || !typeNameValueElement.name().equals(values.get(1).value()) || !typeNameValueElement.value().equals(values.get(2).value())) continue;
                elementList.removeElement(element);
            }
        }
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeTypeNameValueElement"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel removeResValue(@NotNull ResValue resValue) {
        if (resValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", RES_VALUE, "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeResValue"));
        }
        AbstractFlavorTypeModel abstractFlavorTypeModel = this.removeTypeNameValueElement(resValue);
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeResValue"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel removeAllResValues() {
        this.myDslElement.removeProperty(RES_VALUE);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeAllResValues"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    protected AbstractFlavorTypeModel replaceTypeNameValueElement(@NotNull TypeNameValueElement oldElement, @NotNull TypeNameValueElement newElement) {
        GradleDslElementList elementList;
        if (oldElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldElement", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "replaceTypeNameValueElement"));
        }
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "replaceTypeNameValueElement"));
        }
        if (oldElement.myElementName.equals(newElement.myElementName) && (elementList = this.myDslElement.getPropertyElement(oldElement.myElementName, GradleDslElementList.class)) != null) {
            for (GradleDslExpressionList element : elementList.getElements(GradleDslExpressionList.class)) {
                List<GradleDslExpression> gradleDslLiterals = element.getExpressions();
                if (gradleDslLiterals.size() != 3 || !oldElement.type().equals(gradleDslLiterals.get(0).getValue()) || !oldElement.name().equals(gradleDslLiterals.get(1).getValue()) || !oldElement.value().equals(gradleDslLiterals.get(2).getValue())) continue;
                gradleDslLiterals.get(0).setValue(newElement.type());
                gradleDslLiterals.get(1).setValue(newElement.name());
                gradleDslLiterals.get(2).setValue(newElement.value());
            }
        }
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "replaceTypeNameValueElement"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel replaceResValue(@NotNull ResValue oldResValue, @NotNull ResValue newResValue) {
        if (oldResValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldResValue", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "replaceResValue"));
        }
        if (newResValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newResValue", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "replaceResValue"));
        }
        AbstractFlavorTypeModel abstractFlavorTypeModel = this.replaceTypeNameValueElement(oldResValue, newResValue);
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "replaceResValue"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public GradleNullableValue<Boolean> useJack() {
        GradleNullableValue<Boolean> gradleNullableValue = this.myDslElement.getLiteralProperty(USE_JACK, Boolean.class);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", USE_JACK));
        }
        return gradleNullableValue;
    }

    @NotNull
    public AbstractFlavorTypeModel setUseJack(boolean useJack) {
        this.myDslElement.setNewLiteral(USE_JACK, useJack);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "setUseJack"));
        }
        return abstractFlavorTypeModel;
    }

    @NotNull
    public AbstractFlavorTypeModel removeUseJack() {
        this.myDslElement.removeProperty(USE_JACK);
        AbstractFlavorTypeModel abstractFlavorTypeModel = this;
        if (abstractFlavorTypeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel", "removeUseJack"));
        }
        return abstractFlavorTypeModel;
    }

    public static final class ResValue
    extends TypeNameValueElement {
        public ResValue(@NotNull String type, @NotNull String name, @NotNull String value) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel$ResValue", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel$ResValue", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel$ResValue", "<init>"));
            }
            super(AbstractFlavorTypeModel.RES_VALUE, type, name, value);
        }
    }

    public static class TypeNameValueElement {
        @NotNull
        private final String myElementName;
        @NotNull
        private final String myType;
        @NotNull
        private final String myName;
        @NotNull
        private final String myValue;

        public TypeNameValueElement(@NotNull String elementName, @NotNull String type, @NotNull String name, @NotNull String value) {
            if (elementName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementName", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel$TypeNameValueElement", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel$TypeNameValueElement", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel$TypeNameValueElement", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel$TypeNameValueElement", "<init>"));
            }
            this.myElementName = elementName;
            this.myType = type;
            this.myName = name;
            this.myValue = value;
        }

        @NotNull
        public String type() {
            String string = this.myType;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel$TypeNameValueElement", "type"));
            }
            return string;
        }

        @NotNull
        public String name() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel$TypeNameValueElement", "name"));
            }
            return string;
        }

        @NotNull
        public String value() {
            String string = this.myValue;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel$TypeNameValueElement", "value"));
            }
            return string;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myType, this.myName, this.myValue});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TypeNameValueElement)) {
                return false;
            }
            TypeNameValueElement other = (TypeNameValueElement)o;
            return this.myElementName.equals(other.myElementName) && this.myType.equals(other.myType) && this.myName.equals(other.myName) && this.myValue.equals(other.myValue);
        }

        public String toString() {
            return String.format("Type: %1$s, Name: %2$s, Value: %3$s", this.myType, this.myName, this.myValue);
        }

        @NotNull
        protected GradleDslExpressionList toLiteralListElement(@NotNull GradleDslElement parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel$TypeNameValueElement", "toLiteralListElement"));
            }
            GradleDslLiteral typeElement = new GradleDslLiteral(parent, this.myElementName);
            typeElement.setValue(this.myType);
            GradleDslLiteral nameElement = new GradleDslLiteral(parent, this.myElementName);
            nameElement.setValue(this.myName);
            GradleDslLiteral valueElement = new GradleDslLiteral(parent, this.myElementName);
            valueElement.setValue(this.myValue);
            GradleDslExpressionList gradleDslExpressionList = new GradleDslExpressionList(parent, this.myElementName);
            gradleDslExpressionList.addNewExpression(typeElement);
            gradleDslExpressionList.addNewExpression(nameElement);
            gradleDslExpressionList.addNewExpression(valueElement);
            GradleDslExpressionList gradleDslExpressionList2 = gradleDslExpressionList;
            if (gradleDslExpressionList2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AbstractFlavorTypeModel$TypeNameValueElement", "toLiteralListElement"));
            }
            return gradleDslExpressionList2;
        }
    }
}

