/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyConfigurationModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependencyConfigurationDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;

public abstract class ArtifactDependencyModel
extends DependencyModel {
    @Nullable
    private DependencyConfigurationDslElement myConfigurationElement;

    public ArtifactDependencyModel(@Nullable DependencyConfigurationDslElement configurationElement) {
        this.myConfigurationElement = configurationElement;
    }

    @NotNull
    public abstract GradleNotNullValue<String> compactNotation();

    @NotNull
    public abstract GradleNotNullValue<String> name();

    @NotNull
    public abstract GradleNullableValue<String> group();

    @NotNull
    public abstract GradleNullableValue<String> version();

    public abstract void setVersion(@NotNull String var1);

    @NotNull
    public abstract GradleNullableValue<String> classifier();

    @NotNull
    public abstract GradleNullableValue<String> extension();

    @Nullable
    public DependencyConfigurationModel configuration() {
        if (this.myConfigurationElement == null) {
            return null;
        }
        return new DependencyConfigurationModel(this.myConfigurationElement);
    }

    @NotNull
    static List<ArtifactDependencyModel> create(@NotNull GradleDslElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "create"));
        }
        List<ArtifactDependencyModel> list = ArtifactDependencyModel.create(element, null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "create"));
        }
        return list;
    }

    @NotNull
    static List<ArtifactDependencyModel> create(@NotNull GradleDslElement element, @Nullable DependencyConfigurationDslElement configurationElement) {
        GradleDslClosure closureElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "create"));
        }
        if (configurationElement == null && (closureElement = element.getClosureElement()) instanceof DependencyConfigurationDslElement) {
            configurationElement = (DependencyConfigurationDslElement)closureElement;
        }
        ArrayList results = Lists.newArrayList();
        assert (element instanceof GradleDslExpression || element instanceof GradleDslExpressionMap);
        if (element instanceof GradleDslExpressionMap) {
            MapNotation mapNotation = MapNotation.create((GradleDslExpressionMap)element, configurationElement);
            if (mapNotation != null) {
                results.add(mapNotation);
            }
        } else if (element instanceof GradleDslMethodCall) {
            String name = element.getName();
            if (!("project".equals(name) || "fileTree".equals(name) || "files".equals(name))) {
                for (GradleDslElement argument : ((GradleDslMethodCall)element).getArguments()) {
                    results.addAll(ArtifactDependencyModel.create(argument, configurationElement));
                }
            }
        } else {
            CompactNotation compactNotation = CompactNotation.create((GradleDslExpression)element, configurationElement);
            if (compactNotation != null) {
                results.add(compactNotation);
            }
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "create"));
        }
        return arrayList;
    }

    static void createAndAddToList(@NotNull GradleDslElementList list, @NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, @NotNull List<ArtifactDependencySpec> excludes) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "createAndAddToList"));
        }
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "createAndAddToList"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "createAndAddToList"));
        }
        if (excludes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludes", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "createAndAddToList"));
        }
        GradleDslLiteral literal = new GradleDslLiteral(list, configurationName);
        literal.setValue(dependency.compactNotation());
        if (!excludes.isEmpty()) {
            GrClosableBlock configBlock = ArtifactDependencyModel.buildExcludesBlock(excludes, list.getDslFile().getProject());
            literal.setConfigBlock(configBlock);
        }
        list.addNewElement(literal);
    }

    private static GrClosableBlock buildExcludesBlock(@NotNull List<ArtifactDependencySpec> excludes, @NotNull Project project) {
        if (excludes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludes", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "buildExcludesBlock"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "buildExcludesBlock"));
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        GrClosableBlock block = factory.createClosureFromText("{\n}");
        for (ArtifactDependencySpec spec : excludes) {
            String text = String.format("exclude group: '%s', module: '%s'", spec.group, spec.name);
            block.addBefore((PsiElement)factory.createStatementFromText((CharSequence)text), block.getLastChild());
            PsiElement lineTerminator = factory.createLineTerminator(1);
            block.addBefore(lineTerminator, block.getLastChild());
        }
        return block;
    }

    private static class CompactNotation
    extends ArtifactDependencyModel {
        @NotNull
        private GradleDslExpression myDslExpression;
        @NotNull
        private ArtifactDependencySpec mySpec;

        @Nullable
        static CompactNotation create(GradleDslExpression dslExpression, DependencyConfigurationDslElement configurationElement) {
            String value = dslExpression.getValue(String.class);
            if (value == null) {
                return null;
            }
            ArtifactDependencySpec spec = ArtifactDependencySpec.create(value);
            if (spec == null) {
                return null;
            }
            return new CompactNotation(dslExpression, spec, configurationElement);
        }

        private CompactNotation(@NotNull GradleDslExpression dslExpression, @NotNull ArtifactDependencySpec spec, @Nullable DependencyConfigurationDslElement configurationElement) {
            if (dslExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslExpression", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$CompactNotation", "<init>"));
            }
            if (spec == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$CompactNotation", "<init>"));
            }
            super(configurationElement);
            this.myDslExpression = dslExpression;
            this.mySpec = spec;
        }

        @Override
        @NotNull
        public GradleNotNullValue<String> compactNotation() {
            GradleNotNullValue<String> gradleNotNullValue = new GradleNotNullValue<String>(this.myDslExpression, this.mySpec.compactNotation());
            if (gradleNotNullValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$CompactNotation", "compactNotation"));
            }
            return gradleNotNullValue;
        }

        @Override
        @NotNull
        public GradleNotNullValue<String> name() {
            GradleNotNullValue<String> gradleNotNullValue = new GradleNotNullValue<String>(this.myDslExpression, this.mySpec.name);
            if (gradleNotNullValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$CompactNotation", "name"));
            }
            return gradleNotNullValue;
        }

        @Override
        @NotNull
        public GradleNullableValue<String> group() {
            GradleNullableValue<String> gradleNullableValue = new GradleNullableValue<String>(this.myDslExpression, this.mySpec.group);
            if (gradleNullableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$CompactNotation", "group"));
            }
            return gradleNullableValue;
        }

        @Override
        @NotNull
        public GradleNullableValue<String> version() {
            GradleNullableValue<String> gradleNullableValue = new GradleNullableValue<String>(this.myDslExpression, this.mySpec.version);
            if (gradleNullableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$CompactNotation", "version"));
            }
            return gradleNullableValue;
        }

        @Override
        public void setVersion(@NotNull String version) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$CompactNotation", "setVersion"));
            }
            this.mySpec.version = version;
            this.myDslExpression.setValue(this.mySpec.toString());
        }

        @Override
        @NotNull
        public GradleNullableValue<String> classifier() {
            GradleNullableValue<String> gradleNullableValue = new GradleNullableValue<String>(this.myDslExpression, this.mySpec.classifier);
            if (gradleNullableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$CompactNotation", "classifier"));
            }
            return gradleNullableValue;
        }

        @Override
        @NotNull
        public GradleNullableValue<String> extension() {
            GradleNullableValue<String> gradleNullableValue = new GradleNullableValue<String>(this.myDslExpression, this.mySpec.extension);
            if (gradleNullableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$CompactNotation", "extension"));
            }
            return gradleNullableValue;
        }

        @Override
        @NotNull
        protected GradleDslElement getDslElement() {
            GradleDslExpression gradleDslExpression = this.myDslExpression;
            if (gradleDslExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$CompactNotation", "getDslElement"));
            }
            return gradleDslExpression;
        }
    }

    private static class MapNotation
    extends ArtifactDependencyModel {
        @NotNull
        private GradleDslExpressionMap myDslElement;

        @Nullable
        static MapNotation create(GradleDslExpressionMap dslElement, DependencyConfigurationDslElement configurationElement) {
            if (dslElement.getLiteralProperty("name", String.class).value() == null) {
                return null;
            }
            return new MapNotation(dslElement, configurationElement);
        }

        private MapNotation(@NotNull GradleDslExpressionMap dslElement, @Nullable DependencyConfigurationDslElement configurationElement) {
            if (dslElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$MapNotation", "<init>"));
            }
            super(configurationElement);
            this.myDslElement = dslElement;
        }

        @Override
        @NotNull
        public GradleNotNullValue<String> compactNotation() {
            ArtifactDependencySpec spec = new ArtifactDependencySpec(this.name().value(), (String)this.group().value(), (String)this.version().value(), (String)this.classifier().value(), (String)this.extension().value());
            GradleNotNullValue<String> gradleNotNullValue = new GradleNotNullValue<String>(this.myDslElement, spec.compactNotation());
            if (gradleNotNullValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$MapNotation", "compactNotation"));
            }
            return gradleNotNullValue;
        }

        @Override
        @NotNull
        public GradleNotNullValue<String> name() {
            GradleNullableValue<String> name = this.myDslElement.getLiteralProperty("name", String.class);
            assert (name instanceof GradleNotNullValue);
            GradleNotNullValue gradleNotNullValue = (GradleNotNullValue)name;
            if (gradleNotNullValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$MapNotation", "name"));
            }
            return gradleNotNullValue;
        }

        @Override
        @NotNull
        public GradleNullableValue<String> group() {
            GradleNullableValue<String> gradleNullableValue = this.myDslElement.getLiteralProperty("group", String.class);
            if (gradleNullableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$MapNotation", "group"));
            }
            return gradleNullableValue;
        }

        @Override
        @NotNull
        public GradleNullableValue<String> version() {
            GradleNullableValue<String> gradleNullableValue = this.myDslElement.getLiteralProperty("version", String.class);
            if (gradleNullableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$MapNotation", "version"));
            }
            return gradleNullableValue;
        }

        @Override
        public void setVersion(@NotNull String version) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$MapNotation", "setVersion"));
            }
            this.myDslElement.setNewLiteral("version", version);
        }

        @Override
        @NotNull
        public GradleNullableValue<String> classifier() {
            GradleNullableValue<String> gradleNullableValue = this.myDslElement.getLiteralProperty("classifier", String.class);
            if (gradleNullableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$MapNotation", "classifier"));
            }
            return gradleNullableValue;
        }

        @Override
        @NotNull
        public GradleNullableValue<String> extension() {
            GradleNullableValue<String> gradleNullableValue = this.myDslElement.getLiteralProperty("ext", String.class);
            if (gradleNullableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$MapNotation", "extension"));
            }
            return gradleNullableValue;
        }

        @Override
        @NotNull
        protected GradleDslElement getDslElement() {
            GradleDslExpressionMap gradleDslExpressionMap = this.myDslElement;
            if (gradleDslExpressionMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$MapNotation", "getDslElement"));
            }
            return gradleDslExpressionMap;
        }
    }
}

